/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.apache.avro.reflect;

import infinispan.org.apache.avro.reflect.AvroEncode;
import infinispan.org.apache.avro.reflect.FieldAccess;
import infinispan.org.apache.avro.reflect.FieldAccessor;
import infinispan.org.apache.avro.reflect.Stringable;
import java.io.IOException;
import java.lang.reflect.Field;

class FieldAccessReflect
extends FieldAccess {
    FieldAccessReflect() {
    }

    @Override
    protected FieldAccessor getAccessor(Field field) {
        return new ReflectionBasedAccessor(field);
    }

    private final class ReflectionBasedAccessor
    extends FieldAccessor {
        private final Field field;
        private boolean isStringable;
        private boolean isCustomEncoded;

        public ReflectionBasedAccessor(Field field) {
            this.field = field;
            this.field.setAccessible(true);
            this.isStringable = field.isAnnotationPresent(Stringable.class);
            this.isCustomEncoded = field.isAnnotationPresent(AvroEncode.class);
        }

        public String toString() {
            return this.field.getName();
        }

        @Override
        public Object get(Object object) throws IllegalAccessException {
            return this.field.get(object);
        }

        @Override
        public void set(Object object, Object value) throws IllegalAccessException, IOException {
            this.field.set(object, value);
        }

        @Override
        protected Field getField() {
            return this.field;
        }

        @Override
        protected boolean isStringable() {
            return this.isStringable;
        }

        @Override
        protected boolean isCustomEncoded() {
            return this.isCustomEncoded;
        }
    }
}

