/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public class CommonTermsQuery
extends Query {
    protected final List<Term> terms = new ArrayList<Term>();
    protected final boolean disableCoord;
    protected final float maxTermFrequency;
    protected final BooleanClause.Occur lowFreqOccur;
    protected final BooleanClause.Occur highFreqOccur;
    protected float lowFreqBoost = 1.0f;
    protected float highFreqBoost = 1.0f;
    protected float lowFreqMinNrShouldMatch = 0.0f;
    protected float highFreqMinNrShouldMatch = 0.0f;

    public CommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
        this(highFreqOccur, lowFreqOccur, maxTermFrequency, false);
    }

    public CommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, boolean disableCoord) {
        if (highFreqOccur == BooleanClause.Occur.MUST_NOT) {
            throw new IllegalArgumentException("highFreqOccur should be MUST or SHOULD but was MUST_NOT");
        }
        if (lowFreqOccur == BooleanClause.Occur.MUST_NOT) {
            throw new IllegalArgumentException("lowFreqOccur should be MUST or SHOULD but was MUST_NOT");
        }
        this.disableCoord = disableCoord;
        this.highFreqOccur = highFreqOccur;
        this.lowFreqOccur = lowFreqOccur;
        this.maxTermFrequency = maxTermFrequency;
    }

    public void add(Term term) {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        this.terms.add(term);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.terms.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        if (this.terms.size() == 1) {
            return this.newTermQuery(this.terms.get(0), null);
        }
        List<LeafReaderContext> leaves = reader.leaves();
        int maxDoc = reader.maxDoc();
        TermContext[] contextArray = new TermContext[this.terms.size()];
        Term[] queryTerms = this.terms.toArray(new Term[0]);
        this.collectTermContext(reader, leaves, contextArray, queryTerms);
        return this.buildQuery(maxDoc, contextArray, queryTerms);
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.lowFreqMinNrShouldMatch, numOptional);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.highFreqMinNrShouldMatch, numOptional);
    }

    private final int minNrShouldMatch(float minNrShouldMatch, int numOptional) {
        if (minNrShouldMatch >= 1.0f || minNrShouldMatch == 0.0f) {
            return (int)minNrShouldMatch;
        }
        return Math.round(minNrShouldMatch * (float)numOptional);
    }

    protected Query buildQuery(int maxDoc, TermContext[] contextArray, Term[] queryTerms) {
        ArrayList<Query> lowFreqQueries = new ArrayList<Query>();
        ArrayList<Query> highFreqQueries = new ArrayList<Query>();
        for (int i = 0; i < queryTerms.length; ++i) {
            TermContext termContext = contextArray[i];
            if (termContext == null) {
                lowFreqQueries.add(this.newTermQuery(queryTerms[i], null));
                continue;
            }
            if (this.maxTermFrequency >= 1.0f && (float)termContext.docFreq() > this.maxTermFrequency || termContext.docFreq() > (int)Math.ceil(this.maxTermFrequency * (float)maxDoc)) {
                highFreqQueries.add(this.newTermQuery(queryTerms[i], termContext));
                continue;
            }
            lowFreqQueries.add(this.newTermQuery(queryTerms[i], termContext));
        }
        int numLowFreqClauses = lowFreqQueries.size();
        int numHighFreqClauses = highFreqQueries.size();
        BooleanClause.Occur lowFreqOccur = this.lowFreqOccur;
        BooleanClause.Occur highFreqOccur = this.highFreqOccur;
        int lowFreqMinShouldMatch = 0;
        int highFreqMinShouldMatch = 0;
        if (lowFreqOccur == BooleanClause.Occur.SHOULD && numLowFreqClauses > 0) {
            lowFreqMinShouldMatch = this.calcLowFreqMinimumNumberShouldMatch(numLowFreqClauses);
        }
        if (highFreqOccur == BooleanClause.Occur.SHOULD && numHighFreqClauses > 0) {
            highFreqMinShouldMatch = this.calcHighFreqMinimumNumberShouldMatch(numHighFreqClauses);
        }
        if (lowFreqQueries.isEmpty() && highFreqMinShouldMatch == 0 && highFreqOccur != BooleanClause.Occur.MUST) {
            highFreqOccur = BooleanClause.Occur.MUST;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        if (!lowFreqQueries.isEmpty()) {
            BooleanQuery.Builder lowFreq = new BooleanQuery.Builder();
            lowFreq.setDisableCoord(this.disableCoord);
            for (Query query : lowFreqQueries) {
                lowFreq.add(query, lowFreqOccur);
            }
            lowFreq.setMinimumNumberShouldMatch(lowFreqMinShouldMatch);
            BooleanQuery lowFreqQuery = lowFreq.build();
            builder.add(new BoostQuery(lowFreqQuery, this.lowFreqBoost), BooleanClause.Occur.MUST);
        }
        if (!highFreqQueries.isEmpty()) {
            BooleanQuery.Builder highFreq = new BooleanQuery.Builder();
            highFreq.setDisableCoord(this.disableCoord);
            for (Query query : highFreqQueries) {
                highFreq.add(query, highFreqOccur);
            }
            highFreq.setMinimumNumberShouldMatch(highFreqMinShouldMatch);
            BooleanQuery highFreqQuery = highFreq.build();
            builder.add(new BoostQuery(highFreqQuery, this.highFreqBoost), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public void collectTermContext(IndexReader reader, List<LeafReaderContext> leaves, TermContext[] contextArray, Term[] queryTerms) throws IOException {
        TermsEnum termsEnum = null;
        for (LeafReaderContext context : leaves) {
            Fields fields = context.reader().fields();
            for (int i = 0; i < queryTerms.length; ++i) {
                Term term = queryTerms[i];
                TermContext termContext = contextArray[i];
                Terms terms = fields.terms(term.field());
                if (terms == null) continue;
                termsEnum = terms.iterator();
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY || !termsEnum.seekExact(term.bytes())) continue;
                if (termContext == null) {
                    contextArray[i] = new TermContext(reader.getContext(), termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                    continue;
                }
                termContext.register(termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public void setLowFreqMinimumNumberShouldMatch(float min) {
        this.lowFreqMinNrShouldMatch = min;
    }

    public float getLowFreqMinimumNumberShouldMatch() {
        return this.lowFreqMinNrShouldMatch;
    }

    public void setHighFreqMinimumNumberShouldMatch(float min) {
        this.highFreqMinNrShouldMatch = min;
    }

    public float getHighFreqMinimumNumberShouldMatch() {
        return this.highFreqMinNrShouldMatch;
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getLowFreqMinimumNumberShouldMatch() > 0.0f;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.terms.size(); ++i) {
            Term t = this.terms.get(i);
            buffer.append(this.newTermQuery(t, null).toString());
            if (i == this.terms.size() - 1) continue;
            buffer.append(", ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getLowFreqMinimumNumberShouldMatch() > 0.0f || this.getHighFreqMinimumNumberShouldMatch() > 0.0f) {
            buffer.append('~');
            buffer.append("(");
            buffer.append(this.getLowFreqMinimumNumberShouldMatch());
            buffer.append(this.getHighFreqMinimumNumberShouldMatch());
            buffer.append(")");
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.disableCoord ? 1231 : 1237);
        result = 31 * result + Float.floatToIntBits(this.highFreqBoost);
        result = 31 * result + (this.highFreqOccur == null ? 0 : this.highFreqOccur.hashCode());
        result = 31 * result + Float.floatToIntBits(this.lowFreqBoost);
        result = 31 * result + (this.lowFreqOccur == null ? 0 : this.lowFreqOccur.hashCode());
        result = 31 * result + Float.floatToIntBits(this.maxTermFrequency);
        result = 31 * result + Float.floatToIntBits(this.lowFreqMinNrShouldMatch);
        result = 31 * result + Float.floatToIntBits(this.highFreqMinNrShouldMatch);
        result = 31 * result + (this.terms == null ? 0 : this.terms.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonTermsQuery other = (CommonTermsQuery)obj;
        if (this.disableCoord != other.disableCoord) {
            return false;
        }
        if (Float.floatToIntBits(this.highFreqBoost) != Float.floatToIntBits(other.highFreqBoost)) {
            return false;
        }
        if (this.highFreqOccur != other.highFreqOccur) {
            return false;
        }
        if (Float.floatToIntBits(this.lowFreqBoost) != Float.floatToIntBits(other.lowFreqBoost)) {
            return false;
        }
        if (this.lowFreqOccur != other.lowFreqOccur) {
            return false;
        }
        if (Float.floatToIntBits(this.maxTermFrequency) != Float.floatToIntBits(other.maxTermFrequency)) {
            return false;
        }
        if (this.lowFreqMinNrShouldMatch != other.lowFreqMinNrShouldMatch) {
            return false;
        }
        if (this.highFreqMinNrShouldMatch != other.highFreqMinNrShouldMatch) {
            return false;
        }
        return !(this.terms == null ? other.terms != null : !this.terms.equals(other.terms));
    }

    protected Query newTermQuery(Term term, TermContext context) {
        return context == null ? new TermQuery(term) : new TermQuery(term, context);
    }
}

