/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.ast;

import org.hibernate.hql.lucene.internal.ast.HSearchTypeDescriptor;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;

public class HSearchIndexedEntityTypeDescriptor
implements HSearchTypeDescriptor {
    private final Class<?> indexedEntityType;
    private final ClassBasedLucenePropertyHelper propertyHelper;

    public HSearchIndexedEntityTypeDescriptor(Class<?> indexedEntityType, ClassBasedLucenePropertyHelper propertyHelper) {
        this.indexedEntityType = indexedEntityType;
        this.propertyHelper = propertyHelper;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.propertyHelper.exists(this.indexedEntityType, propertyName);
    }

    @Override
    public Class<?> getIndexedEntityType() {
        return this.indexedEntityType;
    }

    @Override
    public boolean isAnalyzed(String propertyName) {
        return this.propertyHelper.isAnalyzed(this.indexedEntityType, propertyName);
    }

    @Override
    public boolean isEmbedded(String propertyName) {
        return this.propertyHelper.isEmbedded(this.indexedEntityType, propertyName);
    }

    public String toString() {
        return this.indexedEntityType.getCanonicalName();
    }
}

