/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LazyLuceneAnalyzer
extends AnalyzerWrapper {
    private static final Log log = LoggerFactory.make();
    private final String name;
    private Analyzer delegate;

    public LazyLuceneAnalyzer(String name) {
        super(Analyzer.GLOBAL_REUSE_STRATEGY);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public void setDelegate(Analyzer analyzer) {
        this.delegate = analyzer;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        this.validate();
        return this.delegate;
    }

    private void validate() {
        if (this.delegate == null) {
            throw log.lazyLuceneAnalyzerNotInitialized(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.name);
        if (this.delegate != null) {
            sb.append(", delegate: ");
            sb.append(this.delegate);
        }
        sb.append(">");
        return sb.toString();
    }
}

