/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.impl;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.FlagsAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.KeywordAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.TypeAttributeImpl;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.LuceneWorksBuilder;
import org.hibernate.search.indexes.serialization.spi.SerializableIndex;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;
import org.hibernate.search.indexes.serialization.spi.SerializableTermVector;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneWorkHydrator
implements LuceneWorksBuilder {
    private static final Log log = LoggerFactory.make();
    private ExtendedSearchIntegrator searchIntegrator;
    private List<LuceneWork> results;
    private ClassLoader loader;
    private Document luceneDocument;
    private List<AttributeImpl> attributes;
    private List<List<AttributeImpl>> tokens;
    private Serializable id;

    public LuceneWorkHydrator(ExtendedSearchIntegrator searchIntegrator) {
        this.searchIntegrator = searchIntegrator;
        this.results = new ArrayList<LuceneWork>();
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public List<LuceneWork> getLuceneWorks() {
        return this.results;
    }

    @Override
    public void addOptimizeAll() {
        this.results.add(OptimizeLuceneWork.INSTANCE);
    }

    @Override
    public void addFlush() {
        this.results.add(FlushLuceneWork.INSTANCE);
    }

    @Override
    public void addPurgeAllLuceneWork(String entityClassName) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, "entity class", this.searchIntegrator.getServiceManager());
        this.results.add(new PurgeAllLuceneWork(entityClass));
    }

    @Override
    public void addIdAsJavaSerialized(byte[] idAsByte) {
        this.id = SerializationHelper.toSerializable(idAsByte, this.loader);
    }

    @Override
    public void addId(Serializable id) {
        this.id = id;
    }

    @Override
    public void addDeleteLuceneWork(String entityClassName, ConversionContext conversionContext) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, "entity class", this.searchIntegrator.getServiceManager());
        DeleteLuceneWork result = new DeleteLuceneWork(this.id, this.objectIdInString(entityClass, this.id, conversionContext), entityClass);
        this.results.add(result);
        this.id = null;
    }

    @Override
    public void addDeleteByQueryLuceneWork(String entityClassName, DeletionQuery deletionQuery) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, "entity class", this.searchIntegrator.getServiceManager());
        DeleteByQueryLuceneWork result = new DeleteByQueryLuceneWork(entityClass, deletionQuery);
        this.results.add(result);
    }

    @Override
    public void addAddLuceneWork(String entityClassName, Map<String, String> fieldToAnalyzerMap, ConversionContext conversionContext) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, "entity class", this.searchIntegrator.getServiceManager());
        AddLuceneWork result = new AddLuceneWork(this.id, this.objectIdInString(entityClass, this.id, conversionContext), entityClass, this.getLuceneDocument(), fieldToAnalyzerMap);
        this.results.add(result);
        this.clearDocument();
        this.id = null;
    }

    @Override
    public void addUpdateLuceneWork(String entityClassName, Map<String, String> fieldToAnalyzerMap, ConversionContext conversionContext) {
        Class<?> entityClass = ClassLoaderHelper.classForName(entityClassName, "entity class", this.searchIntegrator.getServiceManager());
        UpdateLuceneWork result = new UpdateLuceneWork(this.id, this.objectIdInString(entityClass, this.id, conversionContext), entityClass, this.getLuceneDocument(), fieldToAnalyzerMap);
        this.results.add(result);
        this.clearDocument();
        this.id = null;
    }

    private void clearDocument() {
        this.luceneDocument = null;
    }

    @Override
    public void defineDocument() {
        this.getLuceneDocument();
    }

    @Override
    public void addFieldable(byte[] instanceAsByte) {
        this.getLuceneDocument().add((IndexableField)((Object)SerializationHelper.toSerializable(instanceAsByte, this.loader)));
    }

    @Override
    public void addIntNumericField(int value, String name, int precisionStep, SerializableStore store, boolean indexed, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        IntField numField = new IntField(name, value, this.getStore(store));
        numField.setBoost(boost);
        this.getLuceneDocument().add(numField);
    }

    @Override
    public void addLongNumericField(long value, String name, int precisionStep, SerializableStore store, boolean indexed, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        LongField numField = new LongField(name, value, this.getStore(store));
        numField.setBoost(boost);
        this.getLuceneDocument().add(numField);
    }

    @Override
    public void addFloatNumericField(float value, String name, int precisionStep, SerializableStore store, boolean indexed, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        FloatField numField = new FloatField(name, value, this.getStore(store));
        numField.setBoost(boost);
        this.getLuceneDocument().add(numField);
    }

    @Override
    public void addDoubleNumericField(double value, String name, int precisionStep, SerializableStore store, boolean indexed, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        DoubleField numField = new DoubleField(name, value, this.getStore(store));
        numField.setBoost(boost);
        this.getLuceneDocument().add(numField);
    }

    @Override
    public void addFieldWithBinaryData(String name, byte[] value, int offset, int length) {
        StoredField luceneField = new StoredField(name, value, offset, length);
        this.getLuceneDocument().add(luceneField);
    }

    @Override
    public void addFieldWithStringData(String name, String value, SerializableStore store, SerializableIndex index, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        FieldType type = this.identifyFieldType(store == SerializableStore.YES, index != SerializableIndex.NO, index == SerializableIndex.ANALYZED || index == SerializableIndex.ANALYZED_NO_NORMS, termVector, omitNorms, omitTermFreqAndPositions);
        Field luceneField = new Field(name, value, type);
        luceneField.setBoost(boost);
        this.getLuceneDocument().add(luceneField);
    }

    @Override
    public void addFieldWithTokenStreamData(String name, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        FieldType type = this.identifyFieldType(false, true, true, termVector, omitNorms, omitTermFreqAndPositions);
        Field luceneField = new Field(name, (TokenStream)new CopyTokenStream(this.tokens), type);
        luceneField.setBoost(boost);
        this.getLuceneDocument().add(luceneField);
        this.clearTokens();
    }

    private void clearTokens() {
        this.tokens = new ArrayList<List<AttributeImpl>>();
    }

    @Override
    public void addFieldWithSerializableReaderData(String name, byte[] valueAsByte, SerializableTermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        FieldType type = this.identifyFieldType(false, true, true, termVector, omitNorms, omitTermFreqAndPositions);
        Reader value = (Reader)((Object)SerializationHelper.toSerializable(valueAsByte, this.loader));
        Field luceneField = new Field(name, value, type);
        luceneField.setBoost(boost);
        this.getLuceneDocument().add(luceneField);
    }

    @Override
    public void addSerializedAttribute(byte[] bytes) {
        this.getAttributes().add((AttributeImpl)((Object)SerializationHelper.toSerializable(bytes, this.loader)));
    }

    @Override
    public void addAttributeInstance(AttributeImpl attribute) {
        this.getAttributes().add(attribute);
    }

    @Override
    public void addTokenTrackingAttribute(List<Integer> positions) {
        throw new SearchException("Serialization of TokenTrackingAttribute is no longer supported");
    }

    @Override
    public void addCharTermAttribute(CharSequence sequence) {
        CharTermAttributeImpl attr = new CharTermAttributeImpl();
        attr.append(sequence);
        this.getAttributes().add(attr);
    }

    @Override
    public void addPayloadAttribute(byte[] payloads) {
        PayloadAttributeImpl attr = new PayloadAttributeImpl();
        attr.setPayload(new BytesRef(payloads));
        this.getAttributes().add(attr);
    }

    @Override
    public void addKeywordAttribute(boolean isKeyword) {
        KeywordAttributeImpl attr = new KeywordAttributeImpl();
        attr.setKeyword(isKeyword);
        this.getAttributes().add(attr);
    }

    @Override
    public void addPositionIncrementAttribute(int positionIncrement) {
        PositionIncrementAttributeImpl attr = new PositionIncrementAttributeImpl();
        attr.setPositionIncrement(positionIncrement);
        this.getAttributes().add(attr);
    }

    @Override
    public void addFlagsAttribute(int flags) {
        FlagsAttributeImpl attr = new FlagsAttributeImpl();
        attr.setFlags(flags);
        this.getAttributes().add(attr);
    }

    @Override
    public void addTypeAttribute(String type) {
        TypeAttributeImpl attr = new TypeAttributeImpl();
        attr.setType(type);
        this.getAttributes().add(attr);
    }

    @Override
    public void addOffsetAttribute(int startOffset, int endOffset) {
        OffsetAttributeImpl attr = new OffsetAttributeImpl();
        attr.setOffset(startOffset, endOffset);
        this.getAttributes().add(attr);
    }

    @Override
    public void addToken() {
        this.getTokens().add(this.getAttributes());
        this.clearAttributes();
    }

    @Override
    public void addDocValuesFieldWithBinaryData(String name, String type, byte[] value, int offset, int length) {
        Field docValuesField;
        DocValuesType docValuesType = Enum.valueOf(DocValuesType.class, type);
        switch (docValuesType) {
            case BINARY: {
                docValuesField = new BinaryDocValuesField(name, new BytesRef(value, offset, length));
                break;
            }
            case SORTED: {
                docValuesField = new SortedDocValuesField(name, new BytesRef(value, offset, length));
                break;
            }
            case SORTED_SET: {
                docValuesField = new SortedSetDocValuesField(name, new BytesRef(value, offset, length));
                break;
            }
            default: {
                throw log.unexpectedBinaryDocValuesTypeType(type);
            }
        }
        this.getLuceneDocument().add(docValuesField);
    }

    @Override
    public void addDocValuesFieldWithNumericData(String name, String type, long value) {
        Field docValuesField;
        DocValuesType docValuesType = Enum.valueOf(DocValuesType.class, type);
        switch (docValuesType) {
            case NUMERIC: {
                docValuesField = new NumericDocValuesField(name, value);
                break;
            }
            case SORTED_NUMERIC: {
                docValuesField = new SortedNumericDocValuesField(name, value);
                break;
            }
            default: {
                throw log.unexpectedBinaryDocValuesTypeType(type);
            }
        }
        this.getLuceneDocument().add(docValuesField);
    }

    private void clearAttributes() {
        this.attributes = new ArrayList<AttributeImpl>();
    }

    private Document getLuceneDocument() {
        if (this.luceneDocument == null) {
            this.luceneDocument = new Document();
        }
        return this.luceneDocument;
    }

    private String objectIdInString(Class<?> entityClass, Serializable id, ConversionContext conversionContext) {
        EntityIndexBinding indexBindingForEntity = this.searchIntegrator.getIndexBinding(entityClass);
        if (indexBindingForEntity == null) {
            throw new SearchException("Unable to find entity type metadata while deserializing: " + entityClass);
        }
        DocumentBuilderIndexedEntity documentBuilder = indexBindingForEntity.getDocumentBuilder();
        return documentBuilder.objectToString(documentBuilder.getIdKeywordName(), id, conversionContext);
    }

    private FieldType identifyFieldType(boolean stored, boolean indexed, boolean analyzed, SerializableTermVector termVector, boolean omitNorms, boolean omitTermFreqAndPositions) {
        FieldType type = new FieldType();
        type.setStored(stored);
        type.setTokenized(analyzed);
        type.setStoreTermVectors(termVector != SerializableTermVector.NO);
        type.setStoreTermVectorOffsets(termVector == SerializableTermVector.WITH_OFFSETS || termVector == SerializableTermVector.WITH_POSITIONS_OFFSETS);
        type.setStoreTermVectorPositions(termVector == SerializableTermVector.WITH_POSITIONS || termVector == SerializableTermVector.WITH_POSITIONS_OFFSETS);
        type.setOmitNorms(omitNorms);
        type.setIndexOptions(omitTermFreqAndPositions ? IndexOptions.DOCS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        return type;
    }

    private Field.Store getStore(SerializableStore store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
        }
        throw log.unableToConvertSerializableStoreToLuceneStore(store.toString());
    }

    public List<AttributeImpl> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributeImpl>();
        }
        return this.attributes;
    }

    public List<List<AttributeImpl>> getTokens() {
        if (this.tokens == null) {
            this.tokens = new ArrayList<List<AttributeImpl>>();
        }
        return this.tokens;
    }
}

