/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PolymorphicIndexHierarchy {
    private static final Log log = LoggerFactory.make();
    private Map<Class<?>, Set<Class<?>>> classToIndexedClass = new HashMap();

    public void addIndexedClass(Class<?> indexedClass) {
        this.addClass(indexedClass, indexedClass);
        for (Class<?> superClass = indexedClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            this.addClass(superClass, indexedClass);
        }
        for (Class<?> clazz : indexedClass.getInterfaces()) {
            this.addClass(clazz, indexedClass);
        }
    }

    private void addClass(Class<?> superclass, Class<?> indexedClass) {
        Set<Class<?>> classesSet = this.classToIndexedClass.get(superclass);
        if (classesSet == null) {
            classesSet = new HashSet();
            this.classToIndexedClass.put(superclass, classesSet);
        }
        classesSet.add(indexedClass);
    }

    public Set<Class<?>> getIndexedClasses(Class<?>[] classes) {
        if (classes == null) {
            return Collections.emptySet();
        }
        HashSet indexedClasses = new HashSet();
        for (Class<?> clazz : classes) {
            Set<Class<?>> set = this.classToIndexedClass.get(clazz);
            if (set == null) continue;
            indexedClasses.addAll(set);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Targeted indexed classes for %s: %s", (Object)Arrays.toString(classes), (Object)indexedClasses);
        }
        return indexedClasses;
    }
}

