/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedAnalyzer;
import org.hibernate.search.analyzer.impl.ScopedRemoteAnalyzer;
import org.hibernate.search.util.impl.ScopedLuceneAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ScopedAnalyzerReference
implements AnalyzerReference {
    private static final Log log = LoggerFactory.make();
    private AnalyzerReference globalAnalyzerReference;
    private final ScopedAnalyzer scopedAnalyzer;

    private ScopedAnalyzerReference(AnalyzerReference globalAnalyzerReference, ScopedAnalyzer scopedAnalyzer) {
        this.globalAnalyzerReference = globalAnalyzerReference;
        this.scopedAnalyzer = scopedAnalyzer;
    }

    @Override
    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        return LuceneAnalyzerReference.class.isAssignableFrom(analyzerType) ? this.scopedAnalyzer instanceof ScopedLuceneAnalyzer : RemoteAnalyzerReference.class.isAssignableFrom(analyzerType) && this.scopedAnalyzer instanceof ScopedRemoteAnalyzer;
    }

    @Override
    public <T extends AnalyzerReference> T unwrap(Class<T> analyzerType) {
        if (LuceneAnalyzerReference.class.isAssignableFrom(analyzerType)) {
            if (!(this.scopedAnalyzer instanceof ScopedLuceneAnalyzer)) {
                throw log.scopedAnalyzerIsNotLucene(this.scopedAnalyzer);
            }
            return (T)new LuceneAnalyzerReference((ScopedLuceneAnalyzer)this.scopedAnalyzer);
        }
        if (RemoteAnalyzerReference.class.isAssignableFrom(analyzerType)) {
            if (!(this.scopedAnalyzer instanceof ScopedRemoteAnalyzer)) {
                throw log.scopedAnalyzerIsNotRemote(this.scopedAnalyzer);
            }
            return (T)new RemoteAnalyzerReference((ScopedRemoteAnalyzer)this.scopedAnalyzer);
        }
        return (T)this;
    }

    @Override
    public void close() {
        this.scopedAnalyzer.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append("scopedAnalyzer: ");
        sb.append(this.scopedAnalyzer);
        sb.append(">");
        return sb.toString();
    }

    public static class Builder {
        private AnalyzerReference globalAnalyzerReference;
        private final ScopedAnalyzer scopedAnalyzer;

        public Builder(AnalyzerReference globalAnalyzerReference) {
            if (globalAnalyzerReference instanceof ScopedAnalyzerReference) {
                ScopedAnalyzerReference original = (ScopedAnalyzerReference)globalAnalyzerReference;
                this.globalAnalyzerReference = original.globalAnalyzerReference;
                this.scopedAnalyzer = original.scopedAnalyzer.clone();
            } else {
                this.globalAnalyzerReference = globalAnalyzerReference;
                this.scopedAnalyzer = globalAnalyzerReference instanceof RemoteAnalyzerReference ? new ScopedRemoteAnalyzer(globalAnalyzerReference) : new ScopedLuceneAnalyzer(globalAnalyzerReference);
            }
        }

        public Builder addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzer.addScopedAnalyzerReference(scope, analyzerReference);
            return this;
        }

        public Builder addPassThroughAnalyzerReference(String scope) {
            this.scopedAnalyzer.addScopedPassThroughAnalyzerReference(scope);
            return this;
        }

        public Builder setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzer.setGlobalAnalyzerReference(globalAnalyzerReference);
            return this;
        }

        public AnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        public ScopedAnalyzerReference build() {
            return new ScopedAnalyzerReference(this.globalAnalyzerReference, this.scopedAnalyzer);
        }
    }
}

