/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.impl.DirectoryImplementor;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.InfinispanIndexInput;
import org.infinispan.lucene.impl.SingleChunkIndexInput;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class DirectoryLucene
extends Directory
implements DirectoryExtensions {
    private static final Log log = LogFactory.getLog(DirectoryLucene.class);
    private static final boolean trace = log.isTraceEnabled();
    private final DirectoryImplementor impl;
    private final String indexName;
    private final Executor deleteExecutor;
    private final int affinitySegmentId;
    private volatile LockFactory lockFactory;

    public DirectoryLucene(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker, boolean fileListUpdatedAsync, Executor deleteExecutor, int affinitySegmentId) {
        this.deleteExecutor = deleteExecutor;
        this.affinitySegmentId = affinitySegmentId;
        this.impl = new DirectoryImplementor(metadataCache, chunksCache, distLocksCache, indexName, chunkSize, readLocker, fileListUpdatedAsync, affinitySegmentId);
        this.indexName = indexName;
        this.lockFactory = lf;
    }

    @Override
    public void deleteFile(String name) {
        this.ensureOpen();
        this.deleteExecutor.execute(new DeleteTask(name));
    }

    @Override
    public void renameFile(String from, String to) {
        this.impl.renameFile(from, to);
    }

    @Override
    public long fileLength(String name) {
        this.ensureOpen();
        return this.impl.fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.impl.createOutput(name);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        IndexInputContext indexInputContext = this.impl.openInput(name);
        if (indexInputContext.readLocks == null) {
            return new SingleChunkIndexInput(indexInputContext);
        }
        return new InfinispanIndexInput(indexInputContext);
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + "'}";
    }

    @Override
    public String[] listAll() {
        return this.impl.list();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public int getAffinitySegmentId() {
        return this.affinitySegmentId;
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public Lock obtainLock(String lockName) throws IOException {
        return this.lockFactory.obtainLock(this, lockName);
    }

    @Override
    public int getChunkSize() {
        return this.impl.getChunkSize();
    }

    @Override
    public Cache getMetadataCache() {
        return this.impl.getMetadataCache();
    }

    @Override
    public Cache getDataCache() {
        return this.impl.getDataCache();
    }

    @Override
    public void forceUnlock(String lockName) {
        FileCacheKey fileCacheKey;
        AdvancedCache lockCache = this.getDistLockCache().getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD});
        Object previousValue = lockCache.remove((Object)(fileCacheKey = new FileCacheKey(this.indexName, lockName, this.affinitySegmentId)));
        if (previousValue != null && trace) {
            log.tracef("Lock forcibly removed for index: %s", (Object)this.indexName);
        }
    }

    public Cache<Object, Integer> getDistLockCache() {
        return this.impl.getDistLocksCache();
    }

    final class DeleteTask
    implements Runnable {
        private final String fileName;

        private DeleteTask(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void run() {
            DirectoryLucene.this.impl.deleteFile(this.fileName);
        }
    }
}

