/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.SlicedBufferIndexInput;

public final class SingleChunkIndexInput
extends IndexInput {
    private final byte[] buffer;
    private int bufferPosition;

    public SingleChunkIndexInput(IndexInputContext iic) {
        super(iic.fileKey.getFileName());
        ChunkCacheKey key = new ChunkCacheKey(iic.fileKey.getIndexName(), iic.fileKey.getFileName(), 0, iic.fileMetadata.getBufferSize(), iic.affinitySegmentId);
        byte[] b = (byte[])iic.chunksCache.get((Object)key);
        this.buffer = b == null ? new byte[0] : b;
        this.bufferPosition = 0;
    }

    @Override
    public void close() {
    }

    @Override
    public long getFilePointer() {
        return this.bufferPosition;
    }

    @Override
    public long length() {
        return this.buffer.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.buffer.length) {
            throw new IOException("Read past EOF");
        }
        return this.buffer[this.bufferPosition++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.buffer.length - this.bufferPosition < len) {
            throw new IOException("Read past EOF");
        }
        System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
        this.bufferPosition += len;
    }

    @Override
    public void seek(long pos) {
        this.bufferPosition = (int)Math.min(pos, (long)this.buffer.length);
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new SlicedBufferIndexInput(sliceDescription, this.buffer, offset, length);
    }
}

