/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import java.util.List;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.predicate.FilterComparisonPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterConjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterDisjunctionPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterInPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterIsNullPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterLikePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterNegationPredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRangePredicate;
import org.infinispan.objectfilter.impl.hql.predicate.FilterRootPredicate;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.jboss.logging.Logger;

public final class FilterPredicateFactory
implements PredicateFactory<BooleanExpr> {
    private static final Log log = Logger.getMessageLogger(Log.class, FilterPredicateFactory.class.getName());
    private final EntityNamesResolver entityNamesResolver;
    private final ObjectPropertyHelper propertyHelper;

    public FilterPredicateFactory(EntityNamesResolver entityNamesResolver, ObjectPropertyHelper propertyHelper) {
        this.entityNamesResolver = entityNamesResolver;
        this.propertyHelper = propertyHelper;
    }

    @Override
    public RootPredicate<BooleanExpr> getRootPredicate(String entityType) {
        if (this.entityNamesResolver.getClassFromName(entityType) == null) {
            throw log.getUnknownEntity(entityType);
        }
        return new FilterRootPredicate();
    }

    @Override
    public ComparisonPredicate<BooleanExpr> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object comparisonValue) {
        PropertyValueExpr valueExpr = new PropertyValueExpr(propertyPath, this.propertyHelper.isRepeatedProperty(entityType, propertyPath));
        return new FilterComparisonPredicate(valueExpr, comparisonType, comparisonValue);
    }

    @Override
    public InPredicate<BooleanExpr> getInPredicate(String entityType, List<String> propertyPath, List<Object> values) {
        PropertyValueExpr valueExpr = new PropertyValueExpr(propertyPath, this.propertyHelper.isRepeatedProperty(entityType, propertyPath));
        return new FilterInPredicate(valueExpr, values);
    }

    @Override
    public RangePredicate<BooleanExpr> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        PropertyValueExpr valueExpr = new PropertyValueExpr(propertyPath, this.propertyHelper.isRepeatedProperty(entityType, propertyPath));
        return new FilterRangePredicate(valueExpr, lowerValue, upperValue);
    }

    @Override
    public NegationPredicate<BooleanExpr> getNegationPredicate() {
        return new FilterNegationPredicate();
    }

    @Override
    public DisjunctionPredicate<BooleanExpr> getDisjunctionPredicate() {
        return new FilterDisjunctionPredicate();
    }

    @Override
    public ConjunctionPredicate<BooleanExpr> getConjunctionPredicate() {
        return new FilterConjunctionPredicate();
    }

    @Override
    public LikePredicate<BooleanExpr> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        PropertyValueExpr valueExpr = new PropertyValueExpr(propertyPath, this.propertyHelper.isRepeatedProperty(entityType, propertyPath));
        return new FilterLikePredicate(valueExpr, patternValue, escapeCharacter);
    }

    @Override
    public IsNullPredicate<BooleanExpr> getIsNullPredicate(String entityType, List<String> propertyPath) {
        PropertyValueExpr valueExpr = new PropertyValueExpr(propertyPath, this.propertyHelper.isRepeatedProperty(entityType, propertyPath));
        return new FilterIsNullPredicate(valueExpr);
    }
}

