/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.search.Sort;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.clustered.ClusteredQueryCommand;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedLazyIterator
extends DistributedIterator {
    private final UUID queryId;
    private final ExecutorService asyncExecutor;
    private final ClusteredQueryInvoker invoker;
    private static final Log log = LogFactory.getLog(DistributedLazyIterator.class);

    public DistributedLazyIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, UUID id, HashMap<UUID, ClusteredTopDocs> topDocsResponses, ExecutorService asyncExecutor, AdvancedCache<?, ?> cache) {
        super(sort, fetchSize, resultSize, maxResults, firstResult, topDocsResponses, cache);
        this.queryId = id;
        this.asyncExecutor = asyncExecutor;
        this.invoker = new ClusteredQueryInvoker((Cache<?, ?>)cache, asyncExecutor);
    }

    @Override
    public void close() {
        ClusteredQueryCommand killQuery = ClusteredQueryCommand.destroyLazyQuery(this.cache, this.queryId);
        ClusteredQueryInvoker invoker = new ClusteredQueryInvoker((Cache<?, ?>)this.cache, this.asyncExecutor);
        try {
            invoker.broadcast(killQuery);
        }
        catch (Exception e) {
            log.error((Object)"Could not close the distributed iterator", (Throwable)e);
        }
    }

    @Override
    public Object fetchValue(int scoreIndex, ClusteredTopDocs topDoc) {
        Object value = null;
        try {
            value = this.invoker.getValue(scoreIndex, topDoc.getNodeAddress(), this.queryId);
        }
        catch (Exception e) {
            log.error((Object)("Error while trying to remoting fetch next value: " + e.getMessage()));
        }
        return value;
    }
}

