/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalAuthorizationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalAuthorizationConfiguration> {
    public static final Log log = LogFactory.getLog(GlobalAuthorizationConfigurationBuilder.class);
    private final AttributeSet attributes;
    private final Map<String, GlobalRoleConfigurationBuilder> roles = new HashMap<String, GlobalRoleConfigurationBuilder>();

    public GlobalAuthorizationConfigurationBuilder(GlobalSecurityConfigurationBuilder builder) {
        super(builder.getGlobalConfig());
        this.attributes = GlobalAuthorizationConfiguration.attributeDefinitionSet();
    }

    public GlobalAuthorizationConfigurationBuilder enable() {
        this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).set(true);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder disable() {
        this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).set(false);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).set(enabled);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder auditLogger(AuditLogger auditLogger) {
        this.attributes.attribute(GlobalAuthorizationConfiguration.AUDIT_LOGGER).set(auditLogger);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder principalRoleMapper(PrincipalRoleMapper principalRoleMapper) {
        this.attributes.attribute(GlobalAuthorizationConfiguration.PRINCIPAL_ROLE_MAPPER).set(principalRoleMapper);
        return this;
    }

    public GlobalRoleConfigurationBuilder role(String name) {
        GlobalRoleConfigurationBuilder role = new GlobalRoleConfigurationBuilder(name, this);
        this.roles.put(name, role);
        return role;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).get().booleanValue() && this.attributes.attribute(GlobalAuthorizationConfiguration.PRINCIPAL_ROLE_MAPPER).get() == null) {
            throw log.invalidPrincipalRoleMapper();
        }
    }

    @Override
    public GlobalAuthorizationConfiguration create() {
        HashMap<String, Role> rolesCfg = new HashMap<String, Role>();
        for (GlobalRoleConfigurationBuilder role : this.roles.values()) {
            Role roleCfg = role.create();
            rolesCfg.put(roleCfg.getName(), roleCfg);
        }
        this.attributes.attribute(GlobalAuthorizationConfiguration.ROLES).set(rolesCfg);
        return new GlobalAuthorizationConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(GlobalAuthorizationConfiguration template) {
        this.attributes.read(template.attributes());
        this.roles.clear();
        for (Role role : template.roles().values()) {
            this.role(role.getName()).read(role);
        }
        return this;
    }
}

