/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.metadata.Metadata;

public class MetadataTransientMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    Object value;
    Metadata metadata;
    long created;
    long lastUsed;

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long now) {
        this(key, value, metadata, now, now);
    }

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long lastUsed, long created) {
        super(key);
        this.value = value;
        this.metadata = metadata;
        this.lastUsed = lastUsed;
        this.created = created;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue toInternalCacheValue() {
        return new MetadataTransientMortalCacheValue(this.value, this.metadata, this.created, this.lastUsed);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
            output.writeObject(ice.metadata);
            UnsignedNumeric.writeUnsignedLong(output, ice.created);
            UnsignedNumeric.writeUnsignedLong(output, ice.lastUsed);
        }

        @Override
        public MetadataTransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientMortalCacheEntry(k, v, metadata, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 79;
        }

        @Override
        public Set<Class<? extends MetadataTransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataTransientMortalCacheEntry.class);
        }
    }
}

