/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ExpirationManagerImpl<K, V>
implements ExpirationManager<K, V> {
    protected static final Log log = LogFactory.getLog(ExpirationManagerImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected ScheduledFuture<?> expirationTask;
    protected ScheduledExecutorService executor;
    protected Configuration configuration;
    protected PersistenceManager persistenceManager;
    protected DataContainer<K, V> dataContainer;
    protected CacheNotifier<K, V> cacheNotifier;
    protected TimeService timeService;
    protected boolean enabled;
    protected String cacheName;
    protected ConcurrentMap<K, Object> expiring;

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.executors.expiration") ScheduledExecutorService executor, Cache<K, V> cache, Configuration cfg, DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, CacheNotifier<K, V> cacheNotifier, TimeService timeService) {
        this.initialize(executor, cache.getName(), cfg, dataContainer, persistenceManager, cacheNotifier, timeService);
    }

    void initialize(ScheduledExecutorService executor, String cacheName, Configuration cfg, DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, CacheNotifier<K, V> cacheNotifier, TimeService timeService) {
        this.executor = executor;
        this.configuration = cfg;
        this.cacheName = cacheName;
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.cacheNotifier = cacheNotifier;
        this.timeService = timeService;
        this.expiring = new EquivalentConcurrentHashMapV8<K, Object>(cfg.dataContainer().keyEquivalence(), cfg.dataContainer().valueEquivalence());
    }

    @Start(priority=55)
    public void start() {
        this.enabled = this.configuration.expiration().reaperEnabled();
        if (this.enabled) {
            long expWakeUpInt = this.configuration.expiration().wakeUpInterval();
            if (expWakeUpInt <= 0L) {
                log.notStartingEvictionThread();
                this.enabled = false;
            } else {
                this.expirationTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), expWakeUpInt, expWakeUpInt, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                long currentTimeMillis = this.timeService.wallClockTime();
                Iterator<InternalCacheEntry<K, V>> purgeCandidates = this.dataContainer.iteratorIncludingExpired();
                while (purgeCandidates.hasNext()) {
                    InternalCacheEntry<K, V> e = purgeCandidates.next();
                    if (!e.isExpired(currentTimeMillis)) continue;
                    this.handleInMemoryExpiration(e, currentTimeMillis);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", (Object)Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void handleInMemoryExpiration(InternalCacheEntry<K, V> entry, long currentTime) {
        this.dataContainer.compute(entry.getKey(), (k, oldEntry, factory) -> {
            if (entry == oldEntry) {
                this.persistenceManager.deleteFromAllStores(k, PersistenceManager.AccessMode.BOTH);
                if (this.cacheNotifier != null) {
                    this.cacheNotifier.notifyCacheEntryExpired(k, entry.getValue(), entry.getMetadata(), null);
                }
                return null;
            }
            return oldEntry;
        });
    }

    @Override
    public void handleInStoreExpiration(K key) {
        this.dataContainer.compute(key, (k, oldEntry, factory) -> {
            if (oldEntry == null || oldEntry.canExpire() && oldEntry.isExpired(this.timeService.time())) {
                this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                if (this.cacheNotifier != null) {
                    Metadata metadata;
                    Object value;
                    if (oldEntry != null) {
                        value = oldEntry.getValue();
                        metadata = oldEntry.getMetadata();
                    } else {
                        value = null;
                        metadata = null;
                    }
                    this.cacheNotifier.notifyCacheEntryExpired(k, value, metadata, null);
                }
                return null;
            }
            return oldEntry;
        });
    }

    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        this.dataContainer.compute(marshalledEntry.getKey(), (key, oldEntry, factory) -> {
            InternalMetadata metadata;
            Object value;
            boolean shouldRemove;
            if (oldEntry == null) {
                shouldRemove = true;
                value = marshalledEntry.getValue();
                metadata = marshalledEntry.getMetadata();
            } else if (oldEntry.canExpire()) {
                metadata = marshalledEntry.getMetadata();
                value = marshalledEntry.getValue();
                shouldRemove = !(metadata != null && !oldEntry.getMetadata().equals(metadata) || value != null && !value.equals(oldEntry.getValue()));
            } else {
                shouldRemove = false;
                value = null;
                metadata = null;
            }
            if (shouldRemove) {
                this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                if (this.cacheNotifier != null) {
                    this.cacheNotifier.notifyCacheEntryExpired(key, value, metadata, null);
                }
                return null;
            }
            return oldEntry;
        });
    }

    @Override
    public void registerWriteIncoming(K key) {
        this.expiring.put(key, key);
    }

    @Override
    public void unregisterWrite(K key) {
        this.expiring.remove(key);
    }

    @Stop(priority=5)
    public void stop() {
        if (this.expirationTask != null) {
            this.expirationTask.cancel(true);
        }
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            LogFactory.pushNDC(ExpirationManagerImpl.this.cacheName, trace);
            try {
                ExpirationManagerImpl.this.processExpiration();
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }
    }
}

