/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.jcache.annotation.Contracts;

@ApplicationScoped
public class DefaultCacheResolver
implements CacheResolver {
    private CacheManager defaultCacheManager;

    DefaultCacheResolver() {
        CachingProvider provider = Caching.getCachingProvider();
        this.defaultCacheManager = provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader());
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        return this.getOrCreateCache(cacheName);
    }

    private synchronized <K, V> Cache<K, V> getOrCreateCache(String cacheName) {
        Cache cache = this.defaultCacheManager.getCache(cacheName);
        if (cache != null) {
            return cache;
        }
        return this.defaultCacheManager.createCache(cacheName, (Configuration)new MutableConfiguration());
    }
}

