/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
public class ListExternalizer
extends AbstractExternalizer<List> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

    public ListExternalizer() {
        this.numbers.put(ArrayList.class, 0);
        this.numbers.put(this.getPrivateArrayListClass(), 0);
        this.numbers.put(LinkedList.class, 1);
    }

    @Override
    public void writeObject(ObjectOutput output, List list) throws IOException {
        int number = this.numbers.get(list.getClass(), -1);
        output.writeByte(number);
        MarshallUtil.marshallCollection(list, output);
    }

    @Override
    public List readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        int size = UnsignedNumeric.readUnsignedInt(input);
        AbstractList subject = null;
        switch (magicNumber) {
            case 0: {
                subject = new ArrayList(size);
                break;
            }
            case 1: {
                subject = new LinkedList();
            }
        }
        for (int i = 0; i < size; ++i) {
            subject.add(input.readObject());
        }
        return subject;
    }

    @Override
    public Integer getId() {
        return 0;
    }

    @Override
    public Set<Class<? extends List>> getTypeClasses() {
        return Util.asSet(ArrayList.class, LinkedList.class, this.getPrivateArrayListClass());
    }

    private Class<List> getPrivateArrayListClass() {
        return Util.loadClass("java.util.Arrays$ArrayList", List.class.getClassLoader());
    }
}

