
package org.infinispan.util.logging;

import java.io.Serializable;
import java.security.Permission;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.persistence.support.SingletonCacheWriter.PushStateException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-05-23T06:12:50-0400")
public class Log_$logger
    extends DelegatingBasicLogger
    implements Serializable, Log, BasicLogger
{

    private final static long serialVersionUID = 1L;
    private final static java.lang.String FQCN = Log_$logger.class.getName();
    private final static java.lang.String errorReadingProperties = "ISPN000004: Unexpected error reading properties";
    private final static java.lang.String unableToCopyEntryForUpdate = "ISPN000005: Detected write skew on key [%s]. Another process has changed the entry since we last read it! Unable to copy entry for update.";
    private final static java.lang.String remoteExecutionFailed = "ISPN000006: Failed remote execution on node %s";
    private final static java.lang.String localExecutionFailed = "ISPN000007: Failed local execution ";
    private final static java.lang.String cannotSelectRandomMembers = "ISPN000008: Can not select %s random members for %s";
    private final static java.lang.String problemApplyingStateForKey = "ISPN000016: Problem %s encountered when applying state for key %s!";
    private final static java.lang.String expectedJustOneResponse = "ISPN000021: Expected just one response; got %s";
    private final static java.lang.String notStartingEvictionThread = "ISPN000025: wakeUpInterval is <= 0, not starting expired purge thread";
    private final static java.lang.String exceptionPurgingDataContainer = "ISPN000026: Caught exception purging data container!";
    private final static java.lang.String unableToPassivateEntry = "ISPN000028: Unable to passivate entry under %s";
    private final static java.lang.String passivatingAllEntries = "ISPN000029: Passivating all entries to disk";
    private final static java.lang.String passivatedEntries = "ISPN000030: Passivated %d entries in %s";
    private final static java.lang.String mbeansSuccessfullyRegistered = "ISPN000031: MBeans were successfully registered to the platform MBean server.";
    private final static java.lang.String problemsUnregisteringMBeans = "ISPN000032: Problems un-registering MBeans";
    private final static java.lang.String unableToUnregisterMBeanWithPattern = "ISPN000033: Unable to unregister Cache MBeans with pattern %s";
    private final static java.lang.String jmxMBeanAlreadyRegistered = "ISPN000034: There's already a JMX MBean instance %s already registered under '%s' JMX domain. If you want to allow multiple instances configured with same JMX domain enable 'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element";
    private final static java.lang.String couldNotFindAttribute = "ISPN000036: Did not find attribute %s";
    private final static java.lang.String failedToUpdateAttribute = "ISPN000037: Failed to update attribute name %s with value %s";
    private final static java.lang.String queriedAttributeNotFound = "ISPN000042: Did not find queried attribute with name %s";
    private final static java.lang.String errorWritingValueForAttribute = "ISPN000043: Exception while writing value for attribute %s";
    private final static java.lang.String couldNotInvokeSetOnAttribute = "ISPN000044: Could not invoke set on attribute %s with value %s";
    private final static java.lang.String unknownResponsesFromRemoteCache = "ISPN000046: Unknown responses from remote cache: %s";
    private final static java.lang.String errorDoingRemoteCall = "ISPN000047: Error while doing remote call";
    private final static java.lang.String interruptedWaitingAsyncStorePush = "ISPN000048: Interrupted or timeout while waiting for AsyncCacheWriter worker threads to push all state to the decorated store";
    private final static java.lang.String interruptedAcquiringLock = "ISPN000052: Interrupted on acquireLock for %d milliseconds!";
    private final static java.lang.String unableToProcessAsyncModifications = "ISPN000053: Unable to process some async modifications after %d retries!";
    private final static java.lang.String unexpectedErrorInAsyncStoreCoordinator = "ISPN000055: Unexpected error in AsyncStoreCoordinator thread. AsyncCacheWriter is dead!";
    private final static java.lang.String errorChangingSingletonStoreStatus = "ISPN000058: Exception reported changing cache active status";
    private final static java.lang.String errorMarshallingObject = "ISPN000065: Exception while marshalling object: %s";
    private final static java.lang.String unableToReadVersionId = "ISPN000066: Unable to read version id from first two bytes of stream, barfing.";
    private final static java.lang.String exceptionHandlingCommand = "ISPN000071: Caught exception when handling command %s";
    private final static java.lang.String unexpectedErrorReplicating = "ISPN000073: Unexpected error while replicating";
    private final static java.lang.String msgOrMsgBufferEmpty = "ISPN000077: Message or message buffer is null or empty.";
    private final static java.lang.String startingJGroupsChannel = "ISPN000078: Starting JGroups channel %s";
    private final static java.lang.String localAndPhysicalAddress = "ISPN000079: Channel %s local address is %s, physical addresses are %s";
    private final static java.lang.String disconnectJGroups = "ISPN000080: Disconnecting JGroups channel %s";
    private final static java.lang.String problemClosingChannel = "ISPN000081: Problem closing channel %s; setting it to null";
    private final static java.lang.String stoppingRpcDispatcher = "ISPN000082: Stopping the RpcDispatcher for channel %s";
    private final static java.lang.String wrongTypeForJGroupsChannelLookup = "ISPN000083: Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.";
    private final static java.lang.String errorInstantiatingJGroupsChannelLookup = "ISPN000084: Errors instantiating [%s]! Not using a channel lookup.";
    private final static java.lang.String errorCreatingChannelFromConfigFile = "ISPN000085: Error while trying to create a channel using the specified configuration file: %s";
    private final static java.lang.String errorCreatingChannelFromXML = "ISPN000086: Error while trying to create a channel using the specified configuration XML: %s";
    private final static java.lang.String errorCreatingChannelFromConfigString = "ISPN000087: Error while trying to create a channel using the specified configuration string: %s";
    private final static java.lang.String unableToUseJGroupsPropertiesProvided = "ISPN000088: Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!";
    private final static java.lang.String interruptedWaitingForCoordinator = "ISPN000089: getCoordinator(): Interrupted while waiting for members to be set";
    private final static java.lang.String receivedMergedView = "ISPN000093: Received new, MERGED cluster view for channel %s: %s";
    private final static java.lang.String receivedClusterView = "ISPN000094: Received new cluster view for channel %s: %s";
    private final static java.lang.String errorProcessing1pcPrepareCommand = "ISPN000097: Error while processing a prepare in a single-phase transaction";
    private final static java.lang.String errorRollingBack = "ISPN000098: Exception during rollback";
    private final static java.lang.String unfinishedTransactionsRemain = "ISPN000100: Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.";
    private final static java.lang.String failedSynchronizationRegistration = "ISPN000101: Failed synchronization registration";
    private final static java.lang.String unableToRollbackGlobalTx = "ISPN000102: Unable to roll back global transaction %s";
    private final static java.lang.String fallingBackToEmbeddedTm = "ISPN000104: Falling back to EmbeddedTransactionManager from Infinispan";
    private final static java.lang.String failedToCreateInitialCtx = "ISPN000105: Failed creating initial JNDI context";
    private final static java.lang.String unableToInvokeWebsphereStaticGetTmMethod = "ISPN000106: Found WebSphere TransactionManager factory class [%s], but couldn't invoke its static 'getTransactionManager' method";
    private final static java.lang.String retrievingTm = "ISPN000107: Retrieving transaction manager %s";
    private final static java.lang.String errorEnlistingResource = "ISPN000108: Error enlisting resource";
    private final static java.lang.String beforeCompletionFailed = "ISPN000109: beforeCompletion() failed for %s";
    private final static java.lang.String unexpectedErrorFromResourceManager = "ISPN000110: Unexpected error from resource manager!";
    private final static java.lang.String afterCompletionFailed = "ISPN000111: afterCompletion() failed for %s";
    private final static java.lang.String errorCommittingTx = "ISPN000112: exception while committing";
    private final static java.lang.String recoveryIgnored = "ISPN000115: Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646";
    private final static java.lang.String missingListPreparedTransactions = "ISPN000116: Missing the list of prepared transactions from node %s. Received response is %s";
    private final static java.lang.String preparedTxAlreadyExists = "ISPN000117: There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?";
    private final static java.lang.String unableToSetValue = "ISPN000121: Unable to set value!";
    private final static java.lang.String failedToCallStopAfterFailure = "ISPN000126: Attempted to stop() from FAILED state, but caught exception; try calling destroy()";
    private final static java.lang.String version = "ISPN000128: Infinispan version: %s";
    private final static java.lang.String cacheNotStarted = "ISPN000129: Received a remote call but the cache is not in STARTED state - ignoring call.";
    private final static java.lang.String noAnnotateMethodsFoundInListener = "ISPN000133: Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.";
    private final static java.lang.String unableToInvokeListenerMethodAndRemoveListener = "ISPN000134: Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!";
    private final static java.lang.String unableToLockToInvalidate = "ISPN000135: Could not lock key %s in order to invalidate from L1 at node %s, skipping....";
    private final static java.lang.String executionError = "ISPN000136: Error executing command %s, writing keys %s";
    private final static java.lang.String failedInvalidatingRemoteCache = "ISPN000137: Failed invalidating remote cache";
    private final static java.lang.String couldNotRegisterObjectName = "ISPN000138: Could not register object with name: %s";
    private final static java.lang.String couldNotRollbackPrepared1PcTransaction = "ISPN000141: Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s";
    private final static java.lang.String failedLoadingValueFromCacheStore = "ISPN000144: Failed loading value for key %s from cache store";
    private final static java.lang.String failedToInvalidateKeys = "ISPN000147: Error invalidating keys from L1 after rehash";
    private final static java.lang.String staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup = "ISPN000149: Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup";
    private final static java.lang.String passivationWithoutEviction = "ISPN000152: Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.";
    private final static java.lang.String couldNotCompleteInjectedTransaction = "ISPN000160: Could not complete injected transaction.";
    private final static java.lang.String usingBatchModeTransactionManager = "ISPN000161: Using a batchMode transaction manager";
    private final static java.lang.String couldNotInstantiateTransactionManager = "ISPN000162: Could not instantiate transaction manager";
    private final static java.lang.String customInterceptorExpectsInjection = "ISPN000173: Custom interceptor %s has used @Inject, @Start or @Stop. These methods will not be processed. Please extend org.infinispan.interceptors.base.BaseCustomInterceptor instead, and your custom interceptor will have access to a cache and cacheManager.  Override stop() and start() for lifecycle methods.";
    private final static java.lang.String randomCacheModeSynonymsDeprecated = "ISPN000177: %s has been deprecated as a synonym for %s. Use one of %s instead";
    private final static java.lang.String errorProcessing2pcCommitCommand = "ISPN000188: Error while processing a commit in a two-phase transaction";
    private final static java.lang.String componentFailedToStop = "ISPN000189: While stopping a cache or cache manager, one of its components failed to stop";
    private final static java.lang.String localIndexingWithSharedCacheLoaderRequiresPreload = "ISPN000191: When indexing locally a cache with shared cache loader, preload must be enabled";
    private final static java.lang.String hashNumVirtualNodesDeprecated = "ISPN000192: hash's 'numVirtualNodes' attribute has been deprecated. Please use hash.numSegments instead";
    private final static java.lang.String consistentHashDeprecated = "ISPN000193: hash's 'consistentHash' attribute has been deprecated. Please use hash.consistentHashFactory instead";
    private final static java.lang.String failedLoadingKeysFromCacheStore = "ISPN000194: Failed loading keys from cache store";
    private final static java.lang.String rebalanceError = "ISPN000195: Error during rebalance for cache %s on node %s";
    private final static java.lang.String failedToRecoverClusterState = "ISPN000196: Failed to recover cluster state after the current node became the coordinator (or after merge)";
    private final static java.lang.String errorUpdatingMembersList = "ISPN000197: Error updating cluster member list";
    private final static java.lang.String unableToRegisterMBeans0 = "ISPN000198: Unable to register MBeans for default cache";
    private final static java.lang.String unableToRegisterMBeans1 = "ISPN000199: Unable to register MBeans for named cache %s";
    private final static java.lang.String unableToRegisterCacheManagerMBeans = "ISPN000200: Unable to register MBeans for cache manager";
    private final static java.lang.String cacheBackupsDataToSameSite = "ISPN000201: This cache is configured to backup to its own site (%s).";
    private final static java.lang.String warnXsiteBackupFailed = "ISPN000202: Problems backing up data for cache %s to site %s: %s";
    private final static java.lang.String cannotRespondToRollback = "ISPN000203: The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    private final static java.lang.String cannotRespondToCommit = "ISPN000204: The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    private final static java.lang.String tryingToBringOnlineNonexistentSite = "ISPN000205: Trying to bring back an non-existent site (%s)!";
    private final static java.lang.String couldNotExecuteCancellationLocally = "ISPN000206: Could not execute cancellation command locally";
    private final static java.lang.String couldNotInterruptThread = "ISPN000207: Could not interrupt as no thread found for command uuid %s";
    private final static java.lang.String noLiveOwnersFoundForSegments = "ISPN000208: No live owners found for segments %s of cache %s. Excluded owners: %s";
    private final static java.lang.String failedToRetrieveTransactionsForSegments = "ISPN000209: Failed to retrieve transactions of cache %s from node %s, segments %s";
    private final static java.lang.String failedToRequestSegments = "ISPN000210: Failed to request state of cache %s from node %s, segments %s";
    private final static java.lang.String unableToRemoveEntryAfterActivation = "ISPN000214: Unable to remove entry under %s from cache store after activation";
    private final static java.lang.String unknownMigrator = "ISPN000215: Unknown migrator %s";
    private final static java.lang.String entriesMigrated = "ISPN000216: %d entries migrated to cache %s in %s";
    private final static java.lang.String remoteException = "ISPN000217: Received exception from %s, see cause for remote stack trace";
    private final static java.lang.String timeoutWaitingUntilTransactionPrepared = "ISPN000218: Timeout while waiting for the transaction validation. The command will not be processed. Transaction is %s";
    private final static java.lang.String shutdownHandlingCommand = "ISPN000219: Shutdown while handling command %s";
    private final static java.lang.String errorUnMarshallingCommand = "ISPN000220: Problems un-marshalling remote command from byte buffer";
    private final static java.lang.String customInterceptorMissingClass = "ISPN000222: Custom interceptor missing class";
    private final static java.lang.String suggestCustomInterceptorInheritance = "ISPN000223: Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended";
    private final static java.lang.String multipleCustomInterceptorPositions = "ISPN000224: Custom interceptor '%s' specifies more than one position";
    private final static java.lang.String missingCustomInterceptorPosition = "ISPN000225: Custom interceptor '%s' doesn't specify a position";
    private final static java.lang.String warnConcurrentUpdateSupportCannotBeConfigured = "ISPN000227: Support for concurrent updates can no longer be configured (it is always enabled by default)";
    private final static java.lang.String failedToRecoverCacheState = "ISPN000228: Failed to recover cache %s state after the current node became the coordinator";
    private final static java.lang.String unexpectedInitialVersion = "ISPN000229: Unexpected initial version type (only NumericVersion instances supported): %s";
    private final static java.lang.String rebalanceStartError = "ISPN000230: Failed to start rebalance for cache %s";
    private final static java.lang.String parserRootElementAlreadyRegistered = "ISPN000234: Root element for %s already registered in ParserRegistry by %s. Cannot install %s.";
    private final static java.lang.String parserDoesNotDeclareNamespaces = "ISPN000235: Configuration parser %s does not declare any Namespace annotations";
    private final static java.lang.String directoryCannotBeCreated = "ISPN000238: Directory %s does not exist and cannot be created!";
    private final static java.lang.String missingForeignExternalizer = "ISPN000242: Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly";
    private final static java.lang.String unknownExternalizerReaderIndex = "ISPN000243: Type of data read is unknown. Id=%d is not amongst known reader indexes.";
    private final static java.lang.String advanceExternalizerTypeClassesUndefined = "ISPN000244: AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set";
    private final static java.lang.String duplicateExternalizerIdFound4 = "ISPN000245: Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d";
    private final static java.lang.String internalExternalizerIdLimitExceeded = "ISPN000246: Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d";
    private final static java.lang.String foreignExternalizerUsingNegativeId = "ISPN000247: Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.";
    private final static java.lang.String loaderConfigurationDoesNotSpecifyLoaderClass = "ISPN000249: The cache loader configuration %s does not specify the loader class using @ConfigurationFor";
    private final static java.lang.String errorExecutingParallelStoreTask = "ISPN000252: Error executing parallel store task";
    private final static java.lang.String strictPeerToPeerDeprecated = "ISPN000254: The transport element's 'strictPeerToPeer' attribute is no longer in use.";
    private final static java.lang.String errorProcessingPrepare = "ISPN000255: Error while processing prepare";
    private final static java.lang.String configuratorSAXParseError = "ISPN000256: Configurator SAXParse error";
    private final static java.lang.String configuratorSAXError = "ISPN000257: Configurator SAX error";
    private final static java.lang.String configuratorError = "ISPN000258: Configurator general error";
    private final static java.lang.String errorAsyncStoreNotStopped = "ISPN000259: Async store executor did not stop properly";
    private final static java.lang.String failedOutBoundTransferExecution = "ISPN000261: Failed to execute outbound transfer";
    private final static java.lang.String failedToEnlistTransactionXaAdapter = "ISPN000262: Failed to enlist TransactionXaAdapter to transaction";
    private final static java.lang.String warnFifoStrategyIsDeprecated = "ISPN000263: FIFO strategy is deprecated, LRU will be used instead";
    private final static java.lang.String warnL1NotHavingReaperThread = "ISPN000264: Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!";
    private final static java.lang.String unableToCreateInterceptor = "ISPN000267: Problems creating interceptor %s";
    private final static java.lang.String unableToRollbackEvictionsDuringPrepare = "ISPN000268: Unable to broadcast evicts as a part of the prepare phase. Rolling back.";
    private final static java.lang.String warnGridFSMetadataCacheRequiresSync = "ISPN000269: Cache used for Grid metadata should be synchronous.";
    private final static java.lang.String warnCouldNotCommitLocalTx = "ISPN000270: Could not commit local tx %s";
    private final static java.lang.String warnCouldNotRollbackLocalTx = "ISPN000271: Could not rollback local tx %s";
    private final static java.lang.String warnExceptionRemovingRecovery = "ISPN000272: Exception removing recovery information";
    private final static java.lang.String invalidConfigurationIndexingWithInvalidation = "ISPN000273: Indexing can not be enabled on caches in Invalidation mode";
    private final static java.lang.String persistenceWithoutCacheLoaderInterceptor = "ISPN000274: Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!";
    private final static java.lang.String persistenceWithoutCacheWriteInterceptor = "ISPN000275: Persistence enabled without any CacheWriteInterceptor in InterceptorChain!";
    private final static java.lang.String missingMigrationData = "ISPN000276: Could not find migration data in cache %s";
    private final static java.lang.String keyMigrationFailed = "ISPN000277: Could not migrate key %s";
    private final static java.lang.String invalidConfigurationIndexingWithoutModule = "ISPN000278: Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.";
    private final static java.lang.String errorReadingFileStore = "ISPN000279: Failed to read stored entries from file. Error in file %s at offset %d";
    private final static java.lang.String exceptionInvokingListener = "ISPN000280: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    private final static java.lang.String thirdPartySuspected = "ISPN000281: %s reported that a third node was suspected, see cause for info on the node that was suspected";
    private final static java.lang.String invocationBatchingNeedsTransactionalCache = "ISPN000282: Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL";
    private final static java.lang.String invocationBatchingCannotBeRecoverable = "ISPN000283: A cache configured with invocation batching can't have recovery enabled";
    private final static java.lang.String clusterListenerInstallationFailure = "ISPN000284: Problem encountered while installing cluster listener";
    private final static java.lang.String unsuccessfulResponseForClusterListeners = "ISPN000285: Issue when retrieving cluster listeners from %s response was %s";
    private final static java.lang.String exceptionDuringClusterListenerRetrieval = "ISPN000286: Issue when retrieving cluster listeners from %s";
    private final static java.lang.String unauthorizedAccess = "ISPN000287: Unauthorized access: subject '%s' lacks '%s' permission";
    private final static java.lang.String invalidPrincipalRoleMapper = "ISPN000288: A principal-to-role mapper has not been specified";
    private final static java.lang.String unableToSendXSiteState = "ISPN000289: Unable to send X-Site state chunk to '%s'.";
    private final static java.lang.String unableToApplyXSiteState = "ISPN000291: Unable to apply X-Site state chunk.";
    private final static java.lang.String unrecognizedAttribute = "ISPN000292: Unrecognized attribute '%s'. Please check your configuration. Ignoring!";
    private final static java.lang.String ignoreXmlAttribute = "ISPN000293: Ignoring XML attribute %s, please remove from configuration file";
    private final static java.lang.String ignoreXmlElement = "ISPN000294: Ignoring XML element %s, please remove from configuration file";
    private final static java.lang.String undefinedThreadPoolName = "ISPN000295: No thread pool with name %s found";
    private final static java.lang.String invalidPermission = "ISPN000296: Attempt to add a %s permission to a SecurityPermissionCollection";
    private final static java.lang.String readOnlyPermissionCollection = "ISPN000297: Attempt to add a permission to a read-only SecurityPermissionCollection";
    private final static java.lang.String authorizationEnabledWithoutSecurityManager = "ISPN000298: Using internal security checker";
    private final static java.lang.String unableToAcquireLock = "ISPN000299: Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s";
    private final static java.lang.String unsuccessfulResponseRetrievingTransactionsForSegments = "ISPN000302: Issue when retrieving transactions from %s, response was %s";
    private final static java.lang.String ambiguousConfigurationFiles = "ISPN000304: More than one configuration file with specified name on classpath. The first one will be used:\n %s";
    private final static java.lang.String partitionDegraded = "ISPN000305: Cluster is operating in degraded mode because of node failures.";
    private final static java.lang.String degradedModeKeyUnavailable = "ISPN000306: Key '%s' is not available. Not all owners are in this partition";
    private final static java.lang.String clearDisallowedWhilePartitioned = "ISPN000307: Cannot clear when the cluster is partitioned";
    private final static java.lang.String rebalancingEnabled = "ISPN000308: Rebalancing enabled";
    private final static java.lang.String rebalancingSuspended = "ISPN000309: Rebalancing suspended";
    private final static java.lang.String startRebalance = "ISPN000310: Starting cluster-wide rebalance for cache %s, topology %s";
    private final static java.lang.String outdatedTopology = "ISPN000311: Received a command from an outdated topology, returning the exception to caller";
    private final static java.lang.String stopOrderIgnored = "ISPN000321: Cyclic dependency detected between caches, stop order ignored";
    private final static java.lang.String failedToRestartXSiteStateTransfer = "ISPN000322: Unable to re-start x-site state transfer to site %s";
    private final static java.lang.String cacheIsTerminated = "ISPN000323: %s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.";
    private final static java.lang.String cacheIsStopping = "ISPN000324: %s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.";
    private final static java.lang.String creatingTmpCacheTimedOut = "ISPN000325: Creating tmp cache %s timed out waiting for rebalancing to complete on node %s ";
    private final static java.lang.String remoteTransactionTimeout = "ISPN000326: Remote transaction %s timed out. Rolling back after %d ms";
    private final static java.lang.String unsupportedConfiguration = "ISPN000327: Cannot find a parser for element '%s' in namespace '%s'. Check that your configuration is up-to date for this version of Infinispan.";
    private final static java.lang.String rebalanceCompleted = "ISPN000328: Finished local rebalance for cache %s on node %s, topology id = %d";
    private final static java.lang.String errorReadingRebalancingStatus = "ISPN000329: Unable to read rebalancing status from coordinator %s";
    private final static java.lang.String distributedTaskFailover = "ISPN000330: Distributed task failed at %s. The task is failing over to be executed at %s";
    private final static java.lang.String unableToInvokeListenerMethod = "ISPN000331: Unable to invoke method %s on Object instance %s ";
    private final static java.lang.String orphanTransactionRolledBack = "ISPN000332: Remote transaction %s rolled back because originator is no longer in the cluster";
    private final static java.lang.String twoPhaseCommitAsyncBackup = "ISPN000335: Two-phase commit can only be used with synchronous backup strategy.";
    private final static java.lang.String clusterWideRebalanceCompleted = "ISPN000336: Finished cluster-wide rebalance for cache %s, topology id = %d";
    private final static java.lang.String backupMissingSite = "ISPN000337: The 'site' must be specified!";
    private final static java.lang.String missingBackupFailurePolicyClass = "ISPN000338: It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!";
    private final static java.lang.String backupForNullCache = "ISPN000339: Null name not allowed (use 'defaultRemoteCache()' in case you want to specify the default cache name).";
    private final static java.lang.String backupForMissingParameters = "ISPN000340: Both 'remoteCache' and 'remoteSite' must be specified for a backup'!";
    private final static java.lang.String syncPropertiesConfigOnAsyncCache = "ISPN000342: Cannot configure sync properties for an async cache. Set the cache mode to sync first.";
    private final static java.lang.String missingTransportConfiguration = "ISPN000343: Must have a transport set in the global configuration in order to define a clustered cache";
    private final static java.lang.String invalidReaperWakeUpInterval = "ISPN000344: reaperWakeUpInterval must be >= 0, we got %d";
    private final static java.lang.String invalidCompletedTxTimeout = "ISPN000345: completedTxTimeout must be >= 0, we got %d";
    private final static java.lang.String invalidTxModeForTotalOrder = "ISPN000346: Total Order based protocol not available for transaction mode %s";
    private final static java.lang.String invalidCacheModeForTotalOrder = "ISPN000347: Cache mode %s is not supported by Total Order based protocol";
    private final static java.lang.String unavailableTotalOrderWithTxRecovery = "ISPN000348: Total Order based protocol not available with recovery";
    private final static java.lang.String invalidLockingModeForTotalOrder = "ISPN000349: Total Order based protocol not available with %s";
    private final static java.lang.String l1OnlyForDistributedCache = "ISPN000350: Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s";
    private final static java.lang.String l1InvalidLifespan = "ISPN000351: Using a L1 lifespan of 0 or a negative value is meaningless";
    private final static java.lang.String interceptorClassAndInstanceDefined = "ISPN000354: Cannot define both interceptor class (%s) and interceptor instance (%s)";
    private final static java.lang.String unableToInstantiateClass = "ISPN000355: Unable to instantiate loader/writer instance for StoreConfiguration %s";
    private final static java.lang.String evictionSizeTooLarge = "ISPN000356: Maximum data container size is currently 2^48 - 1, the number provided was %s";
    private final static java.lang.String xaResourceEndFailed = "ISPN000357: end() failed for %s";
    private final static java.lang.String existingConfigForInternalCache = "ISPN000358: A cache configuration named %s already exists. This cannot be configured externally by the user.";
    private final static java.lang.String degradedModeKeysUnavailable = "ISPN000359: Keys '%s' are not available. Not all owners are in this partition";
    private final static java.lang.String evictionExecutorDeprecated = "ISPN000360: The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.";
    private final static java.lang.String remoteTransactionAlreadyRolledBack = "ISPN000361: Cannot commit remote transaction %s as it was already rolled back";
    private final static java.lang.String remoteTransactionStatusMissing = "ISPN000362: Could not find status for remote transaction %s, please increase transaction.completedTxTimeout";
    private final static java.lang.String noFilterIndexingServiceProviderFound = "ISPN000363: No filter indexing service provider found for filter of type %s";
    private final static java.lang.String clusterListenerRegisteredWithOnlyPreEvents = "ISPN000364: Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!";
    private final static java.lang.String jgroupsConfigurationNotFound = "ISPN000365: Could not find the specified JGroups configuration file '%s'";
    private final static java.lang.String unableToAddNullCustomStore = "ISPN000366: Unable to add a 'null' Custom Cache Store";
    private final static java.lang.String memoryApproximationUnsupportedVM = "ISPN000368: Memory approximation calculation for eviction is unsupported for the '%s' Java VM";
    private final static java.lang.String illegalCacheName = "ISPN000370: Cache name '%s' cannot be used as it is a reserved, internal name";
    private final static java.lang.String configurationInUse = "ISPN000371: Cannot remove cache configuration '%s' because it is in use";
    private final static java.lang.String statisticsEnabledNotAvailable = "ISPN000372: Statistics are enabled while attribute 'available' is set to false.";
    private final static java.lang.String templateConfigurationStartAttempt = "ISPN000373: Attempted to start a cache using configuration template '%s'";
    private final static java.lang.String undeclaredConfiguration = "ISPN000374: No such template '%s' when declaring '%s'";
    private final static java.lang.String noConfiguration = "ISPN000375: Cannot use configuration '%s' as a template";
    private final static java.lang.String interceptorStackNotSupported = "ISPN000376: Interceptor stack is not supported in simple cache";
    private final static java.lang.String lockOperationsNotSupported = "ISPN000377: Explicit lock operations are not supported in simple cache";
    private final static java.lang.String invocationBatchingNotEnabled = "ISPN000378: Invocation batching not enabled in current configuration! Please enable it.";
    private final static java.lang.String distributedExecutorsNotSupported = "ISPN000380: Distributed Executors Framework is not supported in simple cache";
    private final static java.lang.String notSupportedInSimpleCache = "ISPN000381: This configuration is not supported for simple cache";
    private final static java.lang.String missingGlobalStatePersistentLocation = "ISPN000382: Global state persistence was enabled without specifying a location";
    private final static java.lang.String evictionMaxEntriesDeprecated = "ISPN000383: The eviction max-entries attribute has been deprecated. Please use the size attribute instead";
    private final static java.lang.String unableToBroadcastInvalidation = "ISPN000384: Unable to broadcast invalidation messages";
    private final static java.lang.String dataContainerConfigurationDeprecated = "ISPN000385: The data container class configuration has been deprecated.  This has no current replacement";
    private final static java.lang.String failedReadingPersistentState = "ISPN000386: Failed to read persisted state from file %s. Aborting.";
    private final static java.lang.String failedWritingGlobalState = "ISPN000387: Failed to write state to file %s.";
    private final static java.lang.String nonWritableStateFile = "ISPN000388: The state file %s is not writable. Aborting.";
    private final static java.lang.String globalStateLoad = "ISPN000389: Loaded global state, version=%s timestamp=%s";
    private final static java.lang.String globalStateWrite = "ISPN000390: Persisted state, version=%s timestamp=%s";
    private final static java.lang.String recoveryNotSupportedWithNonTxCache = "ISPN000391: Recovery not supported with non transactional cache";
    private final static java.lang.String recoveryNotSupportedWithSynchronization = "ISPN000392: Recovery not supported with Synchronization";
    private final static java.lang.String transactionNotificationsDisabled = "ISPN000395: Transaction notifications are disabled.  This prevents cluster listeners from working properly!";
    private final static java.lang.String ignoringUnsolicitedState = "ISPN000396: Received unsolicited state from node %s for segment %d of cache %s";
    private final static java.lang.String couldNotMigrateData = "ISPN000397: Could not migrate data for cache %s, check remote store config in the target cluster. Make sure only one remote store is present and is pointing to the source cluster";
    private final static java.lang.String persistentConsistentHashMismatch = "ISPN000398: CH Factory '%s' cannot restore a persisted CH of class '%s'";
    private final static java.lang.String timeoutWaitingForInitialNodes = "ISPN000399: Timeout while waiting for %d members in cluster. Last view had %s";
    private final static java.lang.String remoteNodeSuspected = "ISPN000400: Node %s was suspected";
    private final static java.lang.String remoteNodeTimedOut = "ISPN000401: Node %s timed out, time : %s %s";
    private final static java.lang.String coordinatorTimeoutWaitingForView = "ISPN000402: Timeout waiting for view %d. Current view is %d, current status is %s";
    private final static java.lang.String noIndexableClassesDefined = "ISPN000403: No indexable classes were defined for this indexed cache; using autodetection.";
    private final static java.lang.String classNotIndexable = "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    private final static java.lang.String failedInvokingCacheManagerListener = "ISPN000405: Caught exception while invoking a cache manager listener!";
    private final static java.lang.String ignoredReplicationQueueAttribute = "ISPN000406: The replication queue is no longer supported since version 9.0. Attribute %s on line %d will be ignored.";
    private final static java.lang.String extraneousMembersJoinRestoredCache = "ISPN000407: Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state";
    private final static java.lang.String nodeWithPersistentStateJoiningClusterWithoutState = "ISPN000408: Node %s with persistent state attempting to join cache %s on cluster without state";
    private final static java.lang.String nodeWithoutPersistentStateJoiningCacheWithState = "ISPN000409: Node %s without persistent state attempting to join cache %s on cluster with state";
    private final static java.lang.String nodeWithIncompatibleStateJoiningCache = "ISPN000410: Node %s attempting to join cache %s with incompatible state";
    private final static java.lang.String warnAboutUberJarDuplicates = "ISPN000411: Classpath does not look correct. Make sure you are not mixing uber and jars";
    private final static java.lang.String unknownTransactionConfiguration = "ISPN000412: Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s";
    private final static java.lang.String unableToInstantiateSerializer = "ISPN000413: Unable to instantiate serializer for %s";
    private final static java.lang.String globalSecurityAuthShouldBeEnabled = "ISPN000414: Global security authorization should be enabled if cache authorization enabled.";
    private final static java.lang.String ignoredAttribute = "ISPN000415: The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.";
    private final static java.lang.String transactionalStoreInNonTransactionalCache = "ISPN000417: It is not possible for a store to be transactional in a non-transactional cache. ";
    private final static java.lang.String transactionalStoreInPassivatedCache = "ISPN000418: It is not possible for a store to be transactional when passivation is enabled. ";
    private final static java.lang.String evictionDisabled = "ISPN000419: Eviction of an entry invoked without an explicit eviction strategy for cache %s";
    private final static java.lang.String attributeNotAllowedInInvalidationMode = "ISPN000420: Cannot enable '%s' in invalidation caches!";
    private final static java.lang.String viewHandlingError = "ISPN000421: Error while handling view %s";
    private final static java.lang.String failedWaitingForTopology = "ISPN000422: Failed waiting for topology %d";
    private final static java.lang.String duplicateExternalizerIdFound2 = "ISPN000423: Duplicate id found! AdvancedExternalizer id=%d is shared by another externalizer (%s)";
    private final static java.lang.String invalidEvictionSize = "ISPN000424: Eviction size value cannot be less than or equal to zero if eviction is enabled";
    private final static java.lang.String memoryEvictionInvalidStrategyLIRS = "ISPN000425: Eviction cannot use memory-based approximation with LIRS";
    private final static java.lang.String timeoutWaitingForAcks = "ISPN000427: Timeout after %s waiting for acks. Id=%s";
    private final static java.lang.String evictionDeprecated = "ISPN000428: The eviction element has been deprecated. Please use the memory element instead";
    private final static java.lang.String writeSkewOnRead = "ISPN000429: On key %s previous read version (%s) is different from currently read version (%s)";
    private final static java.lang.String nonSharedStoreConfiguredAsShared = "ISPN000430: %s cannot be shared";
    private final static java.lang.String warnStoreAnnotationMissing = "ISPN000431: Unable to validate %s's configuration as the @Store annotation is missing";
    private final static java.lang.String missingDefaultCacheDeclaration = "ISPN000432: Missing configuration for default cache '%s' declared on container";
    private final static java.lang.String noDefaultCache = "ISPN000433: A default cache has been requested, but no cache has been set as default for this container";
    private final static java.lang.String deprecatedDefaultCache = "ISPN000434: Direct usage of the ___defaultcache name to retrieve the default cache is deprecated";
    private final static java.lang.String defaultCacheConfigurationWithoutName = "ISPN000435: Cache manager initialized with a default cache configuration but without a name for it. Set it in the GlobalConfiguration.";
    private final static java.lang.String noSuchCacheConfiguration = "ISPN000436: Cache '%s' has been requested, but no cache configuration exists with that name and no default cache has been set for this container";
    private final static java.lang.String warnConfigurationForAnnotationMissing = "ISPN000437: Unable to validate %s with the implementing store as the @ConfigurationFor annotation is missing";
    private final static java.lang.String duplicateCacheName = "ISPN000438: Cache with name %s is defined more than once!";
    private final static java.lang.String receivedXSiteClusterView = "ISPN000439: Received new x-site view: %s";
    private final static java.lang.String errorSendingResponse = "ISPN000440: Error sending response for command %s";
    private final static java.lang.String unsupportedAsyncCacheMode = "ISPN000441: Unsupported async cache mode '%s' for transactional caches";
    private final static java.lang.String singletonStoreCannotBeShared = "ISPN000442: Invalid cache loader configuration for '%s'.  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!";
    private final static java.lang.String clusteredTransactionalStoreMustBeShared = "ISPN000443: Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.";
    private final static java.lang.String transactionalStoreCannotBeAsync = "ISPN000444: Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.";
    private final static java.lang.String onlyOneFetchPersistentStoreAllowed = "ISPN000445: At most one store can be set to 'fetchPersistentState'!";
    private final static java.lang.String multipleSitesWithSameName = "ISPN000446: Multiple sites with name '%s' are configured. That is not allowed!";
    private final static java.lang.String siteMustBeInBackups = "ISPN000447: The site '%s' must be defined within the set of backups!";
    private final static java.lang.String awaitInitialTransferOnlyForDistOrRepl = "ISPN000448: 'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.";
    private final static java.lang.String invalidXSiteStateTransferTimeout = "ISPN000449: XSite state transfer timeout must be higher or equals than 1 (one).";
    private final static java.lang.String invalidXSiteStateTransferWaitTime = "ISPN000450: XSite state transfer waiting time between retries must be higher or equals than 1 (one).";
    private final static java.lang.String timeoutWaitingForView = "ISPN000451: Timed out waiting for view %d, current view is %d";
    private final static java.lang.String topologyUpdateError = "ISPN000452: Failed to update topology for cache %s";
    private final static java.lang.String configAlreadyDefined = "ISPN000453: Attempt to define configuration for cache %s which already exists";
    private final static java.lang.String warnAttemptToOverrideExistingConfiguration = "ISPN000454: Calling getCache with a cache override is no longer supported. Please invoke defineConfiguration first and then getCache. Cache name was %s";

    public Log_$logger(final Logger log) {
        super(log);
    }

    public final void errorReadingProperties(final java.io.IOException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), errorReadingProperties$str());
    }

    protected java.lang.String errorReadingProperties$str() {
        return errorReadingProperties;
    }

    public final void unableToCopyEntryForUpdate(final java.lang.Object key) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unableToCopyEntryForUpdate$str(), key);
    }

    protected java.lang.String unableToCopyEntryForUpdate$str() {
        return unableToCopyEntryForUpdate;
    }

    public final void remoteExecutionFailed(final org.infinispan.remoting.transport.Address address, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), remoteExecutionFailed$str(), address);
    }

    protected java.lang.String remoteExecutionFailed$str() {
        return remoteExecutionFailed;
    }

    public final void localExecutionFailed(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), localExecutionFailed$str());
    }

    protected java.lang.String localExecutionFailed$str() {
        return localExecutionFailed;
    }

    public final void cannotSelectRandomMembers(final int numNeeded, final java.util.List members) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, cannotSelectRandomMembers$str(), numNeeded, members);
    }

    protected java.lang.String cannotSelectRandomMembers$str() {
        return cannotSelectRandomMembers;
    }

    public final void problemApplyingStateForKey(final java.lang.String msg, final java.lang.Object key, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), problemApplyingStateForKey$str(), msg, key);
    }

    protected java.lang.String problemApplyingStateForKey$str() {
        return problemApplyingStateForKey;
    }

    public final void expectedJustOneResponse(final Map lr) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, expectedJustOneResponse$str(), lr);
    }

    protected java.lang.String expectedJustOneResponse$str() {
        return expectedJustOneResponse;
    }

    public final void notStartingEvictionThread() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, notStartingEvictionThread$str());
    }

    protected java.lang.String notStartingEvictionThread$str() {
        return notStartingEvictionThread;
    }

    public final void exceptionPurgingDataContainer(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), exceptionPurgingDataContainer$str());
    }

    protected java.lang.String exceptionPurgingDataContainer$str() {
        return exceptionPurgingDataContainer;
    }

    public final void unableToPassivateEntry(final java.lang.Object key, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToPassivateEntry$str(), key);
    }

    protected java.lang.String unableToPassivateEntry$str() {
        return unableToPassivateEntry;
    }

    public final void passivatingAllEntries() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, passivatingAllEntries$str());
    }

    protected java.lang.String passivatingAllEntries$str() {
        return passivatingAllEntries;
    }

    public final void passivatedEntries(final long numEntries, final java.lang.String duration) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, passivatedEntries$str(), numEntries, duration);
    }

    protected java.lang.String passivatedEntries$str() {
        return passivatedEntries;
    }

    public final void mbeansSuccessfullyRegistered() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.TRACE), null, mbeansSuccessfullyRegistered$str());
    }

    protected java.lang.String mbeansSuccessfullyRegistered$str() {
        return mbeansSuccessfullyRegistered;
    }

    public final void problemsUnregisteringMBeans(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), problemsUnregisteringMBeans$str());
    }

    protected java.lang.String problemsUnregisteringMBeans$str() {
        return problemsUnregisteringMBeans;
    }

    public final void unableToUnregisterMBeanWithPattern(final java.lang.String pattern, final MBeanRegistrationException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToUnregisterMBeanWithPattern$str(), pattern);
    }

    protected java.lang.String unableToUnregisterMBeanWithPattern$str() {
        return unableToUnregisterMBeanWithPattern;
    }

    public final org.infinispan.jmx.JmxDomainConflictException jmxMBeanAlreadyRegistered(final java.lang.String mBeanName, final java.lang.String jmxDomain) {
        org.infinispan.jmx.JmxDomainConflictException result = new org.infinispan.jmx.JmxDomainConflictException(java.lang.String.format(jmxMBeanAlreadyRegistered$str(), mBeanName, jmxDomain));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String jmxMBeanAlreadyRegistered$str() {
        return jmxMBeanAlreadyRegistered;
    }

    public final void couldNotFindAttribute(final java.lang.String name) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, couldNotFindAttribute$str(), name);
    }

    protected java.lang.String couldNotFindAttribute$str() {
        return couldNotFindAttribute;
    }

    public final void failedToUpdateAttribute(final java.lang.String name, final java.lang.Object value) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, failedToUpdateAttribute$str(), name, value);
    }

    protected java.lang.String failedToUpdateAttribute$str() {
        return failedToUpdateAttribute;
    }

    public final void queriedAttributeNotFound(final java.lang.String attributeName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, queriedAttributeNotFound$str(), attributeName);
    }

    protected java.lang.String queriedAttributeNotFound$str() {
        return queriedAttributeNotFound;
    }

    public final void errorWritingValueForAttribute(final java.lang.String attributeName, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), errorWritingValueForAttribute$str(), attributeName);
    }

    protected java.lang.String errorWritingValueForAttribute$str() {
        return errorWritingValueForAttribute;
    }

    public final void couldNotInvokeSetOnAttribute(final java.lang.String attributeName, final java.lang.Object value) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, couldNotInvokeSetOnAttribute$str(), attributeName, value);
    }

    protected java.lang.String couldNotInvokeSetOnAttribute$str() {
        return couldNotInvokeSetOnAttribute;
    }

    public final void unknownResponsesFromRemoteCache(final java.util.Collection responses) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, unknownResponsesFromRemoteCache$str(), responses);
    }

    protected java.lang.String unknownResponsesFromRemoteCache$str() {
        return unknownResponsesFromRemoteCache;
    }

    public final void errorDoingRemoteCall(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorDoingRemoteCall$str());
    }

    protected java.lang.String errorDoingRemoteCall$str() {
        return errorDoingRemoteCall;
    }

    public final void interruptedWaitingAsyncStorePush(final java.lang.InterruptedException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), interruptedWaitingAsyncStorePush$str());
    }

    protected java.lang.String interruptedWaitingAsyncStorePush$str() {
        return interruptedWaitingAsyncStorePush;
    }

    public final void interruptedAcquiringLock(final long ms, final java.lang.InterruptedException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), interruptedAcquiringLock$str(), ms);
    }

    protected java.lang.String interruptedAcquiringLock$str() {
        return interruptedAcquiringLock;
    }

    public final void unableToProcessAsyncModifications(final int retries) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unableToProcessAsyncModifications$str(), retries);
    }

    protected java.lang.String unableToProcessAsyncModifications$str() {
        return unableToProcessAsyncModifications;
    }

    public final void unexpectedErrorInAsyncStoreCoordinator(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), unexpectedErrorInAsyncStoreCoordinator$str());
    }

    protected java.lang.String unexpectedErrorInAsyncStoreCoordinator$str() {
        return unexpectedErrorInAsyncStoreCoordinator;
    }

    public final void errorChangingSingletonStoreStatus(final PushStateException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorChangingSingletonStoreStatus$str());
    }

    protected java.lang.String errorChangingSingletonStoreStatus$str() {
        return errorChangingSingletonStoreStatus;
    }

    public final void errorMarshallingObject(final java.lang.Throwable ioe, final java.lang.Object obj) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (ioe), errorMarshallingObject$str(), obj);
    }

    protected java.lang.String errorMarshallingObject$str() {
        return errorMarshallingObject;
    }

    public final void unableToReadVersionId() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, unableToReadVersionId$str());
    }

    protected java.lang.String unableToReadVersionId$str() {
        return unableToReadVersionId;
    }

    public final void exceptionHandlingCommand(final org.infinispan.commands.ReplicableCommand cmd, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), exceptionHandlingCommand$str(), cmd);
    }

    protected java.lang.String exceptionHandlingCommand$str() {
        return exceptionHandlingCommand;
    }

    public final void unexpectedErrorReplicating(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), unexpectedErrorReplicating$str());
    }

    protected java.lang.String unexpectedErrorReplicating$str() {
        return unexpectedErrorReplicating;
    }

    public final void msgOrMsgBufferEmpty() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, msgOrMsgBufferEmpty$str());
    }

    protected java.lang.String msgOrMsgBufferEmpty$str() {
        return msgOrMsgBufferEmpty;
    }

    public final void startingJGroupsChannel(final java.lang.String cluster) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, startingJGroupsChannel$str(), cluster);
    }

    protected java.lang.String startingJGroupsChannel$str() {
        return startingJGroupsChannel;
    }

    public final void localAndPhysicalAddress(final java.lang.String cluster, final org.infinispan.remoting.transport.Address address, final java.util.List physicalAddresses) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, localAndPhysicalAddress$str(), cluster, address, physicalAddresses);
    }

    protected java.lang.String localAndPhysicalAddress$str() {
        return localAndPhysicalAddress;
    }

    public final void disconnectJGroups(final java.lang.String cluster) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, disconnectJGroups$str(), cluster);
    }

    protected java.lang.String disconnectJGroups$str() {
        return disconnectJGroups;
    }

    public final void problemClosingChannel(final java.lang.Exception e, final java.lang.String cluster) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), problemClosingChannel$str(), cluster);
    }

    protected java.lang.String problemClosingChannel$str() {
        return problemClosingChannel;
    }

    public final void stoppingRpcDispatcher(final java.lang.String cluster) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, stoppingRpcDispatcher$str(), cluster);
    }

    protected java.lang.String stoppingRpcDispatcher$str() {
        return stoppingRpcDispatcher;
    }

    public final void wrongTypeForJGroupsChannelLookup(final java.lang.String channelLookupClassName, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), wrongTypeForJGroupsChannelLookup$str(), channelLookupClassName);
    }

    protected java.lang.String wrongTypeForJGroupsChannelLookup$str() {
        return wrongTypeForJGroupsChannelLookup;
    }

    public final void errorInstantiatingJGroupsChannelLookup(final java.lang.String channelLookupClassName, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorInstantiatingJGroupsChannelLookup$str(), channelLookupClassName);
    }

    protected java.lang.String errorInstantiatingJGroupsChannelLookup$str() {
        return errorInstantiatingJGroupsChannelLookup;
    }

    public final org.infinispan.commons.CacheConfigurationException errorCreatingChannelFromConfigFile(final java.lang.String cfg, final java.lang.Exception e) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(errorCreatingChannelFromConfigFile$str(), cfg), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorCreatingChannelFromConfigFile$str() {
        return errorCreatingChannelFromConfigFile;
    }

    public final org.infinispan.commons.CacheConfigurationException errorCreatingChannelFromXML(final java.lang.String cfg, final java.lang.Exception e) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(errorCreatingChannelFromXML$str(), cfg), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorCreatingChannelFromXML$str() {
        return errorCreatingChannelFromXML;
    }

    public final org.infinispan.commons.CacheConfigurationException errorCreatingChannelFromConfigString(final java.lang.String cfg, final java.lang.Exception e) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(errorCreatingChannelFromConfigString$str(), cfg), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorCreatingChannelFromConfigString$str() {
        return errorCreatingChannelFromConfigString;
    }

    public final void unableToUseJGroupsPropertiesProvided(final TypedProperties props) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, unableToUseJGroupsPropertiesProvided$str(), props);
    }

    protected java.lang.String unableToUseJGroupsPropertiesProvided$str() {
        return unableToUseJGroupsPropertiesProvided;
    }

    public final void interruptedWaitingForCoordinator(final java.lang.InterruptedException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), interruptedWaitingForCoordinator$str());
    }

    protected java.lang.String interruptedWaitingForCoordinator$str() {
        return interruptedWaitingForCoordinator;
    }

    public final void receivedMergedView(final java.lang.String cluster, final org.jgroups.View newView) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, receivedMergedView$str(), cluster, newView);
    }

    protected java.lang.String receivedMergedView$str() {
        return receivedMergedView;
    }

    public final void receivedClusterView(final java.lang.String cluster, final org.jgroups.View newView) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, receivedClusterView$str(), cluster, newView);
    }

    protected java.lang.String receivedClusterView$str() {
        return receivedClusterView;
    }

    public final void errorProcessing1pcPrepareCommand(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorProcessing1pcPrepareCommand$str());
    }

    protected java.lang.String errorProcessing1pcPrepareCommand$str() {
        return errorProcessing1pcPrepareCommand;
    }

    public final void errorRollingBack(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorRollingBack$str());
    }

    protected java.lang.String errorRollingBack$str() {
        return errorRollingBack;
    }

    public final void unfinishedTransactionsRemain(final int localTransactions, final int remoteTransactions) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unfinishedTransactionsRemain$str(), localTransactions, remoteTransactions);
    }

    protected java.lang.String unfinishedTransactionsRemain$str() {
        return unfinishedTransactionsRemain;
    }

    public final void failedSynchronizationRegistration(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), failedSynchronizationRegistration$str());
    }

    protected java.lang.String failedSynchronizationRegistration$str() {
        return failedSynchronizationRegistration;
    }

    public final void unableToRollbackGlobalTx(final org.infinispan.transaction.xa.GlobalTransaction gtx, final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToRollbackGlobalTx$str(), gtx);
    }

    protected java.lang.String unableToRollbackGlobalTx$str() {
        return unableToRollbackGlobalTx;
    }

    public final void fallingBackToEmbeddedTm() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, fallingBackToEmbeddedTm$str());
    }

    protected java.lang.String fallingBackToEmbeddedTm$str() {
        return fallingBackToEmbeddedTm;
    }

    public final void failedToCreateInitialCtx(final NamingException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), failedToCreateInitialCtx$str());
    }

    protected java.lang.String failedToCreateInitialCtx$str() {
        return failedToCreateInitialCtx;
    }

    public final void unableToInvokeWebsphereStaticGetTmMethod(final java.lang.Exception ex, final java.lang.String className) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (ex), unableToInvokeWebsphereStaticGetTmMethod$str(), className);
    }

    protected java.lang.String unableToInvokeWebsphereStaticGetTmMethod$str() {
        return unableToInvokeWebsphereStaticGetTmMethod;
    }

    public final void retrievingTm(final TransactionManager tm) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, retrievingTm$str(), tm);
    }

    protected java.lang.String retrievingTm$str() {
        return retrievingTm;
    }

    public final void errorEnlistingResource(final javax.transaction.xa.XAException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorEnlistingResource$str());
    }

    protected java.lang.String errorEnlistingResource$str() {
        return errorEnlistingResource;
    }

    public final void beforeCompletionFailed(final javax.transaction.Synchronization s, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), beforeCompletionFailed$str(), s);
    }

    protected java.lang.String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }

    public final void unexpectedErrorFromResourceManager(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), unexpectedErrorFromResourceManager$str());
    }

    protected java.lang.String unexpectedErrorFromResourceManager$str() {
        return unexpectedErrorFromResourceManager;
    }

    public final void afterCompletionFailed(final javax.transaction.Synchronization s, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), afterCompletionFailed$str(), s);
    }

    protected java.lang.String afterCompletionFailed$str() {
        return afterCompletionFailed;
    }

    public final void errorCommittingTx(final javax.transaction.xa.XAException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), errorCommittingTx$str());
    }

    protected java.lang.String errorCommittingTx$str() {
        return errorCommittingTx;
    }

    public final void recoveryIgnored() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, recoveryIgnored$str());
    }

    protected java.lang.String recoveryIgnored$str() {
        return recoveryIgnored;
    }

    public final void missingListPreparedTransactions(final java.lang.Object key, final java.lang.Object value) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, missingListPreparedTransactions$str(), key, value);
    }

    protected java.lang.String missingListPreparedTransactions$str() {
        return missingListPreparedTransactions;
    }

    public final void preparedTxAlreadyExists(final RecoveryAwareTransaction previous, final RecoveryAwareRemoteTransaction remoteTransaction) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, preparedTxAlreadyExists$str(), previous, remoteTransaction);
    }

    protected java.lang.String preparedTxAlreadyExists$str() {
        return preparedTxAlreadyExists;
    }

    public final void unableToSetValue(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), unableToSetValue$str());
    }

    protected java.lang.String unableToSetValue$str() {
        return unableToSetValue;
    }

    public final void failedToCallStopAfterFailure(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), failedToCallStopAfterFailure$str());
    }

    protected java.lang.String failedToCallStopAfterFailure$str() {
        return failedToCallStopAfterFailure;
    }

    public final void version(final java.lang.String version) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, version$str(), version);
    }

    protected java.lang.String version$str() {
        return version;
    }

    public final void cacheNotStarted() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, cacheNotStarted$str());
    }

    protected java.lang.String cacheNotStarted$str() {
        return cacheNotStarted;
    }

    public final void noAnnotateMethodsFoundInListener(final java.lang.Class listenerClass) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, noAnnotateMethodsFoundInListener$str(), listenerClass);
    }

    protected java.lang.String noAnnotateMethodsFoundInListener$str() {
        return noAnnotateMethodsFoundInListener;
    }

    public final void unableToInvokeListenerMethodAndRemoveListener(final java.lang.reflect.Method m, final java.lang.Object target, final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToInvokeListenerMethodAndRemoveListener$str(), m, target);
    }

    protected java.lang.String unableToInvokeListenerMethodAndRemoveListener$str() {
        return unableToInvokeListenerMethodAndRemoveListener;
    }

    public final void unableToLockToInvalidate(final java.lang.Object key, final org.infinispan.remoting.transport.Address address) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unableToLockToInvalidate$str(), key, address);
    }

    protected java.lang.String unableToLockToInvalidate$str() {
        return unableToLockToInvalidate;
    }

    public final void executionError(final java.lang.String commandType, final java.lang.String affectedKeys, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), executionError$str(), commandType, affectedKeys);
    }

    protected java.lang.String executionError$str() {
        return executionError;
    }

    public final void failedInvalidatingRemoteCache(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), (e), failedInvalidatingRemoteCache$str());
    }

    protected java.lang.String failedInvalidatingRemoteCache$str() {
        return failedInvalidatingRemoteCache;
    }

    public final void couldNotRegisterObjectName(final ObjectName objectName, final InstanceAlreadyExistsException e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), (e), couldNotRegisterObjectName$str(), objectName);
    }

    protected java.lang.String couldNotRegisterObjectName$str() {
        return couldNotRegisterObjectName;
    }

    public final void couldNotRollbackPrepared1PcTransaction(final LocalTransaction localTransaction, final java.lang.Throwable e1) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e1), couldNotRollbackPrepared1PcTransaction$str(), localTransaction);
    }

    protected java.lang.String couldNotRollbackPrepared1PcTransaction$str() {
        return couldNotRollbackPrepared1PcTransaction;
    }

    public final void failedLoadingValueFromCacheStore(final java.lang.Object key, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), failedLoadingValueFromCacheStore$str(), key);
    }

    protected java.lang.String failedLoadingValueFromCacheStore$str() {
        return failedLoadingValueFromCacheStore;
    }

    public final void failedToInvalidateKeys(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), failedToInvalidateKeys$str());
    }

    protected java.lang.String failedToInvalidateKeys$str() {
        return failedToInvalidateKeys;
    }

    public final void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str());
    }

    protected java.lang.String staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str() {
        return staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup;
    }

    public final void passivationWithoutEviction() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, passivationWithoutEviction$str());
    }

    protected java.lang.String passivationWithoutEviction$str() {
        return passivationWithoutEviction;
    }

    public final void couldNotCompleteInjectedTransaction(final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (t), couldNotCompleteInjectedTransaction$str());
    }

    protected java.lang.String couldNotCompleteInjectedTransaction$str() {
        return couldNotCompleteInjectedTransaction;
    }

    public final void usingBatchModeTransactionManager() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, usingBatchModeTransactionManager$str());
    }

    protected java.lang.String usingBatchModeTransactionManager$str() {
        return usingBatchModeTransactionManager;
    }

    public final void couldNotInstantiateTransactionManager(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), (e), couldNotInstantiateTransactionManager$str());
    }

    protected java.lang.String couldNotInstantiateTransactionManager$str() {
        return couldNotInstantiateTransactionManager;
    }

    public final void customInterceptorExpectsInjection(final java.lang.String customInterceptorFQCN) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, customInterceptorExpectsInjection$str(), customInterceptorFQCN);
    }

    protected java.lang.String customInterceptorExpectsInjection$str() {
        return customInterceptorExpectsInjection;
    }

    public final void randomCacheModeSynonymsDeprecated(final java.lang.String candidate, final java.lang.String mode, final java.util.List synonyms) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, randomCacheModeSynonymsDeprecated$str(), candidate, mode, synonyms);
    }

    protected java.lang.String randomCacheModeSynonymsDeprecated$str() {
        return randomCacheModeSynonymsDeprecated;
    }

    public final void errorProcessing2pcCommitCommand(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorProcessing2pcCommitCommand$str());
    }

    protected java.lang.String errorProcessing2pcCommitCommand$str() {
        return errorProcessing2pcCommitCommand;
    }

    public final void componentFailedToStop(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), componentFailedToStop$str());
    }

    protected java.lang.String componentFailedToStop$str() {
        return componentFailedToStop;
    }

    public final void localIndexingWithSharedCacheLoaderRequiresPreload() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.DEBUG), null, localIndexingWithSharedCacheLoaderRequiresPreload$str());
    }

    protected java.lang.String localIndexingWithSharedCacheLoaderRequiresPreload$str() {
        return localIndexingWithSharedCacheLoaderRequiresPreload;
    }

    public final void hashNumVirtualNodesDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, hashNumVirtualNodesDeprecated$str());
    }

    protected java.lang.String hashNumVirtualNodesDeprecated$str() {
        return hashNumVirtualNodesDeprecated;
    }

    public final void consistentHashDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, consistentHashDeprecated$str());
    }

    protected java.lang.String consistentHashDeprecated$str() {
        return consistentHashDeprecated;
    }

    public final void failedLoadingKeysFromCacheStore(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), failedLoadingKeysFromCacheStore$str());
    }

    protected java.lang.String failedLoadingKeysFromCacheStore$str() {
        return failedLoadingKeysFromCacheStore;
    }

    public final void rebalanceError(final java.lang.String cacheName, final org.infinispan.remoting.transport.Address node, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), rebalanceError$str(), cacheName, node);
    }

    protected java.lang.String rebalanceError$str() {
        return rebalanceError;
    }

    public final void failedToRecoverClusterState(final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), failedToRecoverClusterState$str());
    }

    protected java.lang.String failedToRecoverClusterState$str() {
        return failedToRecoverClusterState;
    }

    public final void errorUpdatingMembersList(final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), errorUpdatingMembersList$str());
    }

    protected java.lang.String errorUpdatingMembersList$str() {
        return errorUpdatingMembersList;
    }

    public final void unableToRegisterMBeans() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, unableToRegisterMBeans0$str());
    }

    protected java.lang.String unableToRegisterMBeans0$str() {
        return unableToRegisterMBeans0;
    }

    public final void unableToRegisterMBeans(final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, unableToRegisterMBeans1$str(), cacheName);
    }

    protected java.lang.String unableToRegisterMBeans1$str() {
        return unableToRegisterMBeans1;
    }

    public final void unableToRegisterCacheManagerMBeans() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, unableToRegisterCacheManagerMBeans$str());
    }

    protected java.lang.String unableToRegisterCacheManagerMBeans$str() {
        return unableToRegisterCacheManagerMBeans;
    }

    public final void cacheBackupsDataToSameSite(final java.lang.String siteName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.TRACE), null, cacheBackupsDataToSameSite$str(), siteName);
    }

    protected java.lang.String cacheBackupsDataToSameSite$str() {
        return cacheBackupsDataToSameSite;
    }

    public final void warnXsiteBackupFailed(final java.lang.String cacheName, final java.lang.String key, final java.lang.Object value) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnXsiteBackupFailed$str(), cacheName, key, value);
    }

    protected java.lang.String warnXsiteBackupFailed$str() {
        return warnXsiteBackupFailed;
    }

    public final void cannotRespondToRollback(final org.infinispan.transaction.xa.GlobalTransaction globalTransaction, final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, cannotRespondToRollback$str(), globalTransaction, cacheName);
    }

    protected java.lang.String cannotRespondToRollback$str() {
        return cannotRespondToRollback;
    }

    public final void cannotRespondToCommit(final org.infinispan.transaction.xa.GlobalTransaction globalTransaction, final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, cannotRespondToCommit$str(), globalTransaction, cacheName);
    }

    protected java.lang.String cannotRespondToCommit$str() {
        return cannotRespondToCommit;
    }

    public final void tryingToBringOnlineNonexistentSite(final java.lang.String siteName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, tryingToBringOnlineNonexistentSite$str(), siteName);
    }

    protected java.lang.String tryingToBringOnlineNonexistentSite$str() {
        return tryingToBringOnlineNonexistentSite;
    }

    public final void couldNotExecuteCancellationLocally(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), couldNotExecuteCancellationLocally$str());
    }

    protected java.lang.String couldNotExecuteCancellationLocally$str() {
        return couldNotExecuteCancellationLocally;
    }

    public final void couldNotInterruptThread(final UUID id) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, couldNotInterruptThread$str(), id);
    }

    protected java.lang.String couldNotInterruptThread$str() {
        return couldNotInterruptThread;
    }

    public final void noLiveOwnersFoundForSegments(final java.util.Collection segments, final java.lang.String cacheName, final java.util.Collection faultySources) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, noLiveOwnersFoundForSegments$str(), segments, cacheName, faultySources);
    }

    protected java.lang.String noLiveOwnersFoundForSegments$str() {
        return noLiveOwnersFoundForSegments;
    }

    public final void failedToRetrieveTransactionsForSegments(final java.lang.String cacheName, final org.infinispan.remoting.transport.Address source, final java.util.Collection segments, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), failedToRetrieveTransactionsForSegments$str(), cacheName, source, segments);
    }

    protected java.lang.String failedToRetrieveTransactionsForSegments$str() {
        return failedToRetrieveTransactionsForSegments;
    }

    public final void failedToRequestSegments(final java.lang.String cacheName, final org.infinispan.remoting.transport.Address source, final java.util.Collection segments, final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), failedToRequestSegments$str(), cacheName, source, segments);
    }

    protected java.lang.String failedToRequestSegments$str() {
        return failedToRequestSegments;
    }

    public final void unableToRemoveEntryAfterActivation(final java.lang.Object key, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToRemoveEntryAfterActivation$str(), key);
    }

    protected java.lang.String unableToRemoveEntryAfterActivation$str() {
        return unableToRemoveEntryAfterActivation;
    }

    public final java.lang.Exception unknownMigrator(final java.lang.String migratorName) {
        java.lang.Exception result = new java.lang.Exception(java.lang.String.format(unknownMigrator$str(), migratorName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unknownMigrator$str() {
        return unknownMigrator;
    }

    public final void entriesMigrated(final long count, final java.lang.String name, final java.lang.String prettyTime) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, entriesMigrated$str(), count, name, prettyTime);
    }

    protected java.lang.String entriesMigrated$str() {
        return entriesMigrated;
    }

    public final org.infinispan.remoting.RemoteException remoteException(final org.infinispan.remoting.transport.Address sender, final java.lang.Throwable t) {
        org.infinispan.remoting.RemoteException result = new org.infinispan.remoting.RemoteException(java.lang.String.format(remoteException$str(), sender), t);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String remoteException$str() {
        return remoteException;
    }

    public final void timeoutWaitingUntilTransactionPrepared(final java.lang.String globalTx) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, timeoutWaitingUntilTransactionPrepared$str(), globalTx);
    }

    protected java.lang.String timeoutWaitingUntilTransactionPrepared$str() {
        return timeoutWaitingUntilTransactionPrepared;
    }

    public final void shutdownHandlingCommand(final org.infinispan.commands.ReplicableCommand command) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, shutdownHandlingCommand$str(), command);
    }

    protected java.lang.String shutdownHandlingCommand$str() {
        return shutdownHandlingCommand;
    }

    public final void errorUnMarshallingCommand(final java.lang.Throwable throwable) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (throwable), errorUnMarshallingCommand$str());
    }

    protected java.lang.String errorUnMarshallingCommand$str() {
        return errorUnMarshallingCommand;
    }

    public final org.infinispan.commons.CacheConfigurationException customInterceptorMissingClass() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(customInterceptorMissingClass$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String customInterceptorMissingClass$str() {
        return customInterceptorMissingClass;
    }

    public final void suggestCustomInterceptorInheritance(final java.lang.String customInterceptorClassName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, suggestCustomInterceptorInheritance$str(), customInterceptorClassName);
    }

    protected java.lang.String suggestCustomInterceptorInheritance$str() {
        return suggestCustomInterceptorInheritance;
    }

    public final org.infinispan.commons.CacheConfigurationException multipleCustomInterceptorPositions(final java.lang.String customInterceptorClassName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(multipleCustomInterceptorPositions$str(), customInterceptorClassName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String multipleCustomInterceptorPositions$str() {
        return multipleCustomInterceptorPositions;
    }

    public final org.infinispan.commons.CacheConfigurationException missingCustomInterceptorPosition(final java.lang.String customInterceptorClassName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(missingCustomInterceptorPosition$str(), customInterceptorClassName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingCustomInterceptorPosition$str() {
        return missingCustomInterceptorPosition;
    }

    public final void warnConcurrentUpdateSupportCannotBeConfigured() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnConcurrentUpdateSupportCannotBeConfigured$str());
    }

    protected java.lang.String warnConcurrentUpdateSupportCannotBeConfigured$str() {
        return warnConcurrentUpdateSupportCannotBeConfigured;
    }

    public final void failedToRecoverCacheState(final java.lang.String cacheName, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), failedToRecoverCacheState$str(), cacheName);
    }

    protected java.lang.String failedToRecoverCacheState$str() {
        return failedToRecoverCacheState;
    }

    public final java.lang.IllegalArgumentException unexpectedInitialVersion(final java.lang.String className) {
        java.lang.IllegalArgumentException result = new java.lang.IllegalArgumentException(java.lang.String.format(unexpectedInitialVersion$str(), className));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unexpectedInitialVersion$str() {
        return unexpectedInitialVersion;
    }

    public final void rebalanceStartError(final java.lang.String cacheName, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), rebalanceStartError$str(), cacheName);
    }

    protected java.lang.String rebalanceStartError$str() {
        return rebalanceStartError;
    }

    public final void parserRootElementAlreadyRegistered(final QName qName, final java.lang.String oldParser, final java.lang.String newParser) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, parserRootElementAlreadyRegistered$str(), qName, oldParser, newParser);
    }

    protected java.lang.String parserRootElementAlreadyRegistered$str() {
        return parserRootElementAlreadyRegistered;
    }

    public final org.infinispan.commons.CacheConfigurationException parserDoesNotDeclareNamespaces(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(parserDoesNotDeclareNamespaces$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String parserDoesNotDeclareNamespaces$str() {
        return parserDoesNotDeclareNamespaces;
    }

    public final org.infinispan.commons.CacheConfigurationException directoryCannotBeCreated(final java.lang.String path) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(directoryCannotBeCreated$str(), path));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String directoryCannotBeCreated$str() {
        return directoryCannotBeCreated;
    }

    public final org.infinispan.commons.CacheException missingForeignExternalizer(final int foreignId) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(missingForeignExternalizer$str(), foreignId));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingForeignExternalizer$str() {
        return missingForeignExternalizer;
    }

    public final org.infinispan.commons.CacheException unknownExternalizerReaderIndex(final int readerIndex) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(unknownExternalizerReaderIndex$str(), readerIndex));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unknownExternalizerReaderIndex$str() {
        return unknownExternalizerReaderIndex;
    }

    public final org.infinispan.commons.CacheConfigurationException advanceExternalizerTypeClassesUndefined(final java.lang.String className) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(advanceExternalizerTypeClassesUndefined$str(), className));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String advanceExternalizerTypeClassesUndefined$str() {
        return advanceExternalizerTypeClassesUndefined;
    }

    public final org.infinispan.commons.CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final java.lang.Class typeClass, final java.lang.String otherExternalizer, final int readerIndex) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(duplicateExternalizerIdFound4$str(), externalizerId, typeClass, otherExternalizer, readerIndex));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String duplicateExternalizerIdFound4$str() {
        return duplicateExternalizerIdFound4;
    }

    public final org.infinispan.commons.CacheConfigurationException internalExternalizerIdLimitExceeded(final org.infinispan.commons.marshall.AdvancedExternalizer ext, final int externalizerId, final int maxId) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(internalExternalizerIdLimitExceeded$str(), ext, externalizerId, maxId));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String internalExternalizerIdLimitExceeded$str() {
        return internalExternalizerIdLimitExceeded;
    }

    public final org.infinispan.commons.CacheConfigurationException foreignExternalizerUsingNegativeId(final org.infinispan.commons.marshall.AdvancedExternalizer ext, final int externalizerId) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(foreignExternalizerUsingNegativeId$str(), ext, externalizerId));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String foreignExternalizerUsingNegativeId$str() {
        return foreignExternalizerUsingNegativeId;
    }

    public final org.infinispan.commons.CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(final java.lang.String className) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(loaderConfigurationDoesNotSpecifyLoaderClass$str(), className));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String loaderConfigurationDoesNotSpecifyLoaderClass$str() {
        return loaderConfigurationDoesNotSpecifyLoaderClass;
    }

    public final void errorExecutingParallelStoreTask(final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), errorExecutingParallelStoreTask$str());
    }

    protected java.lang.String errorExecutingParallelStoreTask$str() {
        return errorExecutingParallelStoreTask;
    }

    public final void strictPeerToPeerDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, strictPeerToPeerDeprecated$str());
    }

    protected java.lang.String strictPeerToPeerDeprecated$str() {
        return strictPeerToPeerDeprecated;
    }

    public final void errorProcessingPrepare(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), errorProcessingPrepare$str());
    }

    protected java.lang.String errorProcessingPrepare$str() {
        return errorProcessingPrepare;
    }

    public final void configuratorSAXParseError(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), configuratorSAXParseError$str());
    }

    protected java.lang.String configuratorSAXParseError$str() {
        return configuratorSAXParseError;
    }

    public final void configuratorSAXError(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), configuratorSAXError$str());
    }

    protected java.lang.String configuratorSAXError$str() {
        return configuratorSAXError;
    }

    public final void configuratorError(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), configuratorError$str());
    }

    protected java.lang.String configuratorError$str() {
        return configuratorError;
    }

    public final void errorAsyncStoreNotStopped() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, errorAsyncStoreNotStopped$str());
    }

    protected java.lang.String errorAsyncStoreNotStopped$str() {
        return errorAsyncStoreNotStopped;
    }

    public final void failedOutBoundTransferExecution(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), failedOutBoundTransferExecution$str());
    }

    protected java.lang.String failedOutBoundTransferExecution$str() {
        return failedOutBoundTransferExecution;
    }

    public final void failedToEnlistTransactionXaAdapter(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), failedToEnlistTransactionXaAdapter$str());
    }

    protected java.lang.String failedToEnlistTransactionXaAdapter$str() {
        return failedToEnlistTransactionXaAdapter;
    }

    public final void warnFifoStrategyIsDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnFifoStrategyIsDeprecated$str());
    }

    protected java.lang.String warnFifoStrategyIsDeprecated$str() {
        return warnFifoStrategyIsDeprecated;
    }

    public final void warnL1NotHavingReaperThread() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnL1NotHavingReaperThread$str());
    }

    protected java.lang.String warnL1NotHavingReaperThread$str() {
        return warnL1NotHavingReaperThread;
    }

    public final void unableToCreateInterceptor(final java.lang.Class type, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToCreateInterceptor$str(), type);
    }

    protected java.lang.String unableToCreateInterceptor$str() {
        return unableToCreateInterceptor;
    }

    public final void unableToRollbackEvictionsDuringPrepare(final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToRollbackEvictionsDuringPrepare$str());
    }

    protected java.lang.String unableToRollbackEvictionsDuringPrepare$str() {
        return unableToRollbackEvictionsDuringPrepare;
    }

    public final void warnGridFSMetadataCacheRequiresSync() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnGridFSMetadataCacheRequiresSync$str());
    }

    protected java.lang.String warnGridFSMetadataCacheRequiresSync$str() {
        return warnGridFSMetadataCacheRequiresSync;
    }

    public final void warnCouldNotCommitLocalTx(final java.lang.Object transactionDescription, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), warnCouldNotCommitLocalTx$str(), transactionDescription);
    }

    protected java.lang.String warnCouldNotCommitLocalTx$str() {
        return warnCouldNotCommitLocalTx;
    }

    public final void warnCouldNotRollbackLocalTx(final java.lang.Object transactionDescription, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), warnCouldNotRollbackLocalTx$str(), transactionDescription);
    }

    protected java.lang.String warnCouldNotRollbackLocalTx$str() {
        return warnCouldNotRollbackLocalTx;
    }

    public final void warnExceptionRemovingRecovery(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), warnExceptionRemovingRecovery$str());
    }

    protected java.lang.String warnExceptionRemovingRecovery$str() {
        return warnExceptionRemovingRecovery;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidConfigurationIndexingWithInvalidation() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidConfigurationIndexingWithInvalidation$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidConfigurationIndexingWithInvalidation$str() {
        return invalidConfigurationIndexingWithInvalidation;
    }

    public final void persistenceWithoutCacheLoaderInterceptor() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, persistenceWithoutCacheLoaderInterceptor$str());
    }

    protected java.lang.String persistenceWithoutCacheLoaderInterceptor$str() {
        return persistenceWithoutCacheLoaderInterceptor;
    }

    public final void persistenceWithoutCacheWriteInterceptor() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, persistenceWithoutCacheWriteInterceptor$str());
    }

    protected java.lang.String persistenceWithoutCacheWriteInterceptor$str() {
        return persistenceWithoutCacheWriteInterceptor;
    }

    public final org.infinispan.commons.CacheException missingMigrationData(final java.lang.String name) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(missingMigrationData$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingMigrationData$str() {
        return missingMigrationData;
    }

    public final void keyMigrationFailed(final java.lang.String key, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), keyMigrationFailed$str(), key);
    }

    protected java.lang.String keyMigrationFailed$str() {
        return keyMigrationFailed;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidConfigurationIndexingWithoutModule() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidConfigurationIndexingWithoutModule$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidConfigurationIndexingWithoutModule$str() {
        return invalidConfigurationIndexingWithoutModule;
    }

    public final org.infinispan.persistence.spi.PersistenceException errorReadingFileStore(final java.lang.String path, final long offset) {
        org.infinispan.persistence.spi.PersistenceException result = new org.infinispan.persistence.spi.PersistenceException(java.lang.String.format(errorReadingFileStore$str(), path, offset));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String errorReadingFileStore$str() {
        return errorReadingFileStore;
    }

    public final org.infinispan.commons.CacheListenerException exceptionInvokingListener(final java.lang.String name, final java.lang.reflect.Method m, final java.lang.Object target, final java.lang.Throwable cause) {
        org.infinispan.commons.CacheListenerException result = new org.infinispan.commons.CacheListenerException(java.lang.String.format(exceptionInvokingListener$str(), name, m, target), cause);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String exceptionInvokingListener$str() {
        return exceptionInvokingListener;
    }

    public final org.infinispan.remoting.transport.jgroups.SuspectException thirdPartySuspected(final org.infinispan.remoting.transport.Address sender, final org.infinispan.remoting.transport.jgroups.SuspectException e) {
        org.infinispan.remoting.transport.jgroups.SuspectException result = new org.infinispan.remoting.transport.jgroups.SuspectException(java.lang.String.format(thirdPartySuspected$str(), sender), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String thirdPartySuspected$str() {
        return thirdPartySuspected;
    }

    public final org.infinispan.commons.CacheConfigurationException invocationBatchingNeedsTransactionalCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invocationBatchingNeedsTransactionalCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invocationBatchingNeedsTransactionalCache$str() {
        return invocationBatchingNeedsTransactionalCache;
    }

    public final org.infinispan.commons.CacheConfigurationException invocationBatchingCannotBeRecoverable() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invocationBatchingCannotBeRecoverable$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invocationBatchingCannotBeRecoverable$str() {
        return invocationBatchingCannotBeRecoverable;
    }

    public final void clusterListenerInstallationFailure(final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), clusterListenerInstallationFailure$str());
    }

    protected java.lang.String clusterListenerInstallationFailure$str() {
        return clusterListenerInstallationFailure;
    }

    public final void unsuccessfulResponseForClusterListeners(final org.infinispan.remoting.transport.Address address, final org.infinispan.remoting.responses.Response response) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unsuccessfulResponseForClusterListeners$str(), address, response);
    }

    protected java.lang.String unsuccessfulResponseForClusterListeners$str() {
        return unsuccessfulResponseForClusterListeners;
    }

    public final void exceptionDuringClusterListenerRetrieval(final org.infinispan.remoting.transport.Address address, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), exceptionDuringClusterListenerRetrieval$str(), address);
    }

    protected java.lang.String exceptionDuringClusterListenerRetrieval$str() {
        return exceptionDuringClusterListenerRetrieval;
    }

    public final java.lang.SecurityException unauthorizedAccess(final java.lang.String subject, final java.lang.String permission) {
        java.lang.SecurityException result = new java.lang.SecurityException(java.lang.String.format(unauthorizedAccess$str(), subject, permission));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unauthorizedAccess$str() {
        return unauthorizedAccess;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidPrincipalRoleMapper() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidPrincipalRoleMapper$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidPrincipalRoleMapper$str() {
        return invalidPrincipalRoleMapper;
    }

    public final void unableToSendXSiteState(final java.lang.String site, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), unableToSendXSiteState$str(), site);
    }

    protected java.lang.String unableToSendXSiteState$str() {
        return unableToSendXSiteState;
    }

    public final void unableToApplyXSiteState(final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), unableToApplyXSiteState$str());
    }

    protected java.lang.String unableToApplyXSiteState$str() {
        return unableToApplyXSiteState;
    }

    public final void unrecognizedAttribute(final java.lang.String property) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unrecognizedAttribute$str(), property);
    }

    protected java.lang.String unrecognizedAttribute$str() {
        return unrecognizedAttribute;
    }

    public final void ignoreXmlAttribute(final java.lang.Object attribute) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, ignoreXmlAttribute$str(), attribute);
    }

    protected java.lang.String ignoreXmlAttribute$str() {
        return ignoreXmlAttribute;
    }

    public final void ignoreXmlElement(final java.lang.Object element) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, ignoreXmlElement$str(), element);
    }

    protected java.lang.String ignoreXmlElement$str() {
        return ignoreXmlElement;
    }

    public final org.infinispan.commons.CacheConfigurationException undefinedThreadPoolName(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(undefinedThreadPoolName$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String undefinedThreadPoolName$str() {
        return undefinedThreadPoolName;
    }

    public final java.lang.IllegalArgumentException invalidPermission(final Permission permission) {
        java.lang.IllegalArgumentException result = new java.lang.IllegalArgumentException(java.lang.String.format(invalidPermission$str(), permission));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidPermission$str() {
        return invalidPermission;
    }

    public final java.lang.SecurityException readOnlyPermissionCollection() {
        java.lang.SecurityException result = new java.lang.SecurityException(java.lang.String.format(readOnlyPermissionCollection$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }

    public final void authorizationEnabledWithoutSecurityManager() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.DEBUG), null, authorizationEnabledWithoutSecurityManager$str());
    }

    protected java.lang.String authorizationEnabledWithoutSecurityManager$str() {
        return authorizationEnabledWithoutSecurityManager;
    }

    public final org.infinispan.util.concurrent.TimeoutException unableToAcquireLock(final java.lang.String timeout, final java.lang.Object key, final java.lang.Object requestor, final java.lang.Object owner) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(unableToAcquireLock$str(), timeout, key, requestor, owner));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToAcquireLock$str() {
        return unableToAcquireLock;
    }

    public final void unsuccessfulResponseRetrievingTransactionsForSegments(final org.infinispan.remoting.transport.Address address, final org.infinispan.remoting.responses.Response response) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, unsuccessfulResponseRetrievingTransactionsForSegments$str(), address, response);
    }

    protected java.lang.String unsuccessfulResponseRetrievingTransactionsForSegments$str() {
        return unsuccessfulResponseRetrievingTransactionsForSegments;
    }

    public final void ambiguousConfigurationFiles(final java.lang.String files) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, ambiguousConfigurationFiles$str(), files);
    }

    protected java.lang.String ambiguousConfigurationFiles$str() {
        return ambiguousConfigurationFiles;
    }

    public final org.infinispan.partitionhandling.AvailabilityException partitionDegraded() {
        org.infinispan.partitionhandling.AvailabilityException result = new org.infinispan.partitionhandling.AvailabilityException(java.lang.String.format(partitionDegraded$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String partitionDegraded$str() {
        return partitionDegraded;
    }

    public final org.infinispan.partitionhandling.AvailabilityException degradedModeKeyUnavailable(final java.lang.Object key) {
        org.infinispan.partitionhandling.AvailabilityException result = new org.infinispan.partitionhandling.AvailabilityException(java.lang.String.format(degradedModeKeyUnavailable$str(), key));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String degradedModeKeyUnavailable$str() {
        return degradedModeKeyUnavailable;
    }

    public final org.infinispan.partitionhandling.AvailabilityException clearDisallowedWhilePartitioned() {
        org.infinispan.partitionhandling.AvailabilityException result = new org.infinispan.partitionhandling.AvailabilityException(java.lang.String.format(clearDisallowedWhilePartitioned$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String clearDisallowedWhilePartitioned$str() {
        return clearDisallowedWhilePartitioned;
    }

    public final void rebalancingEnabled() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, rebalancingEnabled$str());
    }

    protected java.lang.String rebalancingEnabled$str() {
        return rebalancingEnabled;
    }

    public final void rebalancingSuspended() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, rebalancingSuspended$str());
    }

    protected java.lang.String rebalancingSuspended$str() {
        return rebalancingSuspended;
    }

    public final void startRebalance(final java.lang.String cacheName, final CacheTopology cacheTopology) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, startRebalance$str(), cacheName, cacheTopology);
    }

    protected java.lang.String startRebalance$str() {
        return startRebalance;
    }

    public final void outdatedTopology(final java.lang.Throwable oe) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.DEBUG), (oe), outdatedTopology$str());
    }

    protected java.lang.String outdatedTopology$str() {
        return outdatedTopology;
    }

    public final void stopOrderIgnored() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, stopOrderIgnored$str());
    }

    protected java.lang.String stopOrderIgnored$str() {
        return stopOrderIgnored;
    }

    public final void failedToRestartXSiteStateTransfer(final java.lang.String siteName, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (cause), failedToRestartXSiteStateTransfer$str(), siteName);
    }

    protected java.lang.String failedToRestartXSiteStateTransfer$str() {
        return failedToRestartXSiteStateTransfer;
    }

    public final org.infinispan.IllegalLifecycleStateException cacheIsTerminated(final java.lang.String cacheName, final java.lang.String state) {
        org.infinispan.IllegalLifecycleStateException result = new org.infinispan.IllegalLifecycleStateException(java.lang.String.format(cacheIsTerminated$str(), cacheName, state));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String cacheIsTerminated$str() {
        return cacheIsTerminated;
    }

    public final org.infinispan.IllegalLifecycleStateException cacheIsStopping(final java.lang.String cacheName) {
        org.infinispan.IllegalLifecycleStateException result = new org.infinispan.IllegalLifecycleStateException(java.lang.String.format(cacheIsStopping$str(), cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String cacheIsStopping$str() {
        return cacheIsStopping;
    }

    public final java.lang.RuntimeException creatingTmpCacheTimedOut(final java.lang.String cacheName, final org.infinispan.remoting.transport.Address address) {
        java.lang.RuntimeException result = new java.lang.RuntimeException(java.lang.String.format(creatingTmpCacheTimedOut$str(), cacheName, address));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String creatingTmpCacheTimedOut$str() {
        return creatingTmpCacheTimedOut;
    }

    public final void remoteTransactionTimeout(final org.infinispan.transaction.xa.GlobalTransaction gtx, final long ageMilliSeconds) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, remoteTransactionTimeout$str(), gtx, ageMilliSeconds);
    }

    protected java.lang.String remoteTransactionTimeout$str() {
        return remoteTransactionTimeout;
    }

    public final org.infinispan.commons.CacheConfigurationException unsupportedConfiguration(final java.lang.String element, final java.lang.String namespaceUri) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unsupportedConfiguration$str(), element, namespaceUri));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unsupportedConfiguration$str() {
        return unsupportedConfiguration;
    }

    public final void rebalanceCompleted(final java.lang.String cacheName, final org.infinispan.remoting.transport.Address node, final int topologyId) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.DEBUG), null, rebalanceCompleted$str(), cacheName, node, topologyId);
    }

    protected java.lang.String rebalanceCompleted$str() {
        return rebalanceCompleted;
    }

    public final void errorReadingRebalancingStatus(final org.infinispan.remoting.transport.Address coordinator, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), errorReadingRebalancingStatus$str(), coordinator);
    }

    protected java.lang.String errorReadingRebalancingStatus$str() {
        return errorReadingRebalancingStatus;
    }

    public final void distributedTaskFailover(final org.infinispan.remoting.transport.Address failedAtAddress, final org.infinispan.remoting.transport.Address failoverTarget, final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), distributedTaskFailover$str(), failedAtAddress, failoverTarget);
    }

    protected java.lang.String distributedTaskFailover$str() {
        return distributedTaskFailover;
    }

    public final void unableToInvokeListenerMethod(final java.lang.reflect.Method m, final java.lang.Object target, final java.lang.Throwable e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), (e), unableToInvokeListenerMethod$str(), m, target);
    }

    protected java.lang.String unableToInvokeListenerMethod$str() {
        return unableToInvokeListenerMethod;
    }

    public final org.infinispan.commons.CacheException orphanTransactionRolledBack(final org.infinispan.transaction.xa.GlobalTransaction gtx) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(orphanTransactionRolledBack$str(), gtx));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String orphanTransactionRolledBack$str() {
        return orphanTransactionRolledBack;
    }

    public final org.infinispan.commons.CacheConfigurationException twoPhaseCommitAsyncBackup() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(twoPhaseCommitAsyncBackup$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String twoPhaseCommitAsyncBackup$str() {
        return twoPhaseCommitAsyncBackup;
    }

    public final void clusterWideRebalanceCompleted(final java.lang.String cacheName, final int topologyId) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, clusterWideRebalanceCompleted$str(), cacheName, topologyId);
    }

    protected java.lang.String clusterWideRebalanceCompleted$str() {
        return clusterWideRebalanceCompleted;
    }

    public final org.infinispan.commons.CacheConfigurationException backupMissingSite() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(backupMissingSite$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String backupMissingSite$str() {
        return backupMissingSite;
    }

    public final org.infinispan.commons.CacheConfigurationException missingBackupFailurePolicyClass() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(missingBackupFailurePolicyClass$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingBackupFailurePolicyClass$str() {
        return missingBackupFailurePolicyClass;
    }

    public final org.infinispan.commons.CacheConfigurationException backupForNullCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(backupForNullCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String backupForNullCache$str() {
        return backupForNullCache;
    }

    public final org.infinispan.commons.CacheConfigurationException backupForMissingParameters() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(backupForMissingParameters$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String backupForMissingParameters$str() {
        return backupForMissingParameters;
    }

    public final java.lang.IllegalStateException syncPropertiesConfigOnAsyncCache() {
        java.lang.IllegalStateException result = new java.lang.IllegalStateException(java.lang.String.format(syncPropertiesConfigOnAsyncCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String syncPropertiesConfigOnAsyncCache$str() {
        return syncPropertiesConfigOnAsyncCache;
    }

    public final org.infinispan.commons.CacheConfigurationException missingTransportConfiguration() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(missingTransportConfiguration$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingTransportConfiguration$str() {
        return missingTransportConfiguration;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidReaperWakeUpInterval(final long timeout) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidReaperWakeUpInterval$str(), timeout));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidReaperWakeUpInterval$str() {
        return invalidReaperWakeUpInterval;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidCompletedTxTimeout(final long timeout) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidCompletedTxTimeout$str(), timeout));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidCompletedTxTimeout$str() {
        return invalidCompletedTxTimeout;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidTxModeForTotalOrder(final org.infinispan.transaction.TransactionMode transactionMode) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidTxModeForTotalOrder$str(), transactionMode));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidTxModeForTotalOrder$str() {
        return invalidTxModeForTotalOrder;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidCacheModeForTotalOrder(final java.lang.String friendlyCacheModeString) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidCacheModeForTotalOrder$str(), friendlyCacheModeString));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidCacheModeForTotalOrder$str() {
        return invalidCacheModeForTotalOrder;
    }

    public final org.infinispan.commons.CacheConfigurationException unavailableTotalOrderWithTxRecovery() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unavailableTotalOrderWithTxRecovery$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unavailableTotalOrderWithTxRecovery$str() {
        return unavailableTotalOrderWithTxRecovery;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidLockingModeForTotalOrder(final LockingMode lockingMode) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidLockingModeForTotalOrder$str(), lockingMode));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidLockingModeForTotalOrder$str() {
        return invalidLockingModeForTotalOrder;
    }

    public final org.infinispan.commons.CacheConfigurationException l1OnlyForDistributedCache(final java.lang.String cacheMode) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(l1OnlyForDistributedCache$str(), cacheMode));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String l1OnlyForDistributedCache$str() {
        return l1OnlyForDistributedCache;
    }

    public final org.infinispan.commons.CacheConfigurationException l1InvalidLifespan() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(l1InvalidLifespan$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String l1InvalidLifespan$str() {
        return l1InvalidLifespan;
    }

    public final org.infinispan.commons.CacheConfigurationException interceptorClassAndInstanceDefined(final java.lang.String customInterceptorClassName, final java.lang.String customInterceptor) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(interceptorClassAndInstanceDefined$str(), customInterceptorClassName, customInterceptor));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String interceptorClassAndInstanceDefined$str() {
        return interceptorClassAndInstanceDefined;
    }

    public final org.infinispan.commons.CacheConfigurationException unableToInstantiateClass(final java.lang.Class storeConfigurationClass) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unableToInstantiateClass$str(), storeConfigurationClass));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToInstantiateClass$str() {
        return unableToInstantiateClass;
    }

    public final org.infinispan.commons.CacheConfigurationException evictionSizeTooLarge(final long value) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(evictionSizeTooLarge$str(), value));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String evictionSizeTooLarge$str() {
        return evictionSizeTooLarge;
    }

    public final void xaResourceEndFailed(final XAResource resource, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), xaResourceEndFailed$str(), resource);
    }

    protected java.lang.String xaResourceEndFailed$str() {
        return xaResourceEndFailed;
    }

    public final org.infinispan.commons.CacheConfigurationException existingConfigForInternalCache(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(existingConfigForInternalCache$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String existingConfigForInternalCache$str() {
        return existingConfigForInternalCache;
    }

    public final org.infinispan.partitionhandling.AvailabilityException degradedModeKeysUnavailable(final java.util.Collection keys) {
        org.infinispan.partitionhandling.AvailabilityException result = new org.infinispan.partitionhandling.AvailabilityException(java.lang.String.format(degradedModeKeysUnavailable$str(), keys));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String degradedModeKeysUnavailable$str() {
        return degradedModeKeysUnavailable;
    }

    public final void evictionExecutorDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, evictionExecutorDeprecated$str());
    }

    protected java.lang.String evictionExecutorDeprecated$str() {
        return evictionExecutorDeprecated;
    }

    public final org.infinispan.commons.CacheException remoteTransactionAlreadyRolledBack(final org.infinispan.transaction.xa.GlobalTransaction gtx) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(remoteTransactionAlreadyRolledBack$str(), gtx));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String remoteTransactionAlreadyRolledBack$str() {
        return remoteTransactionAlreadyRolledBack;
    }

    public final org.infinispan.util.concurrent.TimeoutException remoteTransactionStatusMissing(final org.infinispan.transaction.xa.GlobalTransaction gtx) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(remoteTransactionStatusMissing$str(), gtx));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String remoteTransactionStatusMissing$str() {
        return remoteTransactionStatusMissing;
    }

    public final void noFilterIndexingServiceProviderFound(final java.lang.String filterClassName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, noFilterIndexingServiceProviderFound$str(), filterClassName);
    }

    protected java.lang.String noFilterIndexingServiceProviderFound$str() {
        return noFilterIndexingServiceProviderFound;
    }

    public final org.infinispan.commons.CacheException clusterListenerRegisteredWithOnlyPreEvents(final java.lang.Class listenerClass) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(clusterListenerRegisteredWithOnlyPreEvents$str(), listenerClass));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String clusterListenerRegisteredWithOnlyPreEvents$str() {
        return clusterListenerRegisteredWithOnlyPreEvents;
    }

    public final org.infinispan.commons.CacheConfigurationException jgroupsConfigurationNotFound(final java.lang.String cfg) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(jgroupsConfigurationNotFound$str(), cfg));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String jgroupsConfigurationNotFound$str() {
        return jgroupsConfigurationNotFound;
    }

    public final java.lang.IllegalArgumentException unableToAddNullCustomStore() {
        java.lang.IllegalArgumentException result = new java.lang.IllegalArgumentException(java.lang.String.format(unableToAddNullCustomStore$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToAddNullCustomStore$str() {
        return unableToAddNullCustomStore;
    }

    public final void memoryApproximationUnsupportedVM(final java.lang.String javaVM) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, memoryApproximationUnsupportedVM$str(), javaVM);
    }

    protected java.lang.String memoryApproximationUnsupportedVM$str() {
        return memoryApproximationUnsupportedVM;
    }

    public final java.lang.IllegalArgumentException illegalCacheName(final java.lang.String name) {
        java.lang.IllegalArgumentException result = new java.lang.IllegalArgumentException(java.lang.String.format(illegalCacheName$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String illegalCacheName$str() {
        return illegalCacheName;
    }

    public final java.lang.IllegalStateException configurationInUse(final java.lang.String configurationName) {
        java.lang.IllegalStateException result = new java.lang.IllegalStateException(java.lang.String.format(configurationInUse$str(), configurationName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String configurationInUse$str() {
        return configurationInUse;
    }

    public final org.infinispan.commons.CacheConfigurationException statisticsEnabledNotAvailable() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(statisticsEnabledNotAvailable$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String statisticsEnabledNotAvailable$str() {
        return statisticsEnabledNotAvailable;
    }

    public final org.infinispan.commons.CacheConfigurationException templateConfigurationStartAttempt(final java.lang.String cacheName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(templateConfigurationStartAttempt$str(), cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String templateConfigurationStartAttempt$str() {
        return templateConfigurationStartAttempt;
    }

    public final org.infinispan.commons.CacheConfigurationException undeclaredConfiguration(final java.lang.String extend, final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(undeclaredConfiguration$str(), extend, name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String undeclaredConfiguration$str() {
        return undeclaredConfiguration;
    }

    public final org.infinispan.commons.CacheConfigurationException noConfiguration(final java.lang.String extend) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(noConfiguration$str(), extend));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String noConfiguration$str() {
        return noConfiguration;
    }

    public final java.lang.UnsupportedOperationException interceptorStackNotSupported() {
        java.lang.UnsupportedOperationException result = new java.lang.UnsupportedOperationException(java.lang.String.format(interceptorStackNotSupported$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String interceptorStackNotSupported$str() {
        return interceptorStackNotSupported;
    }

    public final java.lang.UnsupportedOperationException lockOperationsNotSupported() {
        java.lang.UnsupportedOperationException result = new java.lang.UnsupportedOperationException(java.lang.String.format(lockOperationsNotSupported$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String lockOperationsNotSupported$str() {
        return lockOperationsNotSupported;
    }

    public final org.infinispan.commons.CacheConfigurationException invocationBatchingNotEnabled() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invocationBatchingNotEnabled$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invocationBatchingNotEnabled$str() {
        return invocationBatchingNotEnabled;
    }

    public final org.infinispan.commons.CacheConfigurationException distributedExecutorsNotSupported() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(distributedExecutorsNotSupported$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String distributedExecutorsNotSupported$str() {
        return distributedExecutorsNotSupported;
    }

    public final org.infinispan.commons.CacheConfigurationException notSupportedInSimpleCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(notSupportedInSimpleCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String notSupportedInSimpleCache$str() {
        return notSupportedInSimpleCache;
    }

    public final void missingGlobalStatePersistentLocation() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, missingGlobalStatePersistentLocation$str());
    }

    protected java.lang.String missingGlobalStatePersistentLocation$str() {
        return missingGlobalStatePersistentLocation;
    }

    public final void evictionMaxEntriesDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, evictionMaxEntriesDeprecated$str());
    }

    protected java.lang.String evictionMaxEntriesDeprecated$str() {
        return evictionMaxEntriesDeprecated;
    }

    public final java.lang.RuntimeException unableToBroadcastInvalidation(final java.lang.Throwable e) {
        java.lang.RuntimeException result = new java.lang.RuntimeException(java.lang.String.format(unableToBroadcastInvalidation$str()), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToBroadcastInvalidation$str() {
        return unableToBroadcastInvalidation;
    }

    public final void dataContainerConfigurationDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, dataContainerConfigurationDeprecated$str());
    }

    protected java.lang.String dataContainerConfigurationDeprecated$str() {
        return dataContainerConfigurationDeprecated;
    }

    public final org.infinispan.commons.CacheConfigurationException failedReadingPersistentState(final java.io.IOException e, final java.io.File stateFile) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(failedReadingPersistentState$str(), stateFile), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String failedReadingPersistentState$str() {
        return failedReadingPersistentState;
    }

    public final org.infinispan.commons.CacheConfigurationException failedWritingGlobalState(final java.io.IOException e, final java.io.File stateFile) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(failedWritingGlobalState$str(), stateFile), e);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String failedWritingGlobalState$str() {
        return failedWritingGlobalState;
    }

    public final org.infinispan.commons.CacheConfigurationException nonWritableStateFile(final java.io.File stateFile) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(nonWritableStateFile$str(), stateFile));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String nonWritableStateFile$str() {
        return nonWritableStateFile;
    }

    public final void globalStateLoad(final java.lang.String version, final java.lang.String timestamp) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, globalStateLoad$str(), version, timestamp);
    }

    protected java.lang.String globalStateLoad$str() {
        return globalStateLoad;
    }

    public final void globalStateWrite(final java.lang.String version, final java.lang.String timestamp) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, globalStateWrite$str(), version, timestamp);
    }

    protected java.lang.String globalStateWrite$str() {
        return globalStateWrite;
    }

    public final org.infinispan.commons.CacheConfigurationException recoveryNotSupportedWithNonTxCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(recoveryNotSupportedWithNonTxCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String recoveryNotSupportedWithNonTxCache$str() {
        return recoveryNotSupportedWithNonTxCache;
    }

    public final org.infinispan.commons.CacheConfigurationException recoveryNotSupportedWithSynchronization() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(recoveryNotSupportedWithSynchronization$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String recoveryNotSupportedWithSynchronization$str() {
        return recoveryNotSupportedWithSynchronization;
    }

    public final void transactionNotificationsDisabled() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, transactionNotificationsDisabled$str());
    }

    protected java.lang.String transactionNotificationsDisabled$str() {
        return transactionNotificationsDisabled;
    }

    public final void ignoringUnsolicitedState(final org.infinispan.remoting.transport.Address node, final int segment, final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.DEBUG), null, ignoringUnsolicitedState$str(), node, segment, cacheName);
    }

    protected java.lang.String ignoringUnsolicitedState$str() {
        return ignoringUnsolicitedState;
    }

    public final org.infinispan.commons.CacheException couldNotMigrateData(final java.lang.String name) {
        org.infinispan.commons.CacheException result = new org.infinispan.commons.CacheException(java.lang.String.format(couldNotMigrateData$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String couldNotMigrateData$str() {
        return couldNotMigrateData;
    }

    public final java.lang.IllegalStateException persistentConsistentHashMismatch(final java.lang.String hashFactory, final java.lang.String consistentHashClass) {
        java.lang.IllegalStateException result = new java.lang.IllegalStateException(java.lang.String.format(persistentConsistentHashMismatch$str(), hashFactory, consistentHashClass));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String persistentConsistentHashMismatch$str() {
        return persistentConsistentHashMismatch;
    }

    public final org.infinispan.util.concurrent.TimeoutException timeoutWaitingForInitialNodes(final int initialClusterSize, final java.util.List members) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(timeoutWaitingForInitialNodes$str(), initialClusterSize, members));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String timeoutWaitingForInitialNodes$str() {
        return timeoutWaitingForInitialNodes;
    }

    public final org.infinispan.remoting.transport.jgroups.SuspectException remoteNodeSuspected(final org.infinispan.remoting.transport.Address address) {
        org.infinispan.remoting.transport.jgroups.SuspectException result = new org.infinispan.remoting.transport.jgroups.SuspectException(java.lang.String.format(remoteNodeSuspected$str(), address));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String remoteNodeSuspected$str() {
        return remoteNodeSuspected;
    }

    public final org.infinispan.util.concurrent.TimeoutException remoteNodeTimedOut(final org.infinispan.remoting.transport.Address address, final long time, final TimeUnit unit) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(remoteNodeTimedOut$str(), address, time, unit));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String remoteNodeTimedOut$str() {
        return remoteNodeTimedOut;
    }

    public final org.infinispan.util.concurrent.TimeoutException coordinatorTimeoutWaitingForView(final int expectedViewId, final int currentViewId, final java.lang.Object clusterManagerStatus) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(coordinatorTimeoutWaitingForView$str(), expectedViewId, currentViewId, clusterManagerStatus));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String coordinatorTimeoutWaitingForView$str() {
        return coordinatorTimeoutWaitingForView;
    }

    public final void noIndexableClassesDefined() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, noIndexableClassesDefined$str());
    }

    protected java.lang.String noIndexableClassesDefined$str() {
        return noIndexableClassesDefined;
    }

    public final org.infinispan.commons.CacheConfigurationException classNotIndexable(final java.lang.String className) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(classNotIndexable$str(), className));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String classNotIndexable$str() {
        return classNotIndexable;
    }

    public final void failedInvokingCacheManagerListener(final java.lang.Exception e) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (e), failedInvokingCacheManagerListener$str());
    }

    protected java.lang.String failedInvokingCacheManagerListener$str() {
        return failedInvokingCacheManagerListener;
    }

    public final void ignoredReplicationQueueAttribute(final java.lang.String attributeName, final int line) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, ignoredReplicationQueueAttribute$str(), attributeName, line);
    }

    protected java.lang.String ignoredReplicationQueueAttribute$str() {
        return ignoredReplicationQueueAttribute;
    }

    public final org.infinispan.topology.CacheJoinException extraneousMembersJoinRestoredCache(final java.util.List extraneousMembers, final java.lang.String cacheName) {
        org.infinispan.topology.CacheJoinException result = new org.infinispan.topology.CacheJoinException(java.lang.String.format(extraneousMembersJoinRestoredCache$str(), extraneousMembers, cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String extraneousMembersJoinRestoredCache$str() {
        return extraneousMembersJoinRestoredCache;
    }

    public final org.infinispan.topology.CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(final org.infinispan.remoting.transport.Address joiner, final java.lang.String cacheName) {
        org.infinispan.topology.CacheJoinException result = new org.infinispan.topology.CacheJoinException(java.lang.String.format(nodeWithPersistentStateJoiningClusterWithoutState$str(), joiner, cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String nodeWithPersistentStateJoiningClusterWithoutState$str() {
        return nodeWithPersistentStateJoiningClusterWithoutState;
    }

    public final org.infinispan.topology.CacheJoinException nodeWithoutPersistentStateJoiningCacheWithState(final org.infinispan.remoting.transport.Address joiner, final java.lang.String cacheName) {
        org.infinispan.topology.CacheJoinException result = new org.infinispan.topology.CacheJoinException(java.lang.String.format(nodeWithoutPersistentStateJoiningCacheWithState$str(), joiner, cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String nodeWithoutPersistentStateJoiningCacheWithState$str() {
        return nodeWithoutPersistentStateJoiningCacheWithState;
    }

    public final org.infinispan.topology.CacheJoinException nodeWithIncompatibleStateJoiningCache(final org.infinispan.remoting.transport.Address joiner, final java.lang.String cacheName) {
        org.infinispan.topology.CacheJoinException result = new org.infinispan.topology.CacheJoinException(java.lang.String.format(nodeWithIncompatibleStateJoiningCache$str(), joiner, cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String nodeWithIncompatibleStateJoiningCache$str() {
        return nodeWithIncompatibleStateJoiningCache;
    }

    public final void warnAboutUberJarDuplicates() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnAboutUberJarDuplicates$str());
    }

    protected java.lang.String warnAboutUberJarDuplicates$str() {
        return warnAboutUberJarDuplicates;
    }

    public final org.infinispan.commons.CacheConfigurationException unknownTransactionConfiguration(final org.infinispan.transaction.TransactionMode mode, final boolean xaEnabled, final boolean recoveryEnabled, final boolean batchingEnabled) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unknownTransactionConfiguration$str(), mode, xaEnabled, recoveryEnabled, batchingEnabled));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unknownTransactionConfiguration$str() {
        return unknownTransactionConfiguration;
    }

    public final org.infinispan.commons.CacheConfigurationException unableToInstantiateSerializer(final java.lang.Class storeConfigurationClass) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unableToInstantiateSerializer$str(), storeConfigurationClass));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unableToInstantiateSerializer$str() {
        return unableToInstantiateSerializer;
    }

    public final org.infinispan.commons.CacheConfigurationException globalSecurityAuthShouldBeEnabled() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(globalSecurityAuthShouldBeEnabled$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String globalSecurityAuthShouldBeEnabled$str() {
        return globalSecurityAuthShouldBeEnabled;
    }

    public final void ignoredAttribute(final java.lang.String componentName, final java.lang.String version, final java.lang.String attributeName, final int line) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, ignoredAttribute$str(), componentName, version, attributeName, line);
    }

    protected java.lang.String ignoredAttribute$str() {
        return ignoredAttribute;
    }

    public final org.infinispan.commons.CacheConfigurationException transactionalStoreInNonTransactionalCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(transactionalStoreInNonTransactionalCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String transactionalStoreInNonTransactionalCache$str() {
        return transactionalStoreInNonTransactionalCache;
    }

    public final org.infinispan.commons.CacheConfigurationException transactionalStoreInPassivatedCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(transactionalStoreInPassivatedCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String transactionalStoreInPassivatedCache$str() {
        return transactionalStoreInPassivatedCache;
    }

    public final void evictionDisabled(final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, evictionDisabled$str(), cacheName);
    }

    protected java.lang.String evictionDisabled$str() {
        return evictionDisabled;
    }

    public final org.infinispan.commons.CacheConfigurationException attributeNotAllowedInInvalidationMode(final java.lang.String attributeName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(attributeNotAllowedInInvalidationMode$str(), attributeName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String attributeNotAllowedInInvalidationMode$str() {
        return attributeNotAllowedInInvalidationMode;
    }

    public final void viewHandlingError(final int viewId, final java.lang.Throwable t) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (t), viewHandlingError$str(), viewId);
    }

    protected java.lang.String viewHandlingError$str() {
        return viewHandlingError;
    }

    public final org.infinispan.util.concurrent.TimeoutException failedWaitingForTopology(final int requestTopologyId) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(failedWaitingForTopology$str(), requestTopologyId));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String failedWaitingForTopology$str() {
        return failedWaitingForTopology;
    }

    public final org.infinispan.commons.CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final java.lang.String otherExternalizer) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(duplicateExternalizerIdFound2$str(), externalizerId, otherExternalizer));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String duplicateExternalizerIdFound2$str() {
        return duplicateExternalizerIdFound2;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidEvictionSize() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidEvictionSize$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidEvictionSize$str() {
        return invalidEvictionSize;
    }

    public final org.infinispan.commons.CacheConfigurationException memoryEvictionInvalidStrategyLIRS() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(memoryEvictionInvalidStrategyLIRS$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String memoryEvictionInvalidStrategyLIRS$str() {
        return memoryEvictionInvalidStrategyLIRS;
    }

    public final org.infinispan.util.concurrent.TimeoutException timeoutWaitingForAcks(final java.lang.String timeout, final long id) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(timeoutWaitingForAcks$str(), timeout, id));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String timeoutWaitingForAcks$str() {
        return timeoutWaitingForAcks;
    }

    public final void evictionDeprecated() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, evictionDeprecated$str());
    }

    protected java.lang.String evictionDeprecated$str() {
        return evictionDeprecated;
    }

    public final org.infinispan.transaction.WriteSkewException writeSkewOnRead(final java.lang.Object key, final java.lang.Object key2, final org.infinispan.container.versioning.EntryVersion lastVersion, final org.infinispan.container.versioning.EntryVersion remoteVersion) {
        org.infinispan.transaction.WriteSkewException result = new org.infinispan.transaction.WriteSkewException(java.lang.String.format(writeSkewOnRead$str(), key2, lastVersion, remoteVersion), key);
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String writeSkewOnRead$str() {
        return writeSkewOnRead;
    }

    public final org.infinispan.commons.CacheConfigurationException nonSharedStoreConfiguredAsShared(final java.lang.String storeType) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(nonSharedStoreConfiguredAsShared$str(), storeType));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String nonSharedStoreConfiguredAsShared$str() {
        return nonSharedStoreConfiguredAsShared;
    }

    public final void warnStoreAnnotationMissing(final java.lang.String name) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnStoreAnnotationMissing$str(), name);
    }

    protected java.lang.String warnStoreAnnotationMissing$str() {
        return warnStoreAnnotationMissing;
    }

    public final org.infinispan.commons.CacheConfigurationException missingDefaultCacheDeclaration(final java.lang.String defaultCache) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(missingDefaultCacheDeclaration$str(), defaultCache));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String missingDefaultCacheDeclaration$str() {
        return missingDefaultCacheDeclaration;
    }

    public final org.infinispan.commons.CacheConfigurationException noDefaultCache() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(noDefaultCache$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String noDefaultCache$str() {
        return noDefaultCache;
    }

    public final void deprecatedDefaultCache() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, deprecatedDefaultCache$str());
    }

    protected java.lang.String deprecatedDefaultCache$str() {
        return deprecatedDefaultCache;
    }

    public final void defaultCacheConfigurationWithoutName() {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, defaultCacheConfigurationWithoutName$str());
    }

    protected java.lang.String defaultCacheConfigurationWithoutName$str() {
        return defaultCacheConfigurationWithoutName;
    }

    public final org.infinispan.commons.CacheConfigurationException noSuchCacheConfiguration(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(noSuchCacheConfiguration$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String noSuchCacheConfiguration$str() {
        return noSuchCacheConfiguration;
    }

    public final void warnConfigurationForAnnotationMissing(final java.lang.String name) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnConfigurationForAnnotationMissing$str(), name);
    }

    protected java.lang.String warnConfigurationForAnnotationMissing$str() {
        return warnConfigurationForAnnotationMissing;
    }

    public final org.infinispan.commons.CacheConfigurationException duplicateCacheName(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(duplicateCacheName$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String duplicateCacheName$str() {
        return duplicateCacheName;
    }

    public final void receivedXSiteClusterView(final Set view) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.INFO), null, receivedXSiteClusterView$str(), view);
    }

    protected java.lang.String receivedXSiteClusterView$str() {
        return receivedXSiteClusterView;
    }

    public final void errorSendingResponse(final org.infinispan.commands.ReplicableCommand command) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), null, errorSendingResponse$str(), command);
    }

    protected java.lang.String errorSendingResponse$str() {
        return errorSendingResponse;
    }

    public final org.infinispan.commons.CacheConfigurationException unsupportedAsyncCacheMode(final CacheMode cacheMode) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(unsupportedAsyncCacheMode$str(), cacheMode));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String unsupportedAsyncCacheMode$str() {
        return unsupportedAsyncCacheMode;
    }

    public final org.infinispan.commons.CacheConfigurationException singletonStoreCannotBeShared(final java.lang.String name) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(singletonStoreCannotBeShared$str(), name));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String singletonStoreCannotBeShared$str() {
        return singletonStoreCannotBeShared;
    }

    public final org.infinispan.commons.CacheConfigurationException clusteredTransactionalStoreMustBeShared(final java.lang.String simpleName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(clusteredTransactionalStoreMustBeShared$str(), simpleName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String clusteredTransactionalStoreMustBeShared$str() {
        return clusteredTransactionalStoreMustBeShared;
    }

    public final org.infinispan.commons.CacheConfigurationException transactionalStoreCannotBeAsync(final java.lang.String simpleName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(transactionalStoreCannotBeAsync$str(), simpleName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String transactionalStoreCannotBeAsync$str() {
        return transactionalStoreCannotBeAsync;
    }

    public final org.infinispan.commons.CacheConfigurationException onlyOneFetchPersistentStoreAllowed() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(onlyOneFetchPersistentStoreAllowed$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String onlyOneFetchPersistentStoreAllowed$str() {
        return onlyOneFetchPersistentStoreAllowed;
    }

    public final org.infinispan.commons.CacheConfigurationException multipleSitesWithSameName(final java.lang.String site) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(multipleSitesWithSameName$str(), site));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String multipleSitesWithSameName$str() {
        return multipleSitesWithSameName;
    }

    public final org.infinispan.commons.CacheConfigurationException siteMustBeInBackups(final java.lang.String site) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(siteMustBeInBackups$str(), site));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String siteMustBeInBackups$str() {
        return siteMustBeInBackups;
    }

    public final org.infinispan.commons.CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(awaitInitialTransferOnlyForDistOrRepl$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String awaitInitialTransferOnlyForDistOrRepl$str() {
        return awaitInitialTransferOnlyForDistOrRepl;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidXSiteStateTransferTimeout() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidXSiteStateTransferTimeout$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidXSiteStateTransferTimeout$str() {
        return invalidXSiteStateTransferTimeout;
    }

    public final org.infinispan.commons.CacheConfigurationException invalidXSiteStateTransferWaitTime() {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(invalidXSiteStateTransferWaitTime$str()));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String invalidXSiteStateTransferWaitTime$str() {
        return invalidXSiteStateTransferWaitTime;
    }

    public final org.infinispan.util.concurrent.TimeoutException timeoutWaitingForView(final int expectedViewId, final int currentViewId) {
        org.infinispan.util.concurrent.TimeoutException result = new org.infinispan.util.concurrent.TimeoutException(java.lang.String.format(timeoutWaitingForView$str(), expectedViewId, currentViewId));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String timeoutWaitingForView$str() {
        return timeoutWaitingForView;
    }

    public final void topologyUpdateError(final java.lang.String cacheName, final java.lang.Throwable cause) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.ERROR), (cause), topologyUpdateError$str(), cacheName);
    }

    protected java.lang.String topologyUpdateError$str() {
        return topologyUpdateError;
    }

    public final org.infinispan.commons.CacheConfigurationException configAlreadyDefined(final java.lang.String cacheName) {
        org.infinispan.commons.CacheConfigurationException result = new org.infinispan.commons.CacheConfigurationException(java.lang.String.format(configAlreadyDefined$str(), cacheName));
        java.lang.StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected java.lang.String configAlreadyDefined$str() {
        return configAlreadyDefined;
    }

    public final void warnAttemptToOverrideExistingConfiguration(final java.lang.String cacheName) {
        super.log.logf(FQCN, (org.jboss.logging.Logger.Level.WARN), null, warnAttemptToOverrideExistingConfiguration$str(), cacheName);
    }

    protected java.lang.String warnAttemptToOverrideExistingConfiguration$str() {
        return warnAttemptToOverrideExistingConfiguration;
    }

}
