/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.dmr;

import infinispan.org.jboss.dmr.Base64;
import infinispan.org.jboss.dmr.JSONParser;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.yuanheng.cookcc.CookCCOption;
import org.yuanheng.cookcc.CookCCToken;
import org.yuanheng.cookcc.Lex;
import org.yuanheng.cookcc.Lexs;
import org.yuanheng.cookcc.Rule;
import org.yuanheng.cookcc.Rules;

@CookCCOption
public class JSONParserImpl
extends JSONParser {
    private ModelNode result;

    @Lexs(patterns={@Lex(pattern="\\{", token="OPEN_BRACE"), @Lex(pattern="\\}", token="CLOSE_BRACE"), @Lex(pattern="\\[", token="OPEN_BRACKET"), @Lex(pattern="\\]", token="CLOSE_BRACKET"), @Lex(pattern=",", token="COMMA"), @Lex(pattern=":", token="COLON"), @Lex(pattern="true", token="TRUE"), @Lex(pattern="false", token="FALSE"), @Lex(pattern="big", token="BIG"), @Lex(pattern="decimal", token="DECIMAL"), @Lex(pattern="integer", token="INTEGER"), @Lex(pattern="null", token="UNDEFINED")})
    protected Void parseToken() {
        return null;
    }

    @Lexs(patterns={@Lex(pattern="[+-]?0+", token="ZERO_VAL"), @Lex(pattern="[+-]?0[0-9]+", token="OCTAL_INT_VAL"), @Lex(pattern="0x[0-9a-fA-F]+", token="HEX_INT_VAL"), @Lex(pattern="[+-]0x[0-9a-fA-F]+", token="SIGNED_HEX_INT_VAL"), @Lex(pattern="[+-]?[1-9][0-9]*", token="DEC_INT_VAL"), @Lex(pattern="[+-]?NaN", token="NAN_VAL"), @Lex(pattern="[+-]?Infinity", token="INF_VAL"), @Lex(pattern="[+-]?([0-9]+\\.[0-9]+([eE][+-]?[0-9]+)?)", token="DEC_VAL")})
    protected String parsePlainValue() {
        return this.yyText();
    }

    @Lex(pattern="\\\"([^\"\\\\]+|\\\\.)*\\\"", token="STR_VAL")
    protected String parseStringValue() throws IOException {
        String yyText = this.yyText();
        int length = yyText.length();
        StringBuilder b = new StringBuilder(length);
        int i = 1;
        while (i < length - 1) {
            int ch = yyText.codePointAt(i);
            block0 : switch (ch) {
                case 92: {
                    i = yyText.offsetByCodePoints(i, 1);
                    ch = yyText.codePointAt(i);
                    switch (ch) {
                        case 110: {
                            b.append('\n');
                            break block0;
                        }
                        case 114: {
                            b.append('\r');
                            break block0;
                        }
                        case 98: {
                            b.append('\b');
                            break block0;
                        }
                        case 102: {
                            b.append('\f');
                            break block0;
                        }
                        case 116: {
                            b.append('\t');
                            break block0;
                        }
                        case 117: {
                            b.append((char)Integer.parseInt(yyText.substring(i + 1, i + 5), 16));
                            i += 4;
                            break block0;
                        }
                    }
                    b.appendCodePoint(ch);
                    break;
                }
                default: {
                    b.appendCodePoint(ch);
                }
            }
            i = yyText.offsetByCodePoints(i, 1);
        }
        return b.toString();
    }

    @Lex(pattern="[ \\t\\r\\n]+")
    protected void ignored() {
    }

    @Lex(pattern=".")
    protected void invalid() throws IOException {
        throw new IOException("Invalid character: " + this.yyText());
    }

    @Lex(pattern="<<EOF>>", token="$")
    protected void parseEOF() {
    }

    @Rule(lhs="complete", rhs="node", args="1")
    protected int parse(ModelNode node) {
        this.result = node;
        return 0;
    }

    @Rules(rules={@Rule(lhs="node", rhs="ZERO_VAL")})
    protected ModelNode parseZero() {
        return new ModelNode().set(0);
    }

    @Rules(rules={@Rule(lhs="node", rhs="DEC_VAL", args="1")})
    protected ModelNode parseBigDecimal(String arg) {
        return new ModelNode().set(new BigDecimal(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="NAN_VAL")})
    protected ModelNode parseNaN() {
        return new ModelNode().set(Double.NaN);
    }

    @Rules(rules={@Rule(lhs="node", rhs="INF_VAL", args="1")})
    protected ModelNode parseInf(String arg) {
        return new ModelNode().set(arg.charAt(0) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
    }

    @Rules(rules={@Rule(lhs="node", rhs="DEC_INT_VAL", args="1")})
    protected ModelNode parseDecInt(String arg) {
        return JSONParserImpl.parseInteger0(arg, 10);
    }

    @Rules(rules={@Rule(lhs="node", rhs="OCTAL_INT_VAL", args="1")})
    protected ModelNode parseOctal(String arg) {
        return JSONParserImpl.parseInteger0(arg, 8);
    }

    @Rules(rules={@Rule(lhs="node", rhs="HEX_INT_VAL", args="1")})
    protected ModelNode parseHex(String arg) {
        return JSONParserImpl.parseInteger0(arg.substring(2), 16);
    }

    @Rules(rules={@Rule(lhs="node", rhs="SIGNED_HEX_INT_VAL", args="1")})
    protected ModelNode parseHexSigned(String arg) {
        return JSONParserImpl.parseInteger0("" + arg.charAt(0) + arg.substring(3), 16);
    }

    private static ModelNode parseInteger0(String arg, int radix) {
        BigInteger val = new BigInteger(arg, radix);
        if (val.bitLength() <= 31) {
            return new ModelNode().set(val.intValue());
        }
        if (val.bitLength() <= 63) {
            return new ModelNode().set(val.longValue());
        }
        return new ModelNode().set(val);
    }

    @Rule(lhs="node", rhs="TRUE")
    protected ModelNode parseTrue() {
        return new ModelNode().set(true);
    }

    @Rule(lhs="node", rhs="FALSE")
    protected ModelNode parseFalse() {
        return new ModelNode().set(false);
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACKET CLOSE_BRACKET")})
    protected ModelNode parseEmptyList() {
        return new ModelNode().setEmptyList();
    }

    @Rules(rules={@Rule(lhs="list", rhs="OPEN_BRACKET node", args="2")})
    protected ModelNode parseStartList(ModelNode child) {
        return new ModelNode().addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="list", rhs="list COMMA node", args="1 3")})
    protected ModelNode parseListItem(ModelNode list, ModelNode child) {
        return list.addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="node", rhs="list CLOSE_BRACKET", args="1"), @Rule(lhs="node", rhs="list COMMA CLOSE_BRACKET", args="1")})
    protected ModelNode finishList(ModelNode list) {
        return list;
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACE CLOSE_BRACE")})
    protected ModelNode parseEmptyObject() {
        return new ModelNode().setEmptyObject();
    }

    @Rules(rules={@Rule(lhs="object", rhs="OPEN_BRACE STR_VAL COLON node", args="2 4")})
    protected ModelNode parseStartObject(String key, ModelNode child) {
        if ("TYPE_MODEL_VALUE".equals(key)) {
            return this.parseType(child.toString().replaceAll("\"", ""));
        }
        if ("BYTES_VALUE".equals(key)) {
            return this.parseBase64(child.toString().replaceAll("\"", ""));
        }
        if ("EXPRESSION_VALUE".equals(key)) {
            return this.parseExpression(child.toString().replaceAll("\"", ""));
        }
        if ("PROPERTY_VALUE".equals(key)) {
            return this.parseProperty(child);
        }
        ModelNode node = new ModelNode();
        node.get(key).setNoCopy(child);
        return node;
    }

    @Rules(rules={@Rule(lhs="object", rhs="object COMMA STR_VAL COLON node", args="1 3 5")})
    protected ModelNode parseObjectItem(ModelNode object, String key, ModelNode child) {
        object.get(key).setNoCopy(child);
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="object CLOSE_BRACE", args="1"), @Rule(lhs="node", rhs="object COMMA CLOSE_BRACE", args="1")})
    protected ModelNode finishObject(ModelNode object) {
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="STR_VAL", args="1")})
    protected ModelNode parseString(String arg) {
        return new ModelNode().set(arg);
    }

    @Rule(lhs="node", rhs="UNDEFINED")
    protected ModelNode parseUndefined() {
        return new ModelNode();
    }

    private ModelNode parseType(String arg) {
        return new ModelNode().set(ModelType.valueOf(arg));
    }

    private ModelNode parseBase64(String arg) {
        ModelNode node = new ModelNode();
        node.set(Base64.decode(arg));
        return node;
    }

    private ModelNode parseExpression(String arg) {
        return new ModelNode().setExpression(arg);
    }

    private ModelNode parseProperty(ModelNode value) {
        return new ModelNode().set(value.asProperty());
    }

    public ModelNode getResult() {
        return this.result;
    }

    @CookCCToken
    static enum Token {
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        COLON,
        COMMA,
        BIG,
        INTEGER,
        DECIMAL,
        UNDEFINED,
        TRUE,
        FALSE,
        ZERO_VAL,
        OCTAL_INT_VAL,
        HEX_INT_VAL,
        SIGNED_HEX_INT_VAL,
        DEC_INT_VAL,
        NAN_VAL,
        INF_VAL,
        DEC_VAL,
        STR_VAL;

    }
}

