/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Status;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractFunctionalMap<K, V>
implements FunctionalMap<K, V> {
    private static final Log log = LogFactory.getLog(FunctionalMap.class);
    protected final FunctionalMapImpl<K, V> fmap;
    private final boolean transactional;
    private final boolean autoCommit;
    private final BatchContainer batchContainer;
    private final TransactionManager transactionManager;

    protected AbstractFunctionalMap(FunctionalMapImpl<K, V> fmap) {
        this.fmap = fmap;
        Configuration config = fmap.cache.getCacheConfiguration();
        this.transactional = config.transaction().transactionMode().isTransactional();
        this.autoCommit = config.transaction().autoCommit();
        this.transactionManager = this.transactional ? fmap.cache.getTransactionManager() : null;
        this.batchContainer = this.transactional && config.invocationBatching().enabled() ? fmap.cache.getBatchContainer() : null;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Status getStatus() {
        return this.fmap.getStatus();
    }

    @Override
    public void close() throws Exception {
        this.fmap.close();
    }

    protected InvocationContext getInvocationContext(boolean isWrite, int keyCount) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.transactional) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.autoCommit && this.transactionManager != null) {
                try {
                    this.transactionManager.begin();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheException("Unable to begin implicit transaction.", e);
                }
                transaction = this.getOngoingTransaction();
                txInjected = true;
            }
            invocationContext = this.fmap.invCtxFactory().createInvocationContext(transaction, txInjected);
        } else {
            invocationContext = this.fmap.invCtxFactory().createInvocationContext(isWrite, keyCount);
        }
        return invocationContext;
    }

    protected void commitIfNeeded(InvocationContext ctx) {
        if (ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction() && this.transactionManager != null) {
            try {
                this.transactionManager.commit();
            }
            catch (Throwable e) {
                log.couldNotCompleteInjectedTransaction(e);
                throw new CacheException("Could not commit implicit transaction", e);
            }
        }
    }

    protected void rollbackIfNeeded(InvocationContext ctx) {
        if (ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction()) {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                log.trace("Could not rollback", t);
            }
        }
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.batchContainer != null) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", e);
        }
    }

    protected Object invoke(InvocationContext ctx, VisitableCommand cmd) {
        Object result;
        try {
            result = this.fmap.chain().invoke(ctx, cmd);
        }
        catch (Throwable t) {
            try {
                this.rollbackIfNeeded(ctx);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
        this.commitIfNeeded(ctx);
        return result;
    }
}

