/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredCacheLoaderInterceptor
extends CacheLoaderInterceptor {
    private static final Log log = LogFactory.getLog(ClusteredCacheLoaderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean transactional;
    private StateTransferManager stateTransferManager;
    private DistributionManager distributionManager;

    @Inject
    private void injectDependencies(StateTransferManager stateTransferManager, DistributionManager distributionManager) {
        this.stateTransferManager = stateTransferManager;
        this.distributionManager = distributionManager;
    }

    @Start(priority=15)
    private void startClusteredCacheLoaderInterceptor() {
        this.transactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (this.transactional) {
            if (!ctx.isOriginLocal() && cmd.loadType() != VisitableCommand.LoadType.OWNER) {
                return true;
            }
        } else {
            switch (cmd.loadType()) {
                case DONT_LOAD: {
                    return true;
                }
                case PRIMARY: {
                    if (cmd.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                        return cmd.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
                    }
                    if (this.distributionManager.getCacheTopology().getDistribution(key).isPrimary()) break;
                    if (trace) {
                        log.tracef("Skip load for command %s. This node is not the primary owner of %s", (Object)cmd, (Object)Util.toStr(key));
                    }
                    return true;
                }
                case OWNER: {
                    if (cmd.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                        return cmd.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
                    }
                    DistributionInfo info = this.distributionManager.getCacheTopology().getDistribution(key);
                    if (info.isPrimary() || info.isWriteOwner() && !ctx.isOriginLocal()) break;
                    if (trace) {
                        log.tracef("Skip load for command %s. This node is neither the primary owner nor non-origin backup of %s", (Object)cmd, (Object)Util.toStr(key));
                    }
                    return true;
                }
            }
        }
        return super.skipLoadForWriteCommand(cmd, key, ctx);
    }

    @Override
    protected boolean canLoad(Object key) {
        return this.stateTransferManager.isJoinComplete() && this.isKeyLocal(key);
    }

    private boolean isKeyLocal(Object key) {
        return this.distributionManager.getCacheTopology().isReadOwner(key);
    }
}

