/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Type;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.jpa.JpaStoreException;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.jpa.impl.EntityManagerFactoryRegistry;
import org.infinispan.persistence.jpa.impl.MetadataEntity;
import org.infinispan.persistence.jpa.impl.MetadataEntityKey;
import org.infinispan.persistence.jpa.impl.Stats;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Store(shared=true)
@ConfiguredBy(value=JpaStoreConfiguration.class)
public class JpaStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(JpaStore.class);
    private static boolean trace = log.isTraceEnabled();
    private JpaStoreConfiguration configuration;
    private EntityManagerFactory emf;
    private EntityManagerFactoryRegistry emfRegistry;
    private StreamingMarshaller marshaller;
    private MarshalledEntryFactory marshallerEntryFactory;
    private TimeService timeService;
    private Stats stats = new Stats();
    private boolean setFetchSizeMinInteger = false;

    @Override
    public void init(InitializationContext ctx) {
        this.configuration = (JpaStoreConfiguration)ctx.getConfiguration();
        this.emfRegistry = ctx.getCache().getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(EntityManagerFactoryRegistry.class);
        this.marshallerEntryFactory = ctx.getMarshalledEntryFactory();
        this.marshaller = ctx.getMarshaller();
        this.timeService = ctx.getTimeService();
    }

    @Override
    public void start() {
        Dialect dialect;
        EntityType mt;
        this.emf = this.emfRegistry.getEntityManagerFactory(this.configuration.persistenceUnitName());
        try {
            mt = this.emf.getMetamodel().entity(this.configuration.entityClass());
        }
        catch (IllegalArgumentException e) {
            throw new JpaStoreException("Entity class [" + this.configuration.entityClass().getName() + " specified in configuration is not recognized by the EntityManagerFactory with Persistence Unit [" + this.configuration.persistenceUnitName() + "]", e);
        }
        if (!(mt instanceof IdentifiableType)) {
            throw new JpaStoreException("Entity class must have one and only one identifier (@Id or @EmbeddedId)");
        }
        IdentifiableType it = (IdentifiableType)mt;
        if (!it.hasSingleIdAttribute()) {
            throw new JpaStoreException("Entity class has more than one identifier.  It must have only one identifier.");
        }
        Type idType = it.getIdType();
        Class idJavaType = idType.getJavaType();
        if (idJavaType.isAnnotationPresent(GeneratedValue.class)) {
            throw new JpaStoreException("Entity class has one identifier, but it must not have @GeneratedValue annotation");
        }
        SessionFactory sessionFactory = ((Session)this.emf.createEntityManager().unwrap(Session.class)).getSessionFactory();
        if (sessionFactory instanceof SessionFactoryImplementor && (dialect = ((SessionFactoryImplementor)sessionFactory).getDialect()) instanceof MySQLDialect) {
            this.setFetchSizeMinInteger = true;
        }
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    @Override
    public void stop() {
        try {
            this.emfRegistry.closeEntityManagerFactory(this.configuration.persistenceUnitName());
        }
        catch (Exception e) {
            throw new JpaStoreException("Exceptions occurred while stopping store", e);
        }
        finally {
            log.info("JPA Store stopped, stats: " + this.stats);
        }
    }

    protected boolean isValidKeyType(Object key) {
        return this.emf.getMetamodel().entity(this.configuration.entityClass()).getIdType().getJavaType().isAssignableFrom(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findEntity(EntityManager em, Object key) {
        long begin = this.timeService.time();
        try {
            Object object = em.find(this.configuration.entityClass(), key);
            return object;
        }
        finally {
            this.stats.addEntityFind(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataEntity findMetadata(EntityManager em, Object key) {
        long begin = this.timeService.time();
        try {
            MetadataEntity metadataEntity = (MetadataEntity)em.find(MetadataEntity.class, key);
            return metadataEntity;
        }
        finally {
            this.stats.addMetadataFind(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(EntityManager em, Object entity) {
        long begin = this.timeService.time();
        try {
            em.remove(entity);
        }
        finally {
            this.stats.addEntityRemove(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadata(EntityManager em, MetadataEntity metadata) {
        long begin = this.timeService.time();
        try {
            em.remove((Object)metadata);
        }
        finally {
            this.stats.addMetadataRemove(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeEntity(EntityManager em, Object entity) {
        long begin = this.timeService.time();
        try {
            em.merge(entity);
        }
        finally {
            this.stats.addEntityMerge(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeMetadata(EntityManager em, MetadataEntity metadata) {
        long begin = this.timeService.time();
        try {
            em.merge((Object)metadata);
        }
        finally {
            this.stats.addMetadataMerge(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try (EntityManager emStream = this.emf.createEntityManager();){
            ScrollableResults results = null;
            ArrayList<Object> batch = new ArrayList<Object>((int)this.configuration.batchSize());
            EntityTransaction txStream = emStream.getTransaction();
            txStream.begin();
            try {
                log.trace("Clearing JPA Store");
                Session session = (Session)emStream.unwrap(Session.class);
                Criteria criteria = session.createCriteria(this.configuration.entityClass()).setReadOnly(true).setProjection((Projection)Projections.id());
                if (this.setFetchSizeMinInteger) {
                    criteria.setFetchSize(Integer.MIN_VALUE);
                }
                results = criteria.scroll(ScrollMode.FORWARD_ONLY);
                while (results.next()) {
                    Object o = results.get(0);
                    batch.add(o);
                    if ((long)batch.size() != this.configuration.batchSize()) continue;
                    session.clear();
                    this.removeBatch(batch);
                }
                if (this.configuration.storeMetadata()) {
                    results.close();
                    results = null;
                    String metadataTable = emStream.getMetamodel().entity(MetadataEntity.class).getName();
                    Query clearMetadata = emStream.createQuery("DELETE FROM " + metadataTable);
                    clearMetadata.executeUpdate();
                }
                txStream.commit();
            }
            finally {
                this.removeBatch(batch);
                if (results != null) {
                    results.close();
                }
                if (txStream != null && txStream.isActive()) {
                    txStream.rollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeBatch(ArrayList<Object> batch) {
        for (int i = 10; i >= 0; --i) {
            EntityManager emExec = this.emf.createEntityManager();
            EntityTransaction txn = null;
            txn = emExec.getTransaction();
            txn.begin();
            for (Object key : batch) {
                try {
                    Object entity = emExec.getReference(this.configuration.entityClass(), key);
                    this.removeEntity(emExec, entity);
                }
                catch (EntityNotFoundException e) {
                    log.trace("Cleared entity with key " + key + " not found", e);
                }
            }
            txn.commit();
            batch.clear();
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            emExec.close();
            break;
            {
                catch (Exception e) {
                    try {
                        if (i != 0) {
                            log.trace("Remove batch failed once", e);
                            continue;
                        }
                        throw new JpaStoreException("Remove batch failing", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (txn != null && txn.isActive()) {
                            txn.rollback();
                        }
                        emExec.close();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean delete(Object key) {
        if (!this.isValidKeyType(key)) {
            return false;
        }
        try (EntityManager em = this.emf.createEntityManager();){
            Object entity = this.findEntity(em, key);
            if (entity == null) {
                boolean bl = false;
                return bl;
            }
            MetadataEntity metadata = null;
            if (this.configuration.storeMetadata()) {
                byte[] keyBytes;
                try {
                    keyBytes = this.marshaller.objectToByteBuffer(key);
                }
                catch (Exception e) {
                    throw new JpaStoreException("Failed to marshall key", e);
                }
                metadata = this.findMetadata(em, new MetadataEntityKey(keyBytes));
            }
            EntityTransaction txn = em.getTransaction();
            if (trace) {
                log.trace("Removing " + entity + "(" + this.toString(metadata) + ")");
            }
            long txnBegin = this.timeService.time();
            txn.begin();
            try {
                this.removeEntity(em, entity);
                if (metadata != null) {
                    this.removeMetadata(em, metadata);
                }
                txn.commit();
                this.stats.addRemoveTxCommitted(this.timeService.time() - txnBegin);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.stats.addRemoveTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in delete()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MarshalledEntry entry) {
        EntityManager em = this.emf.createEntityManager();
        Object entity = entry.getValue();
        MetadataEntity metadata = this.configuration.storeMetadata() ? new MetadataEntity(entry.getKeyBytes(), entry.getMetadataBytes(), entry.getMetadata() == null ? Long.MAX_VALUE : entry.getMetadata().expiryTime()) : null;
        try {
            if (!this.configuration.entityClass().isAssignableFrom(entity.getClass())) {
                throw new JpaStoreException(String.format("This cache is configured with JPA CacheStore to only store values of type %s - cannot write %s = %s", this.configuration.entityClass().getName(), entity, entity.getClass().getName()));
            }
            EntityTransaction txn = em.getTransaction();
            Object id = this.emf.getPersistenceUnitUtil().getIdentifier(entity);
            if (!entry.getKey().equals(id)) {
                throw new JpaStoreException("Entity id value must equal to key of cache entry: key = [" + entry.getKey() + "], id = [" + id + "]");
            }
            long txnBegin = this.timeService.time();
            try {
                if (trace) {
                    log.trace("Writing " + entity + "(" + this.toString(metadata) + ")");
                }
                txn.begin();
                this.mergeEntity(em, entity);
                if (metadata != null && metadata.hasBytes()) {
                    this.mergeMetadata(em, metadata);
                }
                txn.commit();
                this.stats.addWriteTxCommited(this.timeService.time() - txnBegin);
            }
            catch (Exception e) {
                this.stats.addWriteTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in write()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public MarshalledEntry load(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        if (fetchMetadata && !this.configuration.storeMetadata()) {
            log.debug("Metadata cannot be retrieved as JPA Store is not configured to persist metadata.");
            fetchMetadata = false;
        }
        if (fetchValue || fetchMetadata) {
            final boolean fv = fetchValue;
            final boolean fm = fetchMetadata;
            this.process(filter, task, executor, new ProcessStrategy(){

                @Override
                public Criteria getCriteria(Session session) {
                    return session.createCriteria(JpaStore.this.configuration.entityClass()).setProjection((Projection)Projections.id());
                }

                @Override
                public Object getKey(Object scrollResult) {
                    return scrollResult;
                }

                @Override
                public Callable<Void> getTask(AdvancedCacheLoader.CacheLoaderTask task, AdvancedCacheLoader.TaskContext taskContext, Object scrollResult, Object key) {
                    return new LoadingProcessTask(task, taskContext, key, fv, fm);
                }
            });
        } else {
            this.process(filter, task, executor, new ProcessStrategy(){

                @Override
                public Criteria getCriteria(Session session) {
                    return session.createCriteria(JpaStore.this.configuration.entityClass()).setProjection((Projection)Projections.id());
                }

                @Override
                public Object getKey(Object scrollResult) {
                    return scrollResult;
                }

                @Override
                public Callable<Void> getTask(AdvancedCacheLoader.CacheLoaderTask task, AdvancedCacheLoader.TaskContext taskContext, Object scrollResult, Object key) {
                    return new ProcessTask(task, taskContext, key, null, null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, ProcessStrategy strategy) {
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        TaskContextImpl taskContext = new TaskContextImpl();
        try (EntityManager emStream = this.emf.createEntityManager();){
            EntityTransaction txStream = emStream.getTransaction();
            ScrollableResults results = null;
            txStream.begin();
            try {
                Session session = (Session)emStream.unwrap(Session.class);
                Criteria criteria = strategy.getCriteria(session).setReadOnly(true);
                if (this.setFetchSizeMinInteger) {
                    criteria.setFetchSize(Integer.MIN_VALUE);
                }
                results = criteria.scroll(ScrollMode.FORWARD_ONLY);
                try {
                    while (results.next()) {
                        if (taskContext.isStopped()) {
                            break;
                        }
                        Object result = results.get(0);
                        Object key = strategy.getKey(result);
                        if (filter != null && !filter.accept(key)) {
                            if (!trace) continue;
                            log.trace("Key " + key + " filtered");
                            continue;
                        }
                        eacs.submit(strategy.getTask(task, taskContext, result, key));
                    }
                }
                finally {
                    if (results != null) {
                        results.close();
                    }
                }
                txStream.commit();
            }
            finally {
                if (txStream != null && txStream.isActive()) {
                    txStream.rollback();
                }
            }
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new PersistenceException("Execution exception!", eacs.getFirstException());
        }
    }

    private InternalMetadata getMetadata(EntityManager em, Object key) {
        byte[] keyBytes;
        try {
            keyBytes = this.marshaller.objectToByteBuffer(key);
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to marshall key", e);
        }
        MetadataEntity m = this.findMetadata(em, new MetadataEntityKey(keyBytes));
        if (m == null) {
            return null;
        }
        try {
            return (InternalMetadata)this.marshaller.objectFromByteBuffer(m.getMetadata());
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to unmarshall metadata", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        EntityManager em = this.emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        txn.begin();
        try {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery cq = builder.createQuery(Long.class);
            cq.select((Selection)builder.count((Expression)cq.from(this.configuration.entityClass())));
            int n = ((Long)em.createQuery(cq).getSingleResult()).intValue();
            return n;
        }
        finally {
            try {
                txn.commit();
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
        if (!this.configuration.storeMetadata()) {
            log.debug("JPA Store cannot be purged as metadata holding expirations are not available");
            return;
        }
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(threadPool);
        try (EntityManager emStream = this.emf.createEntityManager();){
            EntityTransaction txStream = emStream.getTransaction();
            ScrollableResults metadataKeys = null;
            txStream.begin();
            try {
                long currentTime = this.timeService.wallClockTime();
                Session session = (Session)emStream.unwrap(Session.class);
                Criteria criteria = session.createCriteria(MetadataEntity.class).setReadOnly(true).add((Criterion)Restrictions.le((String)"expiration", (Object)currentTime)).setProjection((Projection)Projections.id());
                if (this.setFetchSizeMinInteger) {
                    criteria.setFetchSize(Integer.MIN_VALUE);
                }
                metadataKeys = criteria.scroll(ScrollMode.FORWARD_ONLY);
                ArrayList<MetadataEntityKey> batch = new ArrayList<MetadataEntityKey>((int)this.configuration.batchSize());
                while (metadataKeys.next()) {
                    MetadataEntityKey mKey = (MetadataEntityKey)metadataKeys.get(0);
                    batch.add(mKey);
                    if ((long)batch.size() != this.configuration.batchSize()) continue;
                    this.purgeBatch(batch, listener, eacs, currentTime);
                    batch.clear();
                }
                this.purgeBatch(batch, listener, eacs, currentTime);
                txStream.commit();
            }
            finally {
                if (metadataKeys != null) {
                    metadataKeys.close();
                }
                if (txStream != null && txStream.isActive()) {
                    txStream.rollback();
                }
            }
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new JpaStoreException(eacs.getFirstException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeBatch(List<MetadataEntityKey> batch, final AdvancedCacheWriter.PurgeListener listener, ExecutorAllCompletionService eacs, long currentTime) {
        try (EntityManager emExec = this.emf.createEntityManager();){
            EntityTransaction txn = emExec.getTransaction();
            txn.begin();
            try {
                for (MetadataEntityKey metadataKey : batch) {
                    Object key;
                    MetadataEntity metadata = this.findMetadata(emExec, metadataKey);
                    if (metadata.getExpiration() > currentTime) continue;
                    try {
                        key = this.marshaller.objectFromByteBuffer(metadata.getKeyBytes());
                    }
                    catch (Exception e) {
                        throw new JpaStoreException("Cannot unmarshall key", e);
                    }
                    Object entity = null;
                    try {
                        entity = emExec.getReference(this.configuration.entityClass(), key);
                        this.removeEntity(emExec, entity);
                    }
                    catch (EntityNotFoundException e) {
                        log.trace("Expired entity with key " + key + " not found", e);
                    }
                    this.removeMetadata(emExec, metadata);
                    if (trace) {
                        log.trace("Expired " + key + " -> " + entity + "(" + this.toString(metadata) + ")");
                    }
                    if (listener == null) continue;
                    eacs.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.entryPurged(key);
                        }
                    }, null);
                }
                txn.commit();
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
        }
    }

    private String toString(MetadataEntity metadata) {
        if (metadata == null || !metadata.hasBytes()) {
            return "<no metadata>";
        }
        try {
            return this.marshaller.objectFromByteBuffer(metadata.getMetadata()).toString();
        }
        catch (Exception e) {
            log.trace("Failed to unmarshall metadata", e);
            return "<metadata: " + e + ">";
        }
    }

    private class LoadingProcessTask
    implements Callable<Void> {
        private final AdvancedCacheLoader.CacheLoaderTask task;
        private final AdvancedCacheLoader.TaskContext taskContext;
        private final Object key;
        private final boolean fetchValue;
        private final boolean fetchMetadata;

        private LoadingProcessTask(AdvancedCacheLoader.CacheLoaderTask task, AdvancedCacheLoader.TaskContext taskContext, Object key, boolean fetchValue, boolean fetchMetadata) {
            this.task = task;
            this.taskContext = taskContext;
            this.key = key;
            this.fetchValue = fetchValue;
            this.fetchMetadata = fetchMetadata;
            if (trace) {
                log.tracef("Created process task with key=%s, fetchMetadata=%s", key, (Object)fetchMetadata);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Object entity;
            InternalMetadata metadata;
            boolean loaded = false;
            try (EntityManager emExec = JpaStore.this.emf.createEntityManager();){
                EntityTransaction txExec = emExec.getTransaction();
                txExec.begin();
                try {
                    do {
                        try {
                            InternalMetadata internalMetadata = metadata = this.fetchMetadata ? JpaStore.this.getMetadata(emExec, this.key) : null;
                            if (trace) {
                                log.tracef("Fetched metadata (fetching? %s) %s", (Object)this.fetchMetadata, (Object)metadata);
                            }
                            if (metadata != null && metadata.isExpired(JpaStore.this.timeService.wallClockTime())) {
                                Void void_ = null;
                                return void_;
                            }
                            if (this.fetchValue) {
                                entity = JpaStore.this.findEntity(emExec, this.key);
                                if (!trace) continue;
                                log.tracef("Fetched value %s", entity);
                                continue;
                            }
                            entity = null;
                        }
                        finally {
                            try {
                                txExec.commit();
                                loaded = true;
                            }
                            catch (Exception e) {
                                log.trace("Failed to load once", e);
                            }
                        }
                    } while (!loaded);
                }
                finally {
                    if (txExec != null && txExec.isActive()) {
                        txExec.rollback();
                    }
                }
            }
            try {
                MarshalledEntry marshalledEntry = JpaStore.this.marshallerEntryFactory.newMarshalledEntry(this.key, entity, metadata);
                if (marshalledEntry != null) {
                    this.task.processEntry(marshalledEntry, this.taskContext);
                }
                return null;
            }
            catch (Exception e) {
                log.errorExecutingParallelStoreTask(e);
                throw e;
            }
        }
    }

    private class ProcessTask
    implements Callable<Void> {
        private final AdvancedCacheLoader.CacheLoaderTask task;
        private final AdvancedCacheLoader.TaskContext taskContext;
        private final Object key;
        private final Object entity;
        private final InternalMetadata metadata;

        private ProcessTask(AdvancedCacheLoader.CacheLoaderTask task, AdvancedCacheLoader.TaskContext taskContext, Object key, Object entity, InternalMetadata metadata) {
            this.task = task;
            this.taskContext = taskContext;
            this.key = key;
            this.entity = entity;
            this.metadata = metadata;
            if (trace) {
                log.tracef("Created process task with key=%s, value=%s, metadata=%s", key, entity, (Object)metadata);
            }
        }

        @Override
        public Void call() throws Exception {
            try {
                MarshalledEntry marshalledEntry = JpaStore.this.marshallerEntryFactory.newMarshalledEntry(this.key, this.entity, this.metadata);
                if (marshalledEntry != null) {
                    this.task.processEntry(marshalledEntry, this.taskContext);
                }
                return null;
            }
            catch (Exception e) {
                log.errorExecutingParallelStoreTask(e);
                throw e;
            }
        }
    }

    private static interface ProcessStrategy {
        public Criteria getCriteria(Session var1);

        public Object getKey(Object var1);

        public Callable<Void> getTask(AdvancedCacheLoader.CacheLoaderTask var1, AdvancedCacheLoader.TaskContext var2, Object var3, Object var4);
    }
}

