/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;

public class TxReadOnlyKeyCommand<K, V, R>
extends ReadOnlyKeyCommand<K, V, R> {
    public static final byte COMMAND_ID = 64;
    private List<Mutation<K, V, ?>> mutations;

    public TxReadOnlyKeyCommand() {
    }

    public TxReadOnlyKeyCommand(Object key, List<Mutation<K, V, ?>> mutations) {
        super(key, null);
        this.mutations = mutations;
    }

    public TxReadOnlyKeyCommand(ReadOnlyKeyCommand other, List<Mutation<K, V, ?>> mutations) {
        super(other.getKey(), other.f);
        this.mutations = mutations;
    }

    @Override
    public byte getCommandId() {
        return 64;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallCollection(this.mutations, output, Mutations::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.mutations = MarshallUtil.unmarshallCollection(input, ArrayList::new, Mutations::readFrom);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.mutations == null || this.mutations.isEmpty()) {
            return super.perform(ctx);
        }
        MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(this.key);
        EntryView.ReadWriteEntryView rw = EntryViews.readWrite(entry);
        Object ret = null;
        for (Mutation mutation : this.mutations) {
            ret = mutation.apply(rw);
            entry.updatePreviousValue();
        }
        if (this.f != null) {
            ret = this.f.apply(rw);
        }
        return EntryViews.snapshot(ret);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TxReadOnlyKeyCommand{");
        sb.append("key=").append(this.key);
        sb.append(", f=").append(this.f);
        sb.append(", mutations=").append(this.mutations);
        sb.append('}');
        return sb.toString();
    }
}

