/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Objects;
import org.infinispan.commands.DataCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;

public abstract class AbstractDataCommand
implements DataCommand {
    protected Object key;
    private long flags;
    private int topologyId = -1;

    protected AbstractDataCommand(Object key, long flagsBitSet) {
        this.key = key;
        this.flags = flagsBitSet;
    }

    protected AbstractDataCommand() {
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataCommand other = (AbstractDataCommand)obj;
        return this.flags == other.flags && Objects.equals(this.key, other.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {key=" + Util.toStr(this.key) + ", flags=" + this.printFlags() + "}";
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    protected final String printFlags() {
        return EnumUtil.prettyPrintBitSet(this.flags, Flag.class);
    }
}

