/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.rocksdb.configuration.Attribute;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;

public class RocksDBStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RocksDBStoreConfiguration> {
    @Override
    public void serialize(XMLExtendedStreamWriter writer, RocksDBStoreConfiguration configuration) throws XMLStreamException {
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement(Element.ROCKSDB_STORE);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        if (attributes.attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).isModified()) {
            writer.writeStartElement(Element.COMPRESSION);
            attributes.write((XMLStreamWriter)writer, RocksDBStoreConfiguration.COMPRESSION_TYPE, Attribute.TYPE);
            writer.writeEndElement();
        }
        if (attributes.attribute(RocksDBStoreConfiguration.EXPIRED_LOCATION).isModified() || attributes.attribute(RocksDBStoreConfiguration.EXPIRY_QUEUE_SIZE).isModified()) {
            writer.writeStartElement(Element.EXPIRATION);
            attributes.write((XMLStreamWriter)writer, RocksDBStoreConfiguration.EXPIRED_LOCATION, Attribute.PATH);
            attributes.write((XMLStreamWriter)writer, RocksDBStoreConfiguration.EXPIRY_QUEUE_SIZE, Attribute.QUEUE_SIZE);
            writer.writeEndElement();
        }
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }
}

