/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultResponseGenerator
implements ResponseGenerator {
    private static final Log log = LogFactory.getLog(DefaultResponseGenerator.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        if (returnValue instanceof Response) {
            return (Response)returnValue;
        }
        if (command.isReturnValueExpected()) {
            return SuccessfulResponse.create(returnValue);
        }
        if (returnValue != null && trace) {
            log.tracef("Ignoring non-null response for command %s: %s", (Object)command, returnValue);
        }
        return null;
    }
}

