/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.object;

import java.util.stream.Stream;
import org.infinispan.stream.impl.intops.IntermediateOperation;

public class LimitOperation<S>
implements IntermediateOperation<S, Stream<S>, S, Stream<S>> {
    private final long limit;

    public LimitOperation(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Limit must be greater than 0");
        }
        this.limit = limit;
    }

    @Override
    public Stream<S> perform(Stream<S> stream) {
        return stream.limit(this.limit);
    }

    public long getLimit() {
        return this.limit;
    }
}

