/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v62.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.v62.impl.InvalidationInvocation;
import org.infinispan.hibernate.cache.v62.impl.LocalInvalidationInvocation;
import org.infinispan.hibernate.cache.v62.impl.Sync;

class NonTxInvalidationCacheAccessDelegate
extends org.infinispan.hibernate.cache.commons.access.NonTxInvalidationCacheAccessDelegate {
    public NonTxInvalidationCacheAccessDelegate(InfinispanDataRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    protected void registerLocalInvalidation(Object session, Object lockOwner, Object key) {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        if (log.isTraceEnabled()) {
            log.tracef("Registering synchronization on transaction in %s, cache %s: %s", lockOwner, (Object)this.cache.getName(), key);
        }
        sync.registerAfterCommit(new LocalInvalidationInvocation(this.putValidator, key, lockOwner));
    }

    protected void registerClusteredInvalidation(Object session, Object lockOwner, Object key) {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        if (log.isTraceEnabled()) {
            log.tracef("Registering synchronization on transaction in %s, cache %s: %s", lockOwner, (Object)this.cache.getName(), key);
        }
        sync.registerAfterCommit(new InvalidationInvocation(this.nonTxPutFromLoadInterceptor, key, lockOwner));
    }

    protected void invoke(Object session, InvocationContext ctx, RemoveCommand command) {
        CompletableFuture future = this.invoker.invokeAsync(ctx, (VisitableCommand)command);
        if (!command.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK)) {
            Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
            sync.registerBeforeCommit(future);
        } else {
            log.trace((Object)"Removal was not applied immediately, waiting.");
            future.join();
        }
    }
}

