/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Set;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.SecurityActions;

public final class RIMBeanServerRegistrationUtility {
    private RIMBeanServerRegistrationUtility() {
    }

    public static <K, V> void registerCacheObject(AbstractJCache<K, V> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        if (mBeanServer != null) {
            ObjectName registeredObjectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
            try {
                if (objectNameType.equals((Object)ObjectNameType.CONFIGURATION)) {
                    if (!RIMBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                        SecurityActions.registerMBean(cache.getCacheMXBean(), registeredObjectName, mBeanServer);
                    }
                } else if (objectNameType.equals((Object)ObjectNameType.STATISTICS) && !RIMBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                    SecurityActions.registerMBean(cache.getCacheStatisticsMXBean(), registeredObjectName, mBeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static <K, V> boolean isRegistered(AbstractJCache<K, V> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        if (mBeanServer != null) {
            ObjectName objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
            Set<ObjectName> registeredObjectNames = SecurityActions.queryNames(objectName, null, mBeanServer);
            return !registeredObjectNames.isEmpty();
        }
        return false;
    }

    public static <K, V> void unregisterCacheObject(AbstractJCache<K, V> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        if (mBeanServer != null) {
            ObjectName objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
            Set<ObjectName> registeredObjectNames = SecurityActions.queryNames(objectName, null, mBeanServer);
            for (ObjectName registeredObjectName : registeredObjectNames) {
                try {
                    SecurityActions.unregisterMBean(registeredObjectName, mBeanServer);
                }
                catch (Exception e) {
                    throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static <K, V> ObjectName calculateObjectName(AbstractJCache<K, V> cache, ObjectNameType objectNameType) {
        String cacheManagerName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getCacheManager().getURI().toString());
        String cacheName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getName());
        try {
            return new ObjectName("javax.cache:type=Cache" + objectNameType.objectName + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(",|:|=|\n", ".");
    }

    public static enum ObjectNameType {
        STATISTICS("Statistics"),
        CONFIGURATION("Configuration");

        private final String objectName;

        private ObjectNameType(String objectName) {
            this.objectName = objectName;
        }
    }
}

