/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class IndexNode {
    private static final Log log = LogFactory.getLog(IndexNode.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte HAS_LEAVES = 1;
    private static final int INNER_NODE_HEADER_SIZE = 5;
    private static final int INNER_NODE_REFERENCE_SIZE = 10;
    private static final int LEAF_NODE_REFERENCE_SIZE = 8;
    public static final int RESERVED_SPACE = 5 + 2 * Math.max(10, 8);
    private Index.Segment segment;
    private byte[] prefix;
    private byte[][] keyParts;
    InnerNode[] innerNodes;
    private LeafNode[] leafNodes;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private long offset = -1L;
    private int contentLength = -1;
    private int totalLength = -1;
    private int occupiedSpace;

    public IndexNode(Index.Segment segment, long offset, int occupiedSpace) throws IOException {
        int i;
        this.segment = segment;
        this.offset = offset;
        this.occupiedSpace = occupiedSpace;
        ByteBuffer buffer = IndexNode.loadBuffer(segment.getIndexFile(), offset, occupiedSpace);
        this.prefix = new byte[buffer.getShort()];
        buffer.get(this.prefix);
        byte flags = buffer.get();
        int numKeyParts = buffer.getShort();
        this.keyParts = new byte[numKeyParts][];
        for (i = 0; i < numKeyParts; ++i) {
            this.keyParts[i] = new byte[buffer.getShort()];
            buffer.get(this.keyParts[i]);
        }
        if ((flags & 1) != 0) {
            this.leafNodes = new LeafNode[numKeyParts + 1];
            for (i = 0; i < numKeyParts + 1; ++i) {
                this.leafNodes[i] = new LeafNode(buffer.getInt(), buffer.getInt());
            }
        } else {
            this.innerNodes = new InnerNode[numKeyParts + 1];
            for (i = 0; i < numKeyParts + 1; ++i) {
                this.innerNodes[i] = new InnerNode(buffer.getLong(), buffer.getShort());
            }
        }
        if (trace) {
            log.tracef("Loaded %08x from %d:%d (length %d)", new Object[]{System.identityHashCode(this), offset, occupiedSpace, this.length()});
        }
    }

    private static ByteBuffer loadBuffer(FileChannel indexFile, long offset, int occupiedSpace) throws IOException {
        int nowRead;
        ByteBuffer buffer = ByteBuffer.allocate(occupiedSpace);
        int read = 0;
        do {
            if ((nowRead = indexFile.read(buffer, offset + (long)read)) >= 0) continue;
            throw new IOException("Cannot read record [" + offset + ":" + occupiedSpace + "] (already read " + read + "), file size is " + indexFile.size());
        } while ((read += nowRead) < occupiedSpace);
        buffer.rewind();
        return buffer;
    }

    IndexNode(Index.Segment segment, byte[] newPrefix, byte[][] newKeyParts, LeafNode[] newLeafNodes) {
        this.segment = segment;
        this.prefix = newPrefix;
        this.keyParts = newKeyParts;
        this.leafNodes = newLeafNodes;
    }

    IndexNode(Index.Segment segment, byte[] newPrefix, byte[][] newKeyParts, InnerNode[] newInnerNodes) {
        this.segment = segment;
        this.prefix = newPrefix;
        this.keyParts = newKeyParts;
        this.innerNodes = newInnerNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexNode indexNode = (IndexNode)o;
        if (!Arrays.equals(this.innerNodes, indexNode.innerNodes)) {
            return false;
        }
        if (!Arrays.equals(this.leafNodes, indexNode.leafNodes)) {
            return false;
        }
        if (!Arrays.equals(this.prefix, indexNode.prefix)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.keyParts, (Object[])indexNode.keyParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContent(IndexNode other) throws IOException {
        try {
            this.lock.writeLock().lock();
            this.prefix = other.prefix;
            this.keyParts = other.keyParts;
            this.innerNodes = other.innerNodes;
            this.leafNodes = other.leafNodes;
            this.contentLength = -1;
            this.totalLength = -1;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.offset >= 0L) {
            this.store(new Index.IndexSpace(this.offset, this.occupiedSpace));
        }
    }

    private void store(Index.IndexSpace indexSpace) throws IOException {
        int i;
        this.offset = indexSpace.offset;
        this.occupiedSpace = indexSpace.length;
        ByteBuffer buffer = ByteBuffer.allocate(this.length());
        buffer.putShort((short)this.prefix.length);
        buffer.put(this.prefix);
        buffer.put(this.innerNodes == null ? (byte)1 : 0);
        buffer.putShort((short)this.keyParts.length);
        for (i = 0; i < this.keyParts.length; ++i) {
            buffer.putShort((short)this.keyParts[i].length);
            buffer.put(this.keyParts[i]);
        }
        if (this.innerNodes != null) {
            for (i = 0; i < this.innerNodes.length; ++i) {
                buffer.putLong(this.innerNodes[i].offset);
                buffer.putShort((short)this.innerNodes[i].length);
            }
        } else {
            for (i = 0; i < this.leafNodes.length; ++i) {
                buffer.putInt(this.leafNodes[i].file);
                buffer.putInt(this.leafNodes[i].offset);
            }
        }
        buffer.flip();
        this.segment.getIndexFile().write(buffer, this.offset);
        if (trace) {
            log.tracef("Persisted %08x (length %d, %d %s) to %d:%d", new Object[]{System.identityHashCode(this), this.length(), this.innerNodes != null ? this.innerNodes.length : this.leafNodes.length, this.innerNodes != null ? "children" : "leaves", this.offset, this.occupiedSpace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T applyOnLeaf(Index.Segment segment, byte[] key, Lock rootLock, ReadOperation operation) throws IOException {
        int attempts = 0;
        ArrayList<IndexNode> path = new ArrayList<IndexNode>();
        while (true) {
            rootLock.lock();
            IndexNode node = segment.getRoot();
            Lock parentLock = rootLock;
            Lock currentLock = null;
            try {
                int insertionPoint;
                while (node.innerNodes != null) {
                    path.add(node);
                    currentLock = node.lock.readLock();
                    currentLock.lock();
                    if (parentLock != null) {
                        parentLock.unlock();
                    }
                    parentLock = currentLock;
                    insertionPoint = node.getInsertionPoint(key);
                    if ((node = node.innerNodes[insertionPoint].getIndexNode(segment)) != null) continue;
                    T t = null;
                    return t;
                }
                currentLock = node.lock.readLock();
                currentLock.lock();
                if (node.leafNodes.length == 0) {
                    T insertionPoint2 = null;
                    return insertionPoint2;
                }
                insertionPoint = node.getInsertionPoint(key);
                Object t = operation.apply(node.leafNodes[insertionPoint], key, segment.getFileProvider(), segment.getTimeService());
                return t;
            }
            catch (IndexNodeOutdatedException e) {
                try {
                    if (attempts > 10) {
                        throw new PersistenceException("Index looks corrupt", (Throwable)e);
                    }
                    Thread.sleep(1000L);
                    ++attempts;
                    path.clear();
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
            finally {
                if (parentLock != currentLock && parentLock != null) {
                    parentLock.unlock();
                }
                if (currentLock == null) continue;
                currentLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    public static void setPosition(IndexNode root, byte[] key, int file, int offset, int size, OverwriteHook overwriteHook) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JoinSplitResult manageLength(Index.Segment segment, Stack<Path> stack, IndexNode node, IndexNode copy, Stack<IndexNode> garbage) throws IOException {
        int to;
        int from;
        if (copy.length() < segment.getMinNodeSize() && !stack.isEmpty()) {
            int joinWith;
            Path parent = stack.peek();
            if (parent.node.innerNodes.length == 1) {
                if (copy.length() <= node.occupiedSpace) {
                    node.replaceContent(copy);
                    return null;
                }
                return new JoinSplitResult(parent.index, parent.index, Collections.singletonList(copy));
            }
            int sizeWithLeft = Integer.MAX_VALUE;
            int sizeWithRight = Integer.MAX_VALUE;
            if (parent.index > 0) {
                sizeWithLeft = copy.length() + parent.node.innerNodes[parent.index - 1].length - 5;
            }
            if (parent.index < parent.node.innerNodes.length - 1) {
                sizeWithRight = copy.length() + parent.node.innerNodes[parent.index + 1].length - 5;
            }
            if (sizeWithLeft == Integer.MAX_VALUE) {
                joinWith = parent.index + 1;
            } else if (sizeWithRight == Integer.MAX_VALUE) {
                joinWith = parent.index - 1;
            } else if (sizeWithLeft > segment.getMaxNodeSize() && sizeWithRight > segment.getMaxNodeSize()) {
                joinWith = sizeWithLeft >= sizeWithRight ? parent.index - 1 : parent.index + 1;
            } else {
                int n = joinWith = sizeWithLeft <= sizeWithRight ? parent.index - 1 : parent.index + 1;
            }
            if (joinWith < 0 || joinWith >= parent.node.innerNodes.length) {
                throw new IllegalStateException(String.format("parent %08x, %08x -> %08x: cannot join to %d, with left %d, with right %d, max %d", System.identityHashCode(parent.node), System.identityHashCode(node), System.identityHashCode(copy), joinWith, sizeWithLeft, sizeWithRight, segment.getMaxNodeSize()));
            }
            IndexNode joiner = parent.node.innerNodes[joinWith].getIndexNode(segment);
            byte[] middleKey = IndexNode.concat(parent.node.prefix, parent.node.keyParts[joinWith < parent.index ? parent.index - 1 : parent.index]);
            if (joinWith < parent.index) {
                copy = IndexNode.join(joiner, middleKey, copy);
                from = joinWith;
                to = parent.index;
            } else {
                copy = IndexNode.join(copy, middleKey, joiner);
                from = parent.index;
                to = joinWith;
            }
            garbage.push(joiner);
        } else {
            if (copy.length() <= node.occupiedSpace) {
                if (copy.innerNodes != null && copy.innerNodes.length == 1 && stack.isEmpty()) {
                    IndexNode child = copy.innerNodes[0].getIndexNode(copy.segment);
                    return new JoinSplitResult(0, 0, Collections.singletonList(child));
                }
                node.replaceContent(copy);
                return null;
            }
            if (stack.isEmpty()) {
                to = 0;
                from = 0;
            } else {
                from = to = stack.peek().index;
            }
        }
        if (copy.length() <= segment.getMaxNodeSize()) {
            return new JoinSplitResult(from, to, Collections.singletonList(copy));
        }
        return new JoinSplitResult(from, to, copy.split());
    }

    private static IndexNode join(IndexNode left, byte[] middleKey, IndexNode right) throws IOException {
        byte[] rightmostKey;
        byte[] newPrefix = IndexNode.commonPrefix(left.prefix, right.prefix);
        byte[][] newKeyParts = new byte[left.keyParts.length + right.keyParts.length + 1][];
        newPrefix = IndexNode.commonPrefix(newPrefix == null ? left.prefix : newPrefix, middleKey);
        IndexNode.copyKeyParts(left.keyParts, 0, newKeyParts, 0, left.keyParts.length, left.prefix, newPrefix);
        try {
            rightmostKey = left.rightmostKey();
        }
        catch (IndexNodeOutdatedException e) {
            throw new IllegalStateException(e);
        }
        int commonLength = Math.abs(IndexNode.compare(middleKey, rightmostKey));
        newKeyParts[left.keyParts.length] = IndexNode.substring(middleKey, newPrefix.length, commonLength);
        IndexNode.copyKeyParts(right.keyParts, 0, newKeyParts, left.keyParts.length + 1, right.keyParts.length, right.prefix, newPrefix);
        if (left.innerNodes != null && right.innerNodes != null) {
            InnerNode[] newInnerNodes = new InnerNode[left.innerNodes.length + right.innerNodes.length];
            System.arraycopy(left.innerNodes, 0, newInnerNodes, 0, left.innerNodes.length);
            System.arraycopy(right.innerNodes, 0, newInnerNodes, left.innerNodes.length, right.innerNodes.length);
            return new IndexNode(left.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
        }
        if (left.leafNodes != null && right.leafNodes != null) {
            LeafNode[] newLeafNodes = new LeafNode[left.leafNodes.length + right.leafNodes.length];
            System.arraycopy(left.leafNodes, 0, newLeafNodes, 0, left.leafNodes.length);
            System.arraycopy(right.leafNodes, 0, newLeafNodes, left.leafNodes.length, right.leafNodes.length);
            return new IndexNode(left.segment, newPrefix, (byte[][])newKeyParts, newLeafNodes);
        }
        throw new IllegalArgumentException("Cannot join " + left + " and " + right);
    }

    public IndexNode copyWith(int oldNodesFrom, int oldNodesTo, List<IndexNode> newNodes) throws IOException {
        InnerNode[] newInnerNodes = new InnerNode[this.innerNodes.length + newNodes.size() - 1 - oldNodesTo + oldNodesFrom];
        System.arraycopy(this.innerNodes, 0, newInnerNodes, 0, oldNodesFrom);
        System.arraycopy(this.innerNodes, oldNodesTo + 1, newInnerNodes, oldNodesFrom + newNodes.size(), this.innerNodes.length - oldNodesTo - 1);
        for (int i = 0; i < newNodes.size(); ++i) {
            IndexNode node = newNodes.get(i);
            Index.IndexSpace space = this.segment.allocateIndexSpace(node.length());
            node.store(space);
            newInnerNodes[i + oldNodesFrom] = new InnerNode(node);
        }
        byte[][] newKeys = new byte[newNodes.size() - 1][];
        byte[] newPrefix = this.prefix;
        for (int i = 0; i < newKeys.length; ++i) {
            try {
                newKeys[i] = newNodes.get(i + 1).leftmostKey();
                if (newKeys[i] == null) {
                    throw new IllegalStateException();
                }
            }
            catch (IndexNodeOutdatedException e) {
                throw new IllegalStateException("Index cannot be outdated for segment updater thread", e);
            }
            newPrefix = IndexNode.commonPrefix(newPrefix, newKeys[i]);
        }
        byte[][] newKeyParts = new byte[this.keyParts.length + newNodes.size() - 1 - oldNodesTo + oldNodesFrom][];
        IndexNode.copyKeyParts(this.keyParts, 0, newKeyParts, 0, oldNodesFrom, this.prefix, newPrefix);
        IndexNode.copyKeyParts(this.keyParts, oldNodesTo, newKeyParts, oldNodesFrom + newKeys.length, this.keyParts.length - oldNodesTo, this.prefix, newPrefix);
        for (int i = 0; i < newKeys.length; ++i) {
            newKeyParts[i + oldNodesFrom] = IndexNode.substring(newKeys[i], newPrefix.length, newKeys[i].length);
        }
        return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
    }

    private byte[] leftmostKey() throws IOException, IndexNodeOutdatedException {
        if (this.innerNodes != null) {
            for (int i = 0; i < this.innerNodes.length; ++i) {
                byte[] key = this.innerNodes[i].getIndexNode(this.segment).leftmostKey();
                if (key == null) continue;
                return key;
            }
        } else {
            for (int i = 0; i < this.leafNodes.length; ++i) {
                EntryRecord hak = this.leafNodes[i].loadHeaderAndKey(this.segment.getFileProvider(), this.segment.getTimeService());
                if (hak == null || hak.getKey() == null) continue;
                return hak.getKey();
            }
        }
        return null;
    }

    private byte[] rightmostKey() throws IOException, IndexNodeOutdatedException {
        if (this.innerNodes != null) {
            for (int i = this.innerNodes.length - 1; i >= 0; --i) {
                byte[] key = this.innerNodes[i].getIndexNode(this.segment).rightmostKey();
                if (key == null) continue;
                return key;
            }
        } else {
            for (int i = this.leafNodes.length - 1; i >= 0; --i) {
                EntryRecord hak = this.leafNodes[i].loadHeaderAndKey(this.segment.getFileProvider(), this.segment.getTimeService());
                if (hak == null || hak.getKey() == null) continue;
                return hak.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexNode copyWith(byte[] key, int file, int offset, int size, OverwriteHook overwriteHook) throws IOException {
        void var7_16;
        LeafNode[] newLeafNodes;
        byte[] newPrefix;
        if (this.leafNodes == null) {
            throw new IllegalArgumentException();
        }
        if (this.leafNodes.length == 0) {
            overwriteHook.setOverwritten(false, -1, -1);
            if (overwriteHook.check(-1, -1)) {
                return new IndexNode(this.segment, this.prefix, this.keyParts, new LeafNode[]{new LeafNode(file, offset)});
            }
            this.segment.getCompactor().free(file, size);
            return this;
        }
        int insertPart = this.getInsertionPoint(key);
        EntryRecord hak = null;
        try {
            hak = this.leafNodes[insertPart].loadHeaderAndKey(this.segment.getFileProvider(), this.segment.getTimeService());
        }
        catch (IndexNodeOutdatedException e) {
            throw new IllegalStateException("Index cannot be outdated for segment updater thread", e);
        }
        int keyComp = Integer.MAX_VALUE;
        if (hak == null || hak.getKey() == null || (keyComp = IndexNode.compare(hak.getKey(), key)) == 0) {
            if (offset >= 0) {
                if (!overwriteHook.check(this.leafNodes[insertPart].file, this.leafNodes[insertPart].offset)) {
                    overwriteHook.setOverwritten(false, -1, -1);
                    this.segment.getCompactor().free(file, size);
                    return this;
                }
                newPrefix = this.prefix;
                byte[][] byArray = this.keyParts;
                newLeafNodes = new LeafNode[this.leafNodes.length];
                System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, this.leafNodes.length);
                if (trace) {
                    log.trace((Object)String.format("Overwriting %d:%d (%s) with %d:%d", this.leafNodes[insertPart].file, this.leafNodes[insertPart].offset, hak == null ? "removed" : (hak.getKey() == null ? "expired" : "matching"), file, offset));
                }
                newLeafNodes[insertPart] = new LeafNode(file, offset);
                if (hak != null) {
                    this.segment.getCompactor().free(this.leafNodes[insertPart].file, hak.getHeader().totalLength());
                }
                overwriteHook.setOverwritten(true, this.leafNodes[insertPart].file, this.leafNodes[insertPart].offset);
                return new IndexNode(this.segment, newPrefix, (byte[][])var7_16, newLeafNodes);
            }
            overwriteHook.setOverwritten(keyComp == 0, this.leafNodes[insertPart].file, this.leafNodes[insertPart].offset);
            if (this.keyParts.length <= 1) {
                newPrefix = new byte[]{};
                byte[][] byArrayArray = new byte[][]{};
            } else {
                newPrefix = this.prefix;
                byte[][] byArrayArray = new byte[this.keyParts.length - 1][];
                if (insertPart == this.keyParts.length) {
                    System.arraycopy(this.keyParts, 0, byArrayArray, 0, byArrayArray.length);
                } else {
                    System.arraycopy(this.keyParts, 0, byArrayArray, 0, insertPart);
                    System.arraycopy(this.keyParts, insertPart + 1, byArrayArray, insertPart, byArrayArray.length - insertPart);
                }
            }
            if (this.leafNodes.length > 0) {
                newLeafNodes = new LeafNode[this.leafNodes.length - 1];
                System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart);
                System.arraycopy(this.leafNodes, insertPart + 1, newLeafNodes, insertPart, newLeafNodes.length - insertPart);
            } else {
                newLeafNodes = this.leafNodes;
            }
            if (hak == null) return new IndexNode(this.segment, newPrefix, (byte[][])var7_16, newLeafNodes);
            this.segment.getCompactor().free(this.leafNodes[insertPart].file, hak.getHeader().totalLength());
            return new IndexNode(this.segment, newPrefix, (byte[][])var7_16, newLeafNodes);
        }
        overwriteHook.setOverwritten(false, -1, -1);
        if (offset < 0) {
            return this;
        }
        newPrefix = this.keyParts.length == 0 ? (keyComp > 0 ? key : hak.getKey()) : IndexNode.commonPrefix(this.prefix, key);
        byte[][] byArrayArray = new byte[this.keyParts.length + 1][];
        newLeafNodes = new LeafNode[this.leafNodes.length + 1];
        IndexNode.copyKeyParts(this.keyParts, 0, byArrayArray, 0, insertPart, this.prefix, newPrefix);
        IndexNode.copyKeyParts(this.keyParts, insertPart, byArrayArray, insertPart + 1, this.keyParts.length - insertPart, this.prefix, newPrefix);
        if (keyComp > 0) {
            byArrayArray[insertPart] = IndexNode.substring(key, newPrefix.length, keyComp);
            System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart + 1);
            System.arraycopy(this.leafNodes, insertPart + 1, newLeafNodes, insertPart + 2, this.leafNodes.length - insertPart - 1);
            newLeafNodes[insertPart + 1] = new LeafNode(file, offset);
            return new IndexNode(this.segment, newPrefix, (byte[][])var7_16, newLeafNodes);
        }
        byArrayArray[insertPart] = IndexNode.substring(hak.getKey(), newPrefix.length, -keyComp);
        System.arraycopy(this.leafNodes, 0, newLeafNodes, 0, insertPart);
        System.arraycopy(this.leafNodes, insertPart, newLeafNodes, insertPart + 1, this.leafNodes.length - insertPart);
        newLeafNodes[insertPart] = new LeafNode(file, offset);
        return new IndexNode(this.segment, newPrefix, (byte[][])var7_16, newLeafNodes);
    }

    private int getInsertionPoint(byte[] key) {
        byte[] keyPostfix;
        int insertionPoint;
        int comp = IndexNode.compare(this.prefix, key, this.prefix.length);
        insertionPoint = comp < 0 ? 0 : (comp > 0 ? this.keyParts.length : ((insertionPoint = Arrays.binarySearch(this.keyParts, keyPostfix = IndexNode.substring(key, this.prefix.length, key.length), new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return IndexNode.compare(o2, o1);
            }
        })) < 0 ? -insertionPoint - 1 : ++insertionPoint));
        return insertionPoint;
    }

    private List<IndexNode> split() {
        int headerLength = this.headerLength();
        int contentLength = this.contentLength();
        int maxLength = this.segment.getMaxNodeSize();
        int targetParts = contentLength / Math.max(maxLength - headerLength, 1) + 1;
        int targetLength = contentLength / targetParts + headerLength;
        ArrayList<IndexNode> list = new ArrayList<IndexNode>();
        int childLength = this.innerNodes != null ? 10 : 8;
        byte[] prefixExtension = this.keyParts[0];
        int currentLength = 5 + this.prefix.length + prefixExtension.length + 2 * childLength + 2;
        int nodeFrom = 0;
        for (int i = 1; i < this.keyParts.length; ++i) {
            byte[] newPrefixExtension = IndexNode.commonPrefix(prefixExtension, this.keyParts[i]);
            int newLength = newPrefixExtension.length != prefixExtension.length ? currentLength + (prefixExtension.length - newPrefixExtension.length) * (i - nodeFrom - 1) : currentLength;
            if ((newLength += this.keyParts[i].length - newPrefixExtension.length + childLength + 2) < targetLength) {
                currentLength = newLength;
            } else {
                IndexNode subNode;
                if (newLength > maxLength) {
                    subNode = this.subNode(prefixExtension, nodeFrom, i);
                    ++i;
                } else {
                    subNode = this.subNode(newPrefixExtension, nodeFrom, i + 1);
                    i += 2;
                }
                list.add(subNode);
                if (i < this.keyParts.length) {
                    newPrefixExtension = this.keyParts[i];
                }
                currentLength = 5 + this.prefix.length + newPrefixExtension.length + 2 * childLength + 2;
                nodeFrom = i;
            }
            prefixExtension = newPrefixExtension;
        }
        if (nodeFrom <= this.keyParts.length) {
            list.add(this.subNode(prefixExtension, nodeFrom, this.keyParts.length));
        }
        return list;
    }

    private IndexNode subNode(byte[] newPrefixExtension, int childFrom, int childTo) {
        byte[] newPrefix;
        byte[][] newKeyParts = new byte[childTo - childFrom][];
        if (newPrefixExtension.length > 0) {
            for (int i = childFrom; i < childTo; ++i) {
                newKeyParts[i - childFrom] = IndexNode.substring(this.keyParts[i], newPrefixExtension.length, this.keyParts[i].length);
            }
        } else {
            System.arraycopy(this.keyParts, childFrom, newKeyParts, 0, childTo - childFrom);
        }
        byte[] byArray = newPrefix = childFrom == childTo ? new byte[]{} : IndexNode.concat(this.prefix, newPrefixExtension);
        if (this.innerNodes != null) {
            InnerNode[] newInnerNodes = new InnerNode[childTo - childFrom + 1];
            System.arraycopy(this.innerNodes, childFrom, newInnerNodes, 0, childTo - childFrom + 1);
            return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newInnerNodes);
        }
        if (this.leafNodes != null) {
            LeafNode[] newLeafNodes = new LeafNode[childTo - childFrom + 1];
            System.arraycopy(this.leafNodes, childFrom, newLeafNodes, 0, childTo - childFrom + 1);
            return new IndexNode(this.segment, newPrefix, (byte[][])newKeyParts, newLeafNodes);
        }
        throw new IllegalStateException();
    }

    private static byte[] concat(byte[] first, byte[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static void copyKeyParts(byte[][] src, int srcIndex, byte[][] dest, int destIndex, int length, byte[] oldPrefix, byte[] common) {
        if (oldPrefix.length == common.length) {
            System.arraycopy(src, srcIndex, dest, destIndex, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dest[destIndex + i] = IndexNode.findNewKeyPart(oldPrefix, src[srcIndex + i], common);
            }
        }
    }

    private static byte[] findNewKeyPart(byte[] oldPrefix, byte[] oldKeyPart, byte[] common) {
        byte[] newPart = new byte[oldKeyPart.length + oldPrefix.length - common.length];
        System.arraycopy(oldPrefix, common.length, newPart, 0, oldPrefix.length - common.length);
        System.arraycopy(oldKeyPart, 0, newPart, oldPrefix.length - common.length, oldKeyPart.length);
        return newPart;
    }

    private static byte[] substring(byte[] key, int begin, int end) {
        if (end <= begin) {
            return new byte[0];
        }
        byte[] sub = new byte[end - begin];
        System.arraycopy(key, begin, sub, 0, end - begin);
        return sub;
    }

    private static byte[] commonPrefix(byte[] oldPrefix, byte[] newKey) {
        int i;
        for (i = 0; i < oldPrefix.length && i < newKey.length && newKey[i] == oldPrefix[i]; ++i) {
        }
        if (i == oldPrefix.length) {
            return oldPrefix;
        }
        if (i == newKey.length) {
            return newKey;
        }
        byte[] prefix = new byte[i];
        --i;
        while (i >= 0) {
            prefix[i] = oldPrefix[i];
            --i;
        }
        return prefix;
    }

    private static int compare(byte[] first, byte[] second, int length) {
        for (int i = 0; i < length; ++i) {
            if (i >= second.length) {
                return -1;
            }
            if (second[i] == first[i]) continue;
            return second[i] > first[i] ? 1 : -1;
        }
        return 0;
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length && i < second.length; ++i) {
            if (second[i] == first[i]) continue;
            return second[i] > first[i] ? i + 1 : -i - 1;
        }
        return second.length > first.length ? first.length + 1 : (second.length < first.length ? -second.length - 1 : 0);
    }

    private int headerLength() {
        return 5 + this.prefix.length;
    }

    private int contentLength() {
        if (this.contentLength >= 0) {
            return this.contentLength;
        }
        int sum = 0;
        for (byte[] keyPart : this.keyParts) {
            sum += 2 + keyPart.length;
        }
        if (this.innerNodes != null) {
            sum += 10 * this.innerNodes.length;
        } else if (this.leafNodes != null) {
            sum += 8 * this.leafNodes.length;
        } else {
            throw new IllegalStateException();
        }
        this.contentLength = sum;
        return this.contentLength;
    }

    public int length() {
        if (this.totalLength >= 0) {
            return this.totalLength;
        }
        this.totalLength = this.headerLength() + this.contentLength();
        return this.totalLength;
    }

    public static IndexNode emptyWithLeaves(Index.Segment segment) {
        return new IndexNode(segment, new byte[0], (byte[][])new byte[0][], new LeafNode[]{new LeafNode(-1, -1)});
    }

    public static IndexNode emptyWithInnerNodes(Index.Segment segment) {
        return new IndexNode(segment, new byte[0], (byte[][])new byte[0][], new InnerNode[]{new InnerNode(-1L, -1)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.keyParts.length; ++i) {
            sb.append('\n');
            if (this.leafNodes != null) {
                sb.append(" [").append(this.leafNodes[i].file).append(':').append(this.leafNodes[i].offset).append("] ");
            } else {
                sb.append(" [").append(this.innerNodes[i].offset).append(':').append(this.innerNodes[i].length).append("] ");
            }
            if (i >= this.keyParts.length) continue;
            sb.append(new String(IndexNode.concat(this.prefix, this.keyParts[i])));
        }
        sb.append('\n');
        return sb.toString();
    }

    private static class IndexNodeOutdatedException
    extends Exception {
        IndexNodeOutdatedException(String message) {
            super(message);
        }
    }

    private static class LeafNode
    extends EntryPosition {
        private volatile SoftReference<EntryRecord> keyReference;

        public LeafNode(int file, int offset) {
            super(file, offset);
        }

        public EntryRecord loadHeaderAndKey(FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
            if (this.offset < 0) {
                return null;
            }
            EntryRecord headerAndKey = this.getHeaderAndKey(fileProvider, null, timeService);
            return headerAndKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryRecord getHeaderAndKey(FileProvider fileProvider, FileProvider.Handle handle, TimeService timeService) throws IOException, IndexNodeOutdatedException {
            EntryRecord headerAndKey;
            if (this.keyReference == null || (headerAndKey = this.keyReference.get()) == null) {
                LeafNode leafNode = this;
                synchronized (leafNode) {
                    if (this.keyReference == null || (headerAndKey = this.keyReference.get()) == null) {
                        boolean ownHandle = false;
                        if (handle == null) {
                            ownHandle = true;
                            handle = fileProvider.getFile(this.file);
                            if (handle == null) {
                                throw new IndexNodeOutdatedException(this.file + ":" + this.offset);
                            }
                        }
                        try {
                            EntryHeader header = EntryRecord.readEntryHeader(handle, this.offset);
                            if (header == null) {
                                throw new IllegalStateException("Error reading header from " + this.file + ":" + this.offset + " | " + handle.getFileSize());
                            }
                            headerAndKey = new EntryRecord(header, EntryRecord.readKey(handle, header, this.offset), null, null);
                            this.keyReference = new SoftReference<EntryRecord>(headerAndKey);
                        }
                        finally {
                            if (ownHandle) {
                                handle.close();
                            }
                        }
                    }
                }
            }
            if (headerAndKey.getHeader().expiryTime() > 0L && headerAndKey.getHeader().expiryTime() <= timeService.wallClockTime()) {
                EntryRecord expired = headerAndKey;
                headerAndKey = new EntryRecord(headerAndKey.getHeader(), null, null, null);
                LeafNode leafNode = this;
                synchronized (leafNode) {
                    if (this.keyReference.get() == expired) {
                        this.keyReference = new SoftReference<EntryRecord>(headerAndKey);
                    }
                }
            }
            return headerAndKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryRecord loadRecord(FileProvider fileProvider, byte[] key, TimeService timeService) throws IOException, IndexNodeOutdatedException {
            if (this.offset < 0) {
                return null;
            }
            FileProvider.Handle handle = fileProvider.getFile(this.file);
            if (handle == null) {
                throw new IndexNodeOutdatedException(this.file + ":" + this.offset);
            }
            try {
                EntryRecord headerAndKey = this.getHeaderAndKey(fileProvider, handle, timeService);
                if (!Arrays.equals(key, headerAndKey.getKey())) {
                    EntryRecord entryRecord = null;
                    return entryRecord;
                }
                EntryRecord entryRecord = headerAndKey.loadMetadataAndValue(handle, this.offset);
                return entryRecord;
            }
            finally {
                handle.close();
            }
        }
    }

    static class InnerNode
    extends Index.IndexSpace {
        private volatile SoftReference<IndexNode> reference;

        public InnerNode(long offset, short length) {
            super(offset, length);
        }

        public InnerNode(IndexNode node) {
            super(node.offset, node.occupiedSpace);
            this.reference = new SoftReference<IndexNode>(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexNode getIndexNode(Index.Segment segment) throws IOException {
            IndexNode node;
            if (this.reference == null || (node = this.reference.get()) == null) {
                InnerNode innerNode = this;
                synchronized (innerNode) {
                    if (this.reference == null || (node = this.reference.get()) == null) {
                        if (this.offset < 0L) {
                            return null;
                        }
                        node = new IndexNode(segment, this.offset, this.length);
                        this.reference = new SoftReference<IndexNode>(node);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Loaded inner node from " + this.offset + " - " + this.length));
                        }
                    }
                }
            }
            return node;
        }
    }

    public static class OverwriteHook {
        public boolean check(int oldFile, int oldOffset) {
            return true;
        }

        public void setOverwritten(boolean overwritten, int prevFile, int prevOffset) {
        }
    }

    private static class JoinSplitResult {
        public final int from;
        public final int to;
        public final List<IndexNode> newNodes;

        private JoinSplitResult(int from, int to, List<IndexNode> newNodes) {
            this.from = from;
            this.to = to;
            this.newNodes = newNodes;
        }
    }

    public static enum ReadOperation {
        GET_RECORD{

            protected EntryRecord apply(LeafNode leafNode, byte[] key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                return leafNode.loadRecord(fileProvider, key, timeService);
            }
        }
        ,
        GET_POSITION{

            protected EntryPosition apply(LeafNode leafNode, byte[] key, FileProvider fileProvider, TimeService timeService) throws IOException, IndexNodeOutdatedException {
                EntryRecord hak = leafNode.loadHeaderAndKey(fileProvider, timeService);
                if (hak != null && hak.getKey() != null && Arrays.equals(hak.getKey(), key)) {
                    return leafNode;
                }
                return null;
            }
        };


        protected abstract <T> T apply(LeafNode var1, byte[] var2, FileProvider var3, TimeService var4) throws IOException, IndexNodeOutdatedException;
    }

    private static class Path {
        public IndexNode node;
        public int index;

        private Path(IndexNode node, int index) {
            this.node = node;
            this.index = index;
        }
    }
}

