/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.infinispan.search.mapper.mapping.impl.DefaultAnalysisConfigurer;

public class IndexProperties {
    private final Map<String, Object> engineProperties = new HashMap<String, Object>();
    private final Map<String, Object> backendProperties = new HashMap<String, Object>();

    public void setProperty(String key, Object value) {
        if (key.startsWith("hibernate.search.")) {
            this.engineProperties.put(key, value);
        } else {
            this.backendProperties.put(key, value);
        }
    }

    public void setProperties(Map<String, Object> properties) {
        properties.forEach(this::setProperty);
    }

    public ConfigurationPropertySource createPropertySource(ConfigurationPropertyChecker propertyChecker) {
        ConfigurationPropertySource basePropertySource = propertyChecker.wrap(ConfigurationPropertySource.fromMap(this.backendProperties)).withPrefix("hibernate.search.backend");
        ConfigurationPropertySource propertySource = basePropertySource.withOverride((ConfigurationPropertySource)ConfigurationPropertySource.fromMap(this.engineProperties));
        this.defaultProperties();
        return propertySource;
    }

    private void defaultProperties() {
        this.backendProperties.put("type", "lucene");
        this.backendProperties.put("analysis.configurer", new DefaultAnalysisConfigurer());
    }
}

