/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;
import org.infinispan.search.mapper.common.EntityReference;
import org.infinispan.search.mapper.impl.InfinispanMappingInitiator;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.mapping.ProgrammaticSearchMappingProvider;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.impl.ClassLoaderServiceImpl;
import org.infinispan.search.mapper.mapping.impl.IndexProperties;
import org.infinispan.search.mapper.mapping.impl.InfinispanMapping;
import org.infinispan.search.mapper.mapping.impl.InfinispanMappingKey;
import org.infinispan.search.mapper.model.impl.InfinispanBootstrapIntrospector;

public final class SearchMappingBuilder {
    private final ConfigurationPropertyChecker propertyChecker;
    private final IndexProperties indexProperties = new IndexProperties();
    private final ConfigurationPropertySource propertySource;
    private final SearchIntegrationBuilder integrationBuilder;
    private final InfinispanMappingKey mappingKey;
    private final InfinispanMappingInitiator mappingInitiator;

    public static InfinispanBootstrapIntrospector introspector(MethodHandles.Lookup lookup) {
        ValueReadHandleFactory valueReadHandleFactory = ValueReadHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
        return new InfinispanBootstrapIntrospector(valueReadHandleFactory);
    }

    SearchMappingBuilder(PojoBootstrapIntrospector introspector, ClassLoader aggregatedClassLoader, Collection<ProgrammaticSearchMappingProvider> mappingProviders) {
        this.propertyChecker = ConfigurationPropertyChecker.create();
        this.propertySource = this.indexProperties.createPropertySource(this.propertyChecker);
        this.integrationBuilder = SearchIntegration.builder((ConfigurationPropertySource)this.propertySource, (ConfigurationPropertyChecker)this.propertyChecker);
        this.mappingKey = new InfinispanMappingKey();
        this.mappingInitiator = new InfinispanMappingInitiator(introspector, mappingProviders);
        this.integrationBuilder.addMappingInitiator((MappingKey)this.mappingKey, (MappingInitiator)this.mappingInitiator);
        this.mappingInitiator.annotatedTypeDiscoveryEnabled(true);
        if (aggregatedClassLoader != null) {
            ClassLoaderServiceImpl classLoaderService = new ClassLoaderServiceImpl(aggregatedClassLoader);
            this.integrationBuilder.classResolver((ClassResolver)classLoaderService);
            this.integrationBuilder.resourceResolver((ResourceResolver)classLoaderService);
            this.integrationBuilder.serviceResolver((ServiceResolver)classLoaderService);
        }
    }

    public ProgrammaticMappingConfigurationContext programmaticMapping() {
        return this.mappingInitiator.programmaticMapping();
    }

    public AnnotationMappingConfigurationContext annotationMapping() {
        return this.mappingInitiator.annotationMapping();
    }

    public SearchMappingBuilder addEntityType(Class<?> type) {
        return this.addEntityType(type, type.getName());
    }

    public SearchMappingBuilder addEntityType(Class<?> type, String entityName) {
        this.mappingInitiator.addEntityType(type, entityName);
        return this;
    }

    public SearchMappingBuilder addEntityTypes(Set<Class<?>> types) {
        for (Class<?> type : types) {
            this.addEntityType(type);
        }
        return this;
    }

    public SearchMappingBuilder setProvidedIdentifierBridge(BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge) {
        this.mappingInitiator.providedIdentifierBridge(providedIdentifierBridge);
        return this;
    }

    public SearchMappingBuilder setEntityLoader(EntityLoader<EntityReference, ?> entityLoader) {
        this.mappingInitiator.setEntityLoader(entityLoader);
        return this;
    }

    public SearchMappingBuilder setEntityConverter(EntityConverter entityConverter) {
        this.mappingInitiator.setEntityConverter(entityConverter);
        return this;
    }

    public SearchMappingBuilder setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.mappingInitiator.annotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
        return this;
    }

    public SearchMappingBuilder setProperty(String name, Object value) {
        this.indexProperties.setProperty(name, value);
        return this;
    }

    public SearchMappingBuilder setProperties(Map<String, Object> map) {
        this.indexProperties.setProperties(map);
        return this;
    }

    public SearchMapping build() {
        SearchIntegration integration;
        SearchMapping mapping;
        SearchIntegrationPartialBuildState integrationPartialBuildState = this.integrationBuilder.prepareBuild();
        try {
            SearchIntegrationFinalizer finalizer = integrationPartialBuildState.finalizer(this.propertySource, this.propertyChecker);
            mapping = (SearchMapping)finalizer.finalizeMapping((MappingKey)this.mappingKey, (context, partialMapping) -> partialMapping.finalizeMapping());
            integration = finalizer.finalizeIntegration();
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(SearchIntegrationPartialBuildState::closeOnFailure, (Object)integrationPartialBuildState);
            throw e;
        }
        try {
            InfinispanMapping mappingImpl = (InfinispanMapping)mapping;
            mappingImpl.setIntegration(integration);
            return mappingImpl;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)integration);
            throw e;
        }
    }
}

