/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;
import org.hibernate.search.SearchException;
import org.infinispan.util.ReflectionUtil;

class ISPNPriorityQueueFactory {
    private ISPNPriorityQueueFactory() {
    }

    public static PriorityQueue<FieldDoc> getFieldDocSortedHitQueue(int size, SortField[] sort) {
        Method[] methods;
        String className = "org.apache.lucene.search.FieldDocSortedHitQueue";
        Object[] constructorArgument = new Object[]{size};
        Class[] types = new Class[]{Integer.TYPE};
        PriorityQueue<FieldDoc> queue = ISPNPriorityQueueFactory.buildPriorityQueueSafe(className, types, constructorArgument);
        for (Method method : methods = queue.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("setFields")) continue;
            Object[] parameters = new Object[]{sort};
            ReflectionUtil.invokeAccessibly(queue, (Method)method, (Object[])parameters);
            return queue;
        }
        throw new SearchException("Method org.apache.lucene.search.FieldDocSortedHitQueue.setFields not found. This version of Lucene is not compatible.");
    }

    public static PriorityQueue<FieldDoc> getHitQueue(int size) {
        String className = "org.apache.lucene.search.HitQueue";
        Object[] constructorArgument = new Object[]{size, false};
        Class[] types = new Class[]{Integer.TYPE, Boolean.TYPE};
        return ISPNPriorityQueueFactory.buildPriorityQueueSafe(className, types, constructorArgument);
    }

    private static PriorityQueue<FieldDoc> buildPriorityQueueSafe(String className, Class[] types, Object[] constructorArgument) {
        try {
            return ISPNPriorityQueueFactory.buildPriorityQueue(className, types, constructorArgument);
        }
        catch (Exception e) {
            throw new SearchException("Could not initialize required Lucene class: " + className + ". Either the Lucene version is incompatible, or security is preventing me to access it.", (Throwable)e);
        }
    }

    private static PriorityQueue<FieldDoc> buildPriorityQueue(String className, Class[] types, Object[] constructorArgument) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className);
        Constructor<?> c = clazz.getDeclaredConstructor(types);
        c.setAccessible(true);
        Object newInstance = c.newInstance(constructorArgument);
        return (PriorityQueue)newInstance;
    }
}

