/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.QueryResultLoader;

public class EntityLoader
implements QueryResultLoader {
    private final AdvancedCache<?, ?> cache;
    private final KeyTransformationHandler keyTransformationHandler;

    public EntityLoader(AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.cache = cache;
    }

    @Override
    public Object load(EntityInfo entityInfo) {
        Object cacheKey = this.keyTransformationHandler.stringToKey(entityInfo.getId().toString(), this.cache.getClassLoader());
        return this.cache.get(cacheKey);
    }

    @Override
    public List<Object> load(Collection<EntityInfo> entityInfos) {
        ArrayList<Object> list = new ArrayList<Object>(entityInfos.size());
        for (EntityInfo e : entityInfos) {
            Object entity = this.load(e);
            if (entity == null) continue;
            list.add(entity);
        }
        return list;
    }
}

