/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultMassIndexerProgressMonitor
implements MassIndexerProgressMonitor {
    private static final Log log = LoggerFactory.make();
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;

    public DefaultMassIndexerProgressMonitor() {
        this(50);
    }

    public DefaultMassIndexerProgressMonitor(int logAfterNumberOfDocuments) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
    }

    public void entitiesLoaded(int size) {
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = System.nanoTime();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, current);
        }
    }

    public void documentsBuilt(int number) {
    }

    public void addToTotalCount(long count) {
    }

    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.documentsDoneCounter.get());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long doneCount) {
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        log.indexingDocumentsCompleted(doneCount, elapsedMs);
    }
}

