/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.infinispan.query.indexmanager.InfinispanCommandsBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MasterSwitchDelegatingQueueProcessor
implements BackendQueueProcessor {
    private static final Log log = (Log)LogFactory.getLog(MasterSwitchDelegatingQueueProcessor.class, Log.class);
    private final BackendQueueProcessor localMaster;
    private final InfinispanCommandsBackend remoteMaster;

    public MasterSwitchDelegatingQueueProcessor(BackendQueueProcessor localMaster, InfinispanCommandsBackend remoteMaster) {
        this.localMaster = localMaster;
        this.remoteMaster = remoteMaster;
    }

    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.localMaster.initialize(props, context, indexManager);
        this.remoteMaster.initialize(props, context, indexManager);
    }

    public void close() {
        this.remoteMaster.close();
        this.localMaster.close();
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (this.remoteMaster.isMasterLocal()) {
            log.applyingChangeListLocally(workList);
            this.localMaster.applyWork(workList, monitor);
        } else {
            log.applyingChangeListRemotely(workList);
            this.remoteMaster.applyWork(workList, monitor);
        }
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (this.remoteMaster.isMasterLocal()) {
            this.localMaster.applyStreamWork(singleOperation, monitor);
        } else {
            this.remoteMaster.applyStreamWork(singleOperation, monitor);
        }
    }

    public Lock getExclusiveWriteLock() {
        return this.localMaster.getExclusiveWriteLock();
    }

    public void indexMappingChanged() {
        this.remoteMaster.indexMappingChanged();
        this.localMaster.indexMappingChanged();
    }
}

