package org.infinispan.query.impl.massindex;

import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycle;

/**
 * Initializes the custom Map Reduce tasks we use to rebuild indexes
 *  
 * @author Sanne Grinovero <sanne@hibernate.org> (C) 2012 Red Hat Inc.
 */
public class MapReduceInitializer implements MapReduceTaskLifecycle {

   @Override
   public <KIn, VIn, KOut, VOut> void onPreExecute(Mapper<KIn, VIn, KOut, VOut> mapper, Cache<KIn, VIn> inputCache) {
      if (mapper instanceof IndexingMapper) {
         IndexingMapper im = (IndexingMapper) mapper;
         im.initialize(inputCache);
      }
   }

   @Override
   public <KIn, VIn, KOut, VOut> void onPostExecute(Mapper<KIn, VIn, KOut, VOut> mapper) {
      if (mapper instanceof IndexingMapper) {
         IndexingMapper im = (IndexingMapper) mapper;
         im.flush();
      }
   }

   @Override
   public <KOut, VOut> void onPreExecute(Reducer<KOut, VOut> reducer, Cache<?, ?> inputCache) {
      //nothing to do
   }

   @Override
   public <KOut, VOut> void onPostExecute(Reducer<KOut, VOut> reducer) {
      //nothing to do
   }

}
