/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.lucene.search.TopDocs;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.query.clustered.ISPNEagerTopDocs;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;

public class ClusteredTopDocsExternalizer
extends AbstractExternalizer<ISPNEagerTopDocs> {
    public Set<Class<? extends ISPNEagerTopDocs>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{ISPNEagerTopDocs.class});
    }

    public ISPNEagerTopDocs readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int keysNumber = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] keys = new Object[keysNumber];
        for (int i = 0; i < keysNumber; ++i) {
            keys[i] = input.readObject();
        }
        TopDocs innerTopDocs = LuceneTopDocsExternalizer.readObjectStatic(input);
        return new ISPNEagerTopDocs(innerTopDocs, keys);
    }

    public void writeObject(ObjectOutput output, ISPNEagerTopDocs topDocs) throws IOException {
        Object[] keys = topDocs.keys;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)keys.length);
        for (Object o : keys) {
            output.writeObject(o);
        }
        LuceneTopDocsExternalizer.writeObjectStatic(output, topDocs);
    }

    public Integer getId() {
        return ExternalizerIds.CLUSTERED_QUERY_TOPDOCS;
    }
}

