/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.query.indexmanager.LuceneWorkIdTransformer;
import org.infinispan.query.indexmanager.LuceneWorkTransformationVisitor;

public class IndexUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    public static final byte COMMAND_ID = 102;
    private SearchFactoryImplementor searchFactory;
    private byte[] serializedModel;
    private String indexName;
    private QueryInterceptor queryInterceptor;

    public IndexUpdateCommand(String cacheName) {
        super(cacheName);
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        IndexManager indexManager = this.searchFactory.getIndexManagerHolder().getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        List<LuceneWork> workToApply = this.transformKeysToStrings(luceneWorks);
        indexManager.performOperations(workToApply, null);
        return Boolean.TRUE;
    }

    private List<LuceneWork> transformKeysToStrings(List<LuceneWork> luceneWorks) {
        KeyTransformationHandler keyTransformationHandler = this.queryInterceptor.getKeyTransformationHandler();
        ArrayList<LuceneWork> transformedWorks = new ArrayList<LuceneWork>(luceneWorks.size());
        for (LuceneWork lw : luceneWorks) {
            LuceneWork transformedLuceneWork = ((LuceneWorkIdTransformer)lw.getWorkDelegate((WorkVisitor)LuceneWorkTransformationVisitor.INSTANCE)).cloneOverridingIdString(lw, keyTransformationHandler);
            transformedWorks.add(transformedLuceneWork);
        }
        return transformedWorks;
    }

    public byte getCommandId() {
        return 102;
    }

    public Object[] getParameters() {
        return new Object[]{this.indexName, this.serializedModel};
    }

    public void setParameters(int commandId, Object[] parameters) {
        this.indexName = (String)parameters[0];
        this.serializedModel = (byte[])parameters[1];
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        Cache cache = ci.getCacheManager().getCache(this.cacheName);
        SearchManager searchManager = Search.getSearchManager(cache);
        this.searchFactory = (SearchFactoryImplementor)searchManager.getSearchFactory();
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    public void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

