/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;

public class LuceneSortExternalizer
extends AbstractExternalizer<Sort> {
    public Set<Class<? extends Sort>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{Sort.class});
    }

    public Sort readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int count = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        SortField[] sortfields = new SortField[count];
        for (int i = 0; i < count; ++i) {
            sortfields[i] = LuceneSortFieldExternalizer.readObjectStatic(input);
        }
        Sort sort = new Sort();
        sort.setSort(sortfields);
        return sort;
    }

    public void writeObject(ObjectOutput output, Sort sort) throws IOException {
        SortField[] sortFields = sort.getSort();
        int count = sortFields.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)count);
        for (int i = 0; i < count; ++i) {
            LuceneSortFieldExternalizer.writeObjectStatic(output, sortFields[i]);
        }
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_SORT;
    }
}

