/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.search.backend.LuceneWork;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.affinity.ShardAddress;
import org.infinispan.query.affinity.ShardAllocatorManager;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.LogFactory;

class WorkPartitioner {
    private static final Log log = (Log)LogFactory.getLog(WorkPartitioner.class, Log.class);
    private final AffinityIndexManager affinityIndexManager;
    private final ShardAllocatorManager shardAllocatorManager;
    private final ShardAddress localShardAddress;
    private final String indexName;

    WorkPartitioner(AffinityIndexManager affinityIndexManager, ShardAllocatorManager shardAllocatorManager) {
        this.indexName = affinityIndexManager.getIndexName();
        this.localShardAddress = affinityIndexManager.getLocalShardAddress();
        this.affinityIndexManager = affinityIndexManager;
        this.shardAllocatorManager = shardAllocatorManager;
    }

    Map<ShardAddress, List<LuceneWork>> partitionWorkByAddress(Collection<LuceneWork> works, boolean originLocal, boolean isRetry) {
        return works.stream().collect(Collectors.toMap(w -> this.getLocation((LuceneWork)w, originLocal, isRetry), xva$0 -> WorkPartitioner.newList(xva$0), (w1, w2) -> {
            w1.addAll(w2);
            return w1;
        }));
    }

    private static String extractShardName(String indexName) {
        int idx = indexName.lastIndexOf(46);
        return idx == -1 ? "0" : indexName.substring(idx + 1);
    }

    private String getIndexName(String shardId) {
        return this.indexName.substring(0, this.indexName.lastIndexOf(46) + 1) + shardId;
    }

    @SafeVarargs
    private static <T> List<T> newList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    private ShardAddress getLocation(LuceneWork work, boolean originLocal, boolean isRetry) {
        log.debugf("Getting location for work %s at %s", work, this.localShardAddress);
        if (work.getIdInString() == null) {
            String shard = String.valueOf(WorkPartitioner.extractShardName(this.indexName));
            Address destination = isRetry ? this.affinityIndexManager.getLockHolder() : this.shardAllocatorManager.getOwner(shard);
            return new ShardAddress(shard, destination);
        }
        Object workKey = this.affinityIndexManager.stringToKey(work.getIdInString());
        String workShard = this.shardAllocatorManager.getShardFromKey(workKey);
        String workIndexName = this.getIndexName(workShard);
        Address workOwner = this.shardAllocatorManager.getOwner(workShard);
        if (isRetry || !originLocal) {
            Address lockHolder = this.affinityIndexManager.getLockHolder(workIndexName, workShard);
            if (lockHolder != null && !lockHolder.equals(this.localShardAddress.getAddress())) {
                return new ShardAddress(null, lockHolder);
            }
            return workIndexName.equals(this.indexName) ? this.localShardAddress : new ShardAddress(workIndexName, lockHolder);
        }
        if (workOwner.equals(this.localShardAddress.getAddress())) {
            return workIndexName.equals(this.indexName) ? this.localShardAddress : new ShardAddress(workIndexName, this.localShardAddress.getAddress());
        }
        return new ShardAddress(null, workOwner);
    }
}

