/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.query.dsl.embedded.impl.HsQueryRequest;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.logging.Log;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

public final class QueryDefinition {
    private static final Log log = (Log)LogFactory.getLog(QueryDefinition.class, Log.class);
    private final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider;
    private final String queryString;
    private HSQuery hsQuery;
    private int maxResults = 100;
    private int firstResult;
    private Set<String> sortableFields;
    private Class<?> indexedType;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>();
    private transient Sort sort;

    public QueryDefinition(String queryString, SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (queryEngineProvider == null) {
            throw new IllegalArgumentException("queryEngineProvider cannot be null");
        }
        this.queryString = queryString;
        this.queryEngineProvider = queryEngineProvider;
    }

    public QueryDefinition(HSQuery hsQuery) {
        if (hsQuery == null) {
            throw new IllegalArgumentException("hsQuery cannot be null");
        }
        this.hsQuery = hsQuery;
        this.queryString = null;
        this.queryEngineProvider = null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    private IndexedTypeMap<CustomTypeMetadata> createMetadata() {
        return IndexedTypeMaps.singletonMapping((IndexedTypeIdentifier)PojoIndexedTypeIdentifier.convertFromLegacy(this.indexedType), () -> this.sortableFields);
    }

    private QueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        if (this.queryEngineProvider == null) {
            throw new IllegalStateException("No query engine provider specified");
        }
        QueryEngine queryEngine = (QueryEngine)this.queryEngineProvider.apply(cache);
        if (queryEngine == null) {
            throw new IllegalStateException("The provider could not locate a suitable query engine");
        }
        return queryEngine;
    }

    public void initialize(AdvancedCache<?, ?> cache) {
        if (this.hsQuery == null) {
            HsQueryRequest hsQueryRequest;
            QueryEngine queryEngine = this.getQueryEngine(cache);
            if (this.indexedType != null && this.sortableFields != null) {
                IndexedTypeMap<CustomTypeMetadata> metadata = this.createMetadata();
                hsQueryRequest = queryEngine.createHsQuery(this.queryString, metadata, this.namedParameters);
            } else {
                hsQueryRequest = queryEngine.createHsQuery(this.queryString, null, this.namedParameters);
            }
            this.hsQuery = hsQueryRequest.getHsQuery();
            this.sort = hsQueryRequest.getSort();
            this.hsQuery.firstResult(this.firstResult);
            this.hsQuery.maxResults(this.maxResults);
            this.hsQuery.projection(hsQueryRequest.getProjections());
        }
    }

    public HSQuery getHsQuery() {
        if (this.hsQuery == null) {
            throw new IllegalStateException("The QueryDefinition has not been initialized, make sure to call initialize(...) first");
        }
        return this.hsQuery;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        if (this.hsQuery != null) {
            this.hsQuery.maxResults(maxResults);
        }
    }

    public void setNamedParameters(Map<String, Object> params) {
        if (params == null) {
            this.namedParameters.clear();
        } else {
            this.namedParameters.putAll(params);
        }
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        if (this.hsQuery != null) {
            this.hsQuery.firstResult(firstResult);
        }
        this.firstResult = firstResult;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        if (this.queryString != null) {
            throw log.sortNotSupportedWithQueryString();
        }
        this.hsQuery.sort(sort);
        this.sort = sort;
    }

    public void filter(Filter filter) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        this.hsQuery.filter(filter);
    }

    public FullTextFilter enableFullTextFilter(String name) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        return this.hsQuery.enableFullTextFilter(name);
    }

    public void disableFullTextFilter(String name) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        this.hsQuery.disableFullTextFilter(name);
    }

    public Set<String> getSortableFields() {
        return this.sortableFields;
    }

    public void setSortableField(Set<String> sortableField) {
        this.sortableFields = sortableField;
    }

    public Class<?> getIndexedType() {
        return this.indexedType;
    }

    public void setIndexedType(Class<?> indexedType) {
        this.indexedType = indexedType;
    }

    public static final class Externalizer
    implements AdvancedExternalizer<QueryDefinition> {
        public Set<Class<? extends QueryDefinition>> getTypeClasses() {
            return Collections.singleton(QueryDefinition.class);
        }

        public Integer getId() {
            return ExternalizerIds.QUERY_DEFINITION;
        }

        public void writeObject(ObjectOutput output, QueryDefinition queryDefinition) throws IOException {
            if (queryDefinition.queryString != null) {
                output.writeBoolean(true);
                output.writeUTF(queryDefinition.queryString);
                output.writeObject(queryDefinition.queryEngineProvider);
            } else {
                output.writeBoolean(false);
                output.writeObject(queryDefinition.hsQuery);
            }
            output.writeInt(queryDefinition.firstResult);
            output.writeInt(queryDefinition.maxResults);
            output.writeObject(queryDefinition.sortableFields);
            output.writeObject(queryDefinition.indexedType);
            Map namedParameters = queryDefinition.namedParameters;
            int paramSize = namedParameters.size();
            output.writeShort(paramSize);
            if (paramSize != 0) {
                for (Map.Entry param : namedParameters.entrySet()) {
                    output.writeUTF((String)param.getKey());
                    output.writeObject(param.getValue());
                }
            }
        }

        public QueryDefinition readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            QueryDefinition queryDefinition;
            if (input.readBoolean()) {
                String queryString = input.readUTF();
                SerializableFunction queryEngineProvider = (SerializableFunction)input.readObject();
                queryDefinition = new QueryDefinition(queryString, queryEngineProvider);
            } else {
                queryDefinition = new QueryDefinition((HSQuery)input.readObject());
            }
            queryDefinition.setFirstResult(input.readInt());
            queryDefinition.setMaxResults(input.readInt());
            Set sortableField = (Set)input.readObject();
            Class indexedTypes = (Class)input.readObject();
            queryDefinition.setSortableField(sortableField);
            queryDefinition.setIndexedType(indexedTypes);
            int paramSize = input.readShort();
            if (paramSize != 0) {
                HashMap<String, Object> params = new HashMap<String, Object>(paramSize);
                for (int i = 0; i < paramSize; ++i) {
                    String key = input.readUTF();
                    Object value = input.readObject();
                    params.put(key, value);
                }
                queryDefinition.setNamedParameters(params);
            }
            return queryDefinition;
        }
    }
}

