/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.query.backend.ExtendedSearchWorkCreator;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.NoTransactionContext;
import org.infinispan.query.backend.QueryKnownClasses;
import org.infinispan.query.backend.SearchFactoryHandler;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.SearchWorkCreatorContext;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.impl.DefaultSearchWorkCreator;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class QueryInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(QueryInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    static final Object UNKNOWN = new Object(){

        public String toString() {
            return "<UNKNOWN>";
        }
    };
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private RpcManager rpcManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.transport")
    private ExecutorService asyncExecutor;
    @Inject
    private InternalCacheRegistry internalCacheRegistry;
    private final IndexModificationStrategy indexingMode;
    private final SearchIntegrator searchFactory;
    private final KeyTransformationHandler keyTransformationHandler;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues;
    private QueryKnownClasses queryKnownClasses;
    private SearchWorkCreator searchWorkCreator = new DefaultSearchWorkCreator();
    private SearchFactoryHandler searchFactoryHandler;
    private final DataConversion valueDataConversion;
    private final DataConversion keyDataConversion;
    private boolean isPersistenceEnabled;
    private Class<?>[] indexedEntities;
    private final AdvancedCache<?, ?> cache;
    private final InvocationSuccessAction processClearCommand = this::processClearCommand;

    public QueryInterceptor(SearchIntegrator searchFactory, KeyTransformationHandler keyTransformationHandler, IndexModificationStrategy indexingMode, ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues, AdvancedCache<?, ?> cache) {
        this.searchFactory = searchFactory;
        this.keyTransformationHandler = keyTransformationHandler;
        this.indexingMode = indexingMode;
        this.txOldValues = txOldValues;
        this.cache = cache;
        this.valueDataConversion = cache.getValueDataConversion();
        this.keyDataConversion = cache.getKeyDataConversion();
    }

    @Start
    protected void start() {
        Set indexedEntities = this.cacheConfiguration.indexing().indexedEntities();
        this.indexedEntities = indexedEntities.isEmpty() ? null : indexedEntities.toArray(new Class[indexedEntities.size()]);
        this.queryKnownClasses = indexedEntities.isEmpty() ? new QueryKnownClasses(this.cache.getName(), this.cache.getCacheManager(), this.internalCacheRegistry) : new QueryKnownClasses(this.cache.getName(), indexedEntities);
        this.searchFactoryHandler = new SearchFactoryHandler(this.searchFactory, this.queryKnownClasses, new TransactionHelper(this.cache.getTransactionManager()));
        if (this.indexedEntities == null) {
            this.queryKnownClasses.start(this.searchFactoryHandler);
            Set<Class<?>> classes = this.queryKnownClasses.keys();
            Class[] classesArray = classes.toArray(new Class[classes.size()]);
            this.searchFactoryHandler.enableClasses(classesArray);
        }
        this.isPersistenceEnabled = this.cacheConfiguration.persistence().usingStores();
        this.stopping.set(false);
    }

    @Stop
    protected void stop() {
        this.queryKnownClasses.stop();
    }

    public void prepareForStopping() {
        this.stopping.set(true);
    }

    private boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, Object key) {
        return this.indexingMode.shouldModifyIndexes(command, ctx, this.distributionManager, this.rpcManager, key);
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object prev;
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (ctx.isInTxScope()) {
            if (!(entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue((WriteCommand)command))) {
                Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
                oldValues.putIfAbsent(command.getKey(), entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        Object object = prev = entry != null ? entry.getValue() : UNKNOWN;
        if (prev == null && this.unreliablePreviousValue((WriteCommand)command)) {
            prev = UNKNOWN;
        }
        Object oldValue = prev;
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            CacheEntry entry2;
            DataWriteCommand cmd = (DataWriteCommand)rCommand;
            if (!cmd.isSuccessful()) {
                return;
            }
            CacheEntry cacheEntry = entry2 = entry != null ? entry : rCtx.lookupEntry(cmd.getKey());
            if (entry2 != null && entry2.isChanged()) {
                this.processChange(rCtx, (FlagAffectedCommand)cmd, cmd.getKey(), oldValue, entry2.getValue(), NoTransactionContext.INSTANCE);
            }
        });
    }

    private Map<Object, Object> registerOldValues(TxInvocationContext ctx) {
        return this.txOldValues.computeIfAbsent(ctx.getGlobalTransaction(), gid -> {
            ctx.getCacheTransaction().addListener(() -> this.txOldValues.remove(gid));
            return new HashMap();
        });
    }

    private Object handleManyWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (ctx.isInTxScope()) {
            Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
            for (Object key : command.getAffectedKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
                oldValues.putIfAbsent(key, entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        HashMap oldValues = new HashMap();
        for (Object key : command.getAffectedKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
            oldValues.put(key, entry.getValue());
        }
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            WriteCommand cmd = (WriteCommand)rCommand;
            if (!cmd.isSuccessful()) {
                return;
            }
            for (Object key : cmd.getAffectedKeys()) {
                CacheEntry entry = rCtx.lookupEntry(key);
                if (entry == null || !entry.isChanged()) continue;
                Object oldValue = oldValues.getOrDefault(key, UNKNOWN);
                this.processChange(rCtx, (FlagAffectedCommand)cmd, key, oldValue, entry.getValue(), NoTransactionContext.INSTANCE);
            }
        });
    }

    private boolean unreliablePreviousValue(WriteCommand command) {
        return this.isPersistenceEnabled && (command.loadType() == VisitableCommand.LoadType.DONT_LOAD || command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD));
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, this.processClearCommand);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public void purgeAllIndexes() {
        this.purgeAllIndexes(NoTransactionContext.INSTANCE);
    }

    public void purgeIndex(Class<?> entityType) {
        this.purgeIndex(NoTransactionContext.INSTANCE, entityType);
    }

    void removeFromIndexes(TransactionContext transactionContext, Object key) {
        Stream<IndexedTypeIdentifier> typeIdentifiers = this.getKnownClasses().stream().filter(this.searchFactoryHandler::hasIndex).map(PojoIndexedTypeIdentifier::new);
        Set<Work> deleteWorks = typeIdentifiers.map(e -> this.searchWorkCreator.createEntityWork((Serializable)((Object)this.keyToString(key)), (IndexedTypeIdentifier)e, WorkType.DELETE)).collect(Collectors.toSet());
        this.performSearchWorks(deleteWorks, transactionContext);
    }

    private void purgeIndex(TransactionContext transactionContext, Class<?> entityType) {
        Boolean isIndexable = this.queryKnownClasses.get(entityType);
        if (isIndexable != null && isIndexable.booleanValue() && this.searchFactoryHandler.hasIndex(entityType)) {
            PojoIndexedTypeIdentifier type = new PojoIndexedTypeIdentifier(entityType);
            this.performSearchWorks(this.searchWorkCreator.createPerEntityTypeWorks((IndexedTypeIdentifier)type, WorkType.PURGE_ALL), transactionContext);
        }
    }

    private void purgeAllIndexes(TransactionContext transactionContext) {
        for (Class<?> c : this.queryKnownClasses.keys()) {
            if (!this.searchFactoryHandler.hasIndex(c)) continue;
            PojoIndexedTypeIdentifier type = new PojoIndexedTypeIdentifier(c);
            this.performSearchWorks(this.searchWorkCreator.createPerEntityTypeWorks((IndexedTypeIdentifier)type, WorkType.PURGE_ALL), transactionContext);
        }
    }

    private void removeFromIndexes(Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), WorkType.DELETE, transactionContext);
    }

    private void updateIndexes(boolean usingSkipIndexCleanupFlag, Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), usingSkipIndexCleanupFlag ? WorkType.ADD : WorkType.UPDATE, transactionContext);
    }

    private void performSearchWork(Object value, Serializable id, WorkType workType, TransactionContext transactionContext) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        Collection<Work> works = this.searchWorkCreator.createPerEntityWorks(value, id, workType);
        this.performSearchWorks(works, transactionContext);
    }

    private void performSearchWorks(Collection<Work> works, TransactionContext transactionContext) {
        Worker worker = this.searchFactory.getWorker();
        for (Work work : works) {
            worker.performWork(work, transactionContext);
        }
    }

    public Set<Class<?>> getKnownClasses() {
        return this.queryKnownClasses.keys();
    }

    private Object extractValue(Object storedValue) {
        return this.valueDataConversion.extractIndexable(storedValue);
    }

    private Object extractKey(Object storedKey) {
        return this.keyDataConversion.extractIndexable(storedKey);
    }

    public void enableClasses(Class ... classes) {
        this.searchFactoryHandler.enableClasses(classes);
    }

    private String keyToString(Object key) {
        return this.keyTransformationHandler.keyToString(this.extractKey(key));
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    public SearchWorkCreator getSearchWorkCreator() {
        return this.searchWorkCreator;
    }

    public void setSearchWorkCreator(SearchWorkCreator searchWorkCreator) {
        this.searchWorkCreator = searchWorkCreator;
    }

    void processChange(InvocationContext ctx, FlagAffectedCommand command, Object storedKey, Object storedOldValue, Object storedNewValue, TransactionContext transactionContext) {
        boolean skipIndexCleanup;
        Object key = this.extractKey(storedKey);
        Object oldValue = storedOldValue == UNKNOWN ? UNKNOWN : this.extractValue(storedOldValue);
        Object newValue = this.extractValue(storedNewValue);
        boolean bl = skipIndexCleanup = command != null && command.hasAnyFlag(FlagBitSets.SKIP_INDEX_CLEANUP);
        if (!skipIndexCleanup) {
            if (oldValue == UNKNOWN) {
                if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                    this.removeFromIndexes(transactionContext, key);
                }
            } else if (this.searchFactoryHandler.updateKnownTypesIfNeeded(oldValue) && (newValue == null || this.shouldRemove(newValue, oldValue)) && this.shouldModifyIndexes(command, ctx, storedKey)) {
                this.removeFromIndexes(oldValue, key, transactionContext);
            } else if (trace) {
                log.tracef("Index cleanup not needed for %s -> %s", oldValue, newValue);
            }
        } else if (trace) {
            log.tracef("Skipped index cleanup for command %s", (Object)command);
        }
        if (this.searchFactoryHandler.updateKnownTypesIfNeeded(newValue)) {
            if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                this.updateIndexes(skipIndexCleanup, newValue, key, transactionContext);
            } else if (trace) {
                log.tracef("Not modifying index for %s (%s)", storedKey, (Object)command);
            }
        } else if (trace) {
            log.tracef("Update not needed for %s", newValue);
        }
    }

    private boolean shouldRemove(Object value, Object previousValue) {
        if (this.searchWorkCreator instanceof ExtendedSearchWorkCreator) {
            ExtendedSearchWorkCreator eswc = (ExtendedSearchWorkCreator)this.searchWorkCreator;
            return eswc.shouldRemove(new SearchWorkCreatorContext(previousValue, value));
        }
        return value != null && previousValue != null && value.getClass() != previousValue.getClass();
    }

    private void processClearCommand(InvocationContext ctx, VisitableCommand command, Object rv) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)((ClearCommand)command), ctx, null)) {
            this.purgeAllIndexes(NoTransactionContext.INSTANCE);
        }
    }

    public IndexModificationStrategy getIndexModificationMode() {
        return this.indexingMode;
    }

    public boolean isStopping() {
        return this.stopping.get();
    }
}

