/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.FieldDoc;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneFieldDocExternalizer
extends AbstractExternalizer<FieldDoc> {
    public Set<Class<? extends FieldDoc>> getTypeClasses() {
        return Collections.singleton(FieldDoc.class);
    }

    public FieldDoc readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return LuceneFieldDocExternalizer.readObjectStatic(input);
    }

    public void writeObject(ObjectOutput output, FieldDoc sortField) throws IOException {
        LuceneFieldDocExternalizer.writeObjectStatic(output, sortField);
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_FIELD_SCORE_DOC;
    }

    static void writeObjectStatic(ObjectOutput output, FieldDoc sortField) throws IOException {
        output.writeFloat(sortField.score);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)sortField.doc);
        output.writeInt(sortField.shardIndex);
        Object[] fields = sortField.fields;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)fields.length);
        for (int i = 0; i < fields.length; ++i) {
            output.writeObject(fields[i]);
        }
    }

    static FieldDoc readObjectStatic(ObjectInput input) throws IOException, ClassNotFoundException {
        float score = input.readFloat();
        int doc = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        int shardId = input.readInt();
        int fieldsArrayLenght = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] fields = new Object[fieldsArrayLenght];
        for (int i = 0; i < fieldsArrayLenght; ++i) {
            fields[i] = input.readObject();
        }
        return new FieldDoc(doc, score, fields, shardId);
    }
}

