/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneTermQueryExternalizer
extends AbstractExternalizer<TermQuery> {
    public Set<Class<? extends TermQuery>> getTypeClasses() {
        return Collections.singleton(TermQuery.class);
    }

    public TermQuery readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        float boost = input.readFloat();
        Term term = (Term)input.readObject();
        TermQuery termQuery = new TermQuery(term);
        termQuery.setBoost(boost);
        return termQuery;
    }

    public void writeObject(ObjectOutput output, TermQuery query) throws IOException {
        output.writeFloat(query.getBoost());
        output.writeObject(query.getTerm());
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_QUERY_TERM;
    }
}

