/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;

public class LuceneTopFieldDocsExternalizer
extends AbstractExternalizer<TopFieldDocs> {
    public Set<Class<? extends TopFieldDocs>> getTypeClasses() {
        return Collections.singleton(TopFieldDocs.class);
    }

    public TopFieldDocs readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int totalHits = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        float maxScore = input.readFloat();
        int sortFieldsCount = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        SortField[] sortFields = new SortField[sortFieldsCount];
        for (int i = 0; i < sortFieldsCount; ++i) {
            sortFields[i] = LuceneSortFieldExternalizer.readObjectStatic(input);
        }
        int scoreDocsCount = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        ScoreDoc[] scoreDocs = new ScoreDoc[scoreDocsCount];
        for (int i = 0; i < scoreDocsCount; ++i) {
            scoreDocs[i] = (ScoreDoc)input.readObject();
        }
        return new TopFieldDocs(totalHits, scoreDocs, sortFields, maxScore);
    }

    public void writeObject(ObjectOutput output, TopFieldDocs topFieldDocs) throws IOException {
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)topFieldDocs.totalHits);
        output.writeFloat(topFieldDocs.getMaxScore());
        SortField[] sortFields = topFieldDocs.fields;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)sortFields.length);
        for (SortField sortField : sortFields) {
            LuceneSortFieldExternalizer.writeObjectStatic(output, sortField);
        }
        ScoreDoc[] scoreDocs = topFieldDocs.scoreDocs;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)scoreDocs.length);
        for (ScoreDoc scoreDoc : scoreDocs) {
            output.writeObject(scoreDoc);
        }
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_TOPFIELDDOCS;
    }
}

