/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.indexmanager.LazyInitializableBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockAcquiringBackend
implements IndexingBackend {
    private static final Log log = (Log)LogFactory.getLog(LockAcquiringBackend.class, Log.class);
    private static final int MAX_QUEUE_SIZE = Integer.getInteger("org.infinispan.query.indexmanager.LockAcquiringBackend.MAX_QUEUE_SIZE", 1000);
    private final BlockingQueue<Work> bufferedWork = new ArrayBlockingQueue<Work>(MAX_QUEUE_SIZE);
    private final LazyInitializableBackend clusteredSwitchingBackend;

    public LockAcquiringBackend(LazyInitializableBackend clusteredSwitchingBackend) {
        this.clusteredSwitchingBackend = clusteredSwitchingBackend;
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor, IndexManager indexManager) {
        log.trace("Attempting backend upgrade...");
        if (this.clusteredSwitchingBackend.attemptUpgrade(this)) {
            log.trace("... backend upgrade succeeded.");
            this.clusteredSwitchingBackend.getCurrentIndexingBackend().applyWork(workList, monitor, indexManager);
        } else {
            log.trace("... backend upgrade postponed.");
            this.enqueue(new TransactionWork(workList, monitor, indexManager));
        }
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor, IndexManager indexManager) {
        log.trace("Attempting backend upgrade...");
        if (this.clusteredSwitchingBackend.attemptUpgrade(this)) {
            log.trace("... backend upgrade succeeded.");
            this.clusteredSwitchingBackend.getCurrentIndexingBackend().applyStreamWork(singleOperation, monitor, indexManager);
        } else {
            log.trace("... backend upgrade postponed.");
            this.enqueue(new StreamWork(singleOperation, monitor, indexManager));
        }
    }

    private void enqueue(Work work) {
        boolean done;
        if (log.isDebugEnabled()) {
            int remainingCapacity = this.bufferedWork.remainingCapacity();
            log.debug("Need to enqueue on blocking buffer, remaining capacity to saturation: " + remainingCapacity);
        }
        if (!(done = this.bufferedWork.offer(work))) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer saturated: blocking");
            }
            try {
                this.bufferedWork.put(work);
                log.debug("Unblocked from wait on buffer");
            }
            catch (InterruptedException e) {
                log.interruptedWhileBufferingWork(e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void flushAndClose(IndexingBackend replacement) {
        if (replacement != null) {
            ArrayList all = new ArrayList(this.bufferedWork.size());
            this.bufferedWork.drainTo(all);
            for (Work w : all) {
                w.applyTo(replacement);
            }
        }
    }

    @Override
    public boolean isMasterLocal() {
        return false;
    }

    public String toString() {
        return "LockAcquiringBackend";
    }

    private static class TransactionWork
    implements Work {
        private final List<LuceneWork> workList;
        private final IndexingMonitor monitor;
        private final IndexManager indexManager;

        public TransactionWork(List<LuceneWork> workList, IndexingMonitor monitor, IndexManager indexManager) {
            this.workList = workList;
            this.monitor = monitor;
            this.indexManager = indexManager;
        }

        @Override
        public void applyTo(IndexingBackend target) {
            target.applyWork(this.workList, this.monitor, this.indexManager);
        }
    }

    private static class StreamWork
    implements Work {
        private final LuceneWork singleOperation;
        private final IndexingMonitor monitor;
        private final IndexManager indexManager;

        public StreamWork(LuceneWork singleOperation, IndexingMonitor monitor, IndexManager indexManager) {
            this.singleOperation = singleOperation;
            this.monitor = monitor;
            this.indexManager = indexManager;
        }

        @Override
        public void applyTo(IndexingBackend target) {
            target.applyStreamWork(this.singleOperation, this.monitor, this.indexManager);
        }
    }

    private static interface Work {
        public void applyTo(IndexingBackend var1);
    }
}

