/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.Serializable;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.massindex.DefaultMassIndexerProgressMonitor;
import org.infinispan.query.impl.massindex.ExtendedBatchBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexUpdater {
    private static final Log LOG = (Log)LogFactory.getLog(IndexUpdater.class, Log.class);
    private final SearchIntegrator searchIntegrator;
    private final KeyTransformationHandler keyTransformationHandler;
    private final ExtendedBatchBackend defaultBatchBackend;

    public IndexUpdater(SearchIntegrator searchIntegrator, KeyTransformationHandler keyTransformationHandler, TimeService timeService) {
        this.searchIntegrator = searchIntegrator;
        this.keyTransformationHandler = keyTransformationHandler;
        this.defaultBatchBackend = new ExtendedBatchBackend(searchIntegrator, new DefaultMassIndexerProgressMonitor(timeService));
    }

    public void flush(IndexedTypeIdentifier entity) {
        LOG.flushingIndex(entity.getName());
        this.defaultBatchBackend.flush(entity.asTypeSet());
    }

    public void purge(IndexedTypeIdentifier entity) {
        LOG.purgingIndex(entity.getName());
        this.defaultBatchBackend.purge(entity.asTypeSet());
    }

    public void waitForAsyncCompletion() {
        this.defaultBatchBackend.awaitAsyncProcessingCompletion();
    }

    public void updateIndex(Object key, Object value) {
        if (value != null && !Thread.currentThread().isInterrupted()) {
            EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.searchIntegrator.getIndexBindings().get((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(value.getClass()));
            if (entityIndexBinding == null) {
                return;
            }
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
            String idInString = this.keyTransformationHandler.keyToString(key);
            UpdateLuceneWork updateTask = docBuilder.createUpdateWork(null, docBuilder.getTypeIdentifier(), value, (Serializable)((Object)idInString), idInString, DefaultInstanceInitializer.DEFAULT_INITIALIZER, (ConversionContext)conversionContext);
            try {
                this.defaultBatchBackend.enqueueAsyncWork((LuceneWork)updateTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

