/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;

final class DelegatingSerializationContext
implements SerializationContext {
    private final ProtobufMetadataManagerImpl protobufMetadataManager;
    private final SerializationContext delegate;

    public DelegatingSerializationContext(ProtobufMetadataManagerImpl protobufMetadataManager) {
        this.protobufMetadataManager = protobufMetadataManager;
        this.delegate = protobufMetadataManager.getSerializationContext();
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void registerProtoFiles(FileDescriptorSource source) throws IOException {
        Map fileDescriptors = source.getFileDescriptors();
        HashMap<String, String> files = new HashMap<String, String>(fileDescriptors.size());
        for (String key : fileDescriptors.keySet()) {
            files.put(key, new String((char[])fileDescriptors.get(key)));
        }
        this.protobufMetadataManager.getCache().putAll(files);
    }

    public void unregisterProtoFile(String name) {
        this.protobufMetadataManager.getCache().remove((Object)name);
    }

    public Map<String, FileDescriptor> getFileDescriptors() {
        return this.delegate.getFileDescriptors();
    }

    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        this.delegate.registerMarshaller(marshaller);
    }

    public Descriptor getMessageDescriptor(String fullName) {
        return this.delegate.getMessageDescriptor(fullName);
    }

    public EnumDescriptor getEnumDescriptor(String fullName) {
        return this.delegate.getEnumDescriptor(fullName);
    }

    public boolean canMarshall(Class clazz) {
        return this.delegate.canMarshall(clazz);
    }

    public boolean canMarshall(String descriptorFullName) {
        return this.delegate.canMarshall(descriptorFullName);
    }

    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        return this.delegate.getMarshaller(descriptorFullName);
    }

    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.delegate.getMarshaller(clazz);
    }

    public String getTypeNameById(Integer typeId) {
        return this.delegate.getTypeNameById(typeId);
    }

    public GenericDescriptor getDescriptorByTypeId(Integer typeId) {
        return this.delegate.getDescriptorByTypeId(typeId);
    }

    public GenericDescriptor getDescriptorByName(String fullName) {
        return this.delegate.getDescriptorByName(fullName);
    }

    public Integer getTypeIdByName(String descriptorFullName) {
        return this.delegate.getTypeIdByName(descriptorFullName);
    }
}

