/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.query.remote.impl.ProtostreamWrapper;
import org.infinispan.query.remote.impl.RemoteQueryEngine;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.logging.Log;

class ProtobufRemoteQueryManager
implements RemoteQueryManager {
    private static final Log log = (Log)LogFactory.getLog(ProtobufRemoteQueryManager.class, Log.class);
    private final Matcher matcher;
    private final BaseRemoteQueryEngine queryEngine;
    private final SerializationContext serCtx;
    private final Encoder keyEncoder;
    private final Encoder valueEncoder;
    private final Transcoder transcoder;

    ProtobufRemoteQueryManager(SerializationContext serCtx, ComponentRegistry cr) {
        this.serCtx = serCtx;
        this.matcher = new ProtobufMatcher(serCtx, ProtobufFieldIndexingMetadata::new);
        cr.registerComponent((Object)this.matcher, ProtobufMatcher.class);
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        boolean isIndexed = ((Configuration)cr.getComponent(Configuration.class)).indexing().index().isEnabled();
        if (isIndexed) {
            DataConversion valueDataConversion = cache.getAdvancedCache().getValueDataConversion();
            valueDataConversion.overrideWrapper(ProtostreamWrapper.class, cr);
        }
        this.queryEngine = new RemoteQueryEngine(cache, isIndexed);
        this.keyEncoder = cache.getKeyDataConversion().getEncoder();
        this.valueEncoder = cache.getValueDataConversion().getEncoder();
        this.transcoder = ((EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class)).getTranscoder(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_JSON);
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest) {
        try {
            return (QueryRequest)ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.queryEngine.getSerializationContext(), (byte[])queryRequest, (int)0, (int)queryRequest.length, QueryRequest.class);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    @Override
    public byte[] encodeQueryResponse(QueryResponse queryResponse) {
        try {
            return ProtobufUtil.toByteArray((ImmutableSerializationContext)this.queryEngine.getSerializationContext(), (Object)queryResponse);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        try {
            return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.serCtx, (Object)filterResult);
        }
        catch (IOException e) {
            throw log.errorFiltering(e);
        }
    }

    @Override
    public Encoder getKeyEncoder() {
        return this.keyEncoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.valueEncoder;
    }

    @Override
    public List<Object> encodeQueryResults(List<Object> results) {
        return results.stream().map(o -> this.transcoder.transcode(o, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_JSON)).collect(Collectors.toList());
    }
}

