/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.ExternalizerIds;

public final class ProtobufValueWrapper
implements WrappedBytes {
    public static final IndexedTypeIdentifier INDEXING_TYPE = PojoIndexedTypeIdentifier.convertFromLegacy(ProtobufValueWrapper.class);
    private static final int MAX_BYTES_IN_TOSTRING = 40;
    private final byte[] binary;
    private int hashCode = 0;
    private Descriptor messageDescriptor;

    public ProtobufValueWrapper(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.binary = binary;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public void setMessageDescriptor(Descriptor messageDescriptor) {
        this.messageDescriptor = messageDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufValueWrapper that = (ProtobufValueWrapper)o;
        return Arrays.equals(this.binary, that.binary);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.binary);
        }
        return this.hashCode;
    }

    public String toString() {
        int len = Math.min(this.binary.length, 40);
        StringBuilder sb = new StringBuilder(50 + 3 * len);
        sb.append("ProtobufValueWrapper(length=").append(this.binary.length).append(", binary=[");
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(String.format("%02X", this.binary[i] & 0xFF));
        }
        if (len < this.binary.length) {
            sb.append("...");
        }
        sb.append("])");
        return sb.toString();
    }

    public byte[] getBytes() {
        return this.binary;
    }

    public int backArrayOffset() {
        return 0;
    }

    public int getLength() {
        return this.binary.length;
    }

    public byte getByte(int offset) {
        return this.binary[offset];
    }

    public static final class Externalizer
    extends AbstractExternalizer<ProtobufValueWrapper> {
        public void writeObject(ObjectOutput output, ProtobufValueWrapper protobufValueWrapper) throws IOException {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)protobufValueWrapper.binary.length);
            output.write(protobufValueWrapper.binary);
        }

        public ProtobufValueWrapper readObject(ObjectInput input) throws IOException {
            int length = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            byte[] binary = new byte[length];
            input.readFully(binary);
            return new ProtobufValueWrapper(binary);
        }

        public Integer getId() {
            return ExternalizerIds.PROTOBUF_VALUE_WRAPPER;
        }

        public Set<Class<? extends ProtobufValueWrapper>> getTypeClasses() {
            return Collections.singleton(ProtobufValueWrapper.class);
        }
    }
}

